/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import wile.engineerstools.ModEngineersTools;
import wile.engineerstools.blocks.AriadneCoalBlock;
import wile.engineerstools.items.AriadneCoalItem;
import wile.engineerstools.items.AutoStimPackItem;
import wile.engineerstools.items.ChargedLapisItem;
import wile.engineerstools.items.ChargedLapisSqueezerItem;
import wile.engineerstools.items.CrushingHammerItem;
import wile.engineerstools.items.DivingCapsuleItem;
import wile.engineerstools.items.GritItem;
import wile.engineerstools.items.MaterialBoxItem;
import wile.engineerstools.items.ModBlockItem;
import wile.engineerstools.items.MusliBarItem;
import wile.engineerstools.items.MusliBarPressItem;
import wile.engineerstools.items.RediaToolItem;
import wile.engineerstools.items.SleepingBagItem;
import wile.engineerstools.items.TrackerItem;

public class ModContent {
    private static final Logger LOGGER = ModEngineersTools.LOGGER;
    private static final String MODID = "engineerstools";
    private static final AbstractBlock.Properties coal_properties = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(3.0f, 50.0f).func_200947_a(SoundType.field_185851_d).func_200942_a().func_222380_e();
    public static final AriadneCoalBlock ARIADNE_COAL_X = (AriadneCoalBlock)new AriadneCoalBlock(coal_properties, Direction.Axis.X).setRegistryName(new ResourceLocation("engineerstools", "ariadne_coal_x"));
    public static final AriadneCoalBlock ARIADNE_COAL_Y = (AriadneCoalBlock)new AriadneCoalBlock(coal_properties, Direction.Axis.Y).setRegistryName(new ResourceLocation("engineerstools", "ariadne_coal_y"));
    public static final AriadneCoalBlock ARIADNE_COAL_Z = (AriadneCoalBlock)new AriadneCoalBlock(coal_properties, Direction.Axis.Z).setRegistryName(new ResourceLocation("engineerstools", "ariadne_coal_z"));
    private static final ArrayList<Block> modBlocks = new ArrayList();
    private static final TileEntityType<?>[] tile_entity_types;
    public static final RediaToolItem REDIA_TOOL;
    public static final CrushingHammerItem CRUSHING_HAMMER;
    public static final AriadneCoalItem ARIADNE_COAL;
    public static final AutoStimPackItem STIM_PACK;
    public static final DivingCapsuleItem DIVING_CAPSULE;
    public static final SleepingBagItem SLEEPING_BAG;
    public static final GritItem IRON_GRIT;
    public static final GritItem GOLD_GRIT;
    public static final MusliBarItem MUSLI_BAR;
    public static final MusliBarPressItem MUSLI_BAR_PRESS;
    public static final MaterialBoxItem MATERIAL_BAG;
    public static final TrackerItem TRACKER;
    public static final ChargedLapisItem CHARGED_LAPIS;
    public static final ChargedLapisSqueezerItem CHARGED_LAPIS_SQUEEZER;
    private static final Item[] modItems;
    public static final ContainerType<MusliBarPressItem.MusliBarPressContainer> CT_MUSLI_BAR_PRESS;
    public static final ContainerType<MaterialBoxItem.MaterialBoxContainer> CT_MATERIAL_BAG;
    private static final ContainerType<?>[] CONTAINER_TYPES;
    private static final ArrayList<Block> registeredBlocks;
    private static final ArrayList<Item> registeredItems;

    private static Item.Properties default_item_properties() {
        return new Item.Properties().func_200916_a(ModEngineersTools.ITEMGROUP);
    }

    private static <T extends Container> ContainerType<T> register(ContainerType.IFactory<T> factory, String regname) {
        ContainerType container_type = new ContainerType(factory);
        container_type.setRegistryName(new ResourceLocation(MODID, regname));
        return container_type;
    }

    public static ArrayList<Block> allBlocks() {
        return registeredBlocks;
    }

    @Nonnull
    public static List<Block> getRegisteredBlocks() {
        return Collections.unmodifiableList(registeredBlocks);
    }

    @Nonnull
    public static List<Item> getRegisteredItems() {
        return Collections.unmodifiableList(registeredItems);
    }

    public static final void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block e : registeredBlocks) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
        LOGGER.info("Registered " + Integer.toString(registeredBlocks.size()) + " blocks.");
    }

    public static final void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        for (TileEntityType<?> e : tile_entity_types) {
            event.getRegistry().register(e);
        }
        LOGGER.info("Registered " + Integer.toString(tile_entity_types.length) + " tile entities.");
    }

    public static final void registerItems(RegistryEvent.Register<Item> event) {
        for (Item e : registeredItems) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
        LOGGER.info("Registered " + Integer.toString(registeredItems.size()) + " items.");
    }

    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        for (ContainerType<?> e : CONTAINER_TYPES) {
            event.getRegistry().register(e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerGuis(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(CT_MUSLI_BAR_PRESS, MusliBarPressItem.MusliBarPressGui::new);
        ScreenManager.func_216911_a(CT_MATERIAL_BAG, MaterialBoxItem.MaterialBoxGui::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerModels() {
        TRACKER.registerModels();
    }

    public static void processContentClientSide(FMLClientSetupEvent event) {
        for (Block block : ModContent.getRegisteredBlocks()) {
            if (!(block instanceof AriadneCoalBlock)) continue;
            RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228645_f_());
        }
    }

    public static void processRegisteredContent() {
    }

    static {
        modBlocks.add(ARIADNE_COAL_X);
        modBlocks.add(ARIADNE_COAL_Y);
        modBlocks.add(ARIADNE_COAL_Z);
        tile_entity_types = new TileEntityType[0];
        REDIA_TOOL = (RediaToolItem)new RediaToolItem(ModContent.default_item_properties().func_200917_a(1).func_208103_a(Rarity.RARE)).setRegistryName(MODID, "redia_tool");
        CRUSHING_HAMMER = (CrushingHammerItem)new CrushingHammerItem(ModContent.default_item_properties().func_200917_a(1).func_208103_a(Rarity.UNCOMMON)).setRegistryName(MODID, "crushing_hammer");
        ARIADNE_COAL = (AriadneCoalItem)new AriadneCoalItem(ModContent.default_item_properties().func_200917_a(1).func_208103_a(Rarity.UNCOMMON)).setRegistryName(MODID, "ariadne_coal");
        STIM_PACK = (AutoStimPackItem)new AutoStimPackItem(ModContent.default_item_properties().func_200917_a(1).func_208103_a(Rarity.UNCOMMON)).setRegistryName(MODID, "stimpack");
        DIVING_CAPSULE = (DivingCapsuleItem)new DivingCapsuleItem(ModContent.default_item_properties().func_200917_a(1).func_208103_a(Rarity.UNCOMMON)).setRegistryName(MODID, "diving_capsule");
        SLEEPING_BAG = (SleepingBagItem)new SleepingBagItem(ModContent.default_item_properties().func_200917_a(1).func_208103_a(Rarity.UNCOMMON)).setRegistryName(MODID, "sleeping_bag");
        IRON_GRIT = (GritItem)new GritItem(ModContent.default_item_properties()).setRegistryName(MODID, "iron_grit");
        GOLD_GRIT = (GritItem)new GritItem(ModContent.default_item_properties()).setRegistryName(MODID, "gold_grit");
        MUSLI_BAR = (MusliBarItem)new MusliBarItem(ModContent.default_item_properties().func_208103_a(Rarity.COMMON)).setRegistryName(MODID, "musli_bar");
        MUSLI_BAR_PRESS = (MusliBarPressItem)new MusliBarPressItem(ModContent.default_item_properties().func_200917_a(1).func_208103_a(Rarity.UNCOMMON)).setRegistryName(MODID, "musli_bar_press");
        MATERIAL_BAG = (MaterialBoxItem)new MaterialBoxItem(ModContent.default_item_properties().func_208103_a(Rarity.UNCOMMON)).setRegistryName(MODID, "material_box");
        TRACKER = (TrackerItem)new TrackerItem(ModContent.default_item_properties().func_208103_a(Rarity.UNCOMMON)).setRegistryName(MODID, "tracker");
        CHARGED_LAPIS = (ChargedLapisItem)new ChargedLapisItem(ModContent.default_item_properties().func_208103_a(Rarity.UNCOMMON)).setRegistryName(MODID, "charged_lapis");
        CHARGED_LAPIS_SQUEEZER = (ChargedLapisSqueezerItem)new ChargedLapisSqueezerItem(ModContent.default_item_properties().func_208103_a(Rarity.UNCOMMON)).setRegistryName(MODID, "charged_lapis_squeezer");
        modItems = new Item[]{REDIA_TOOL, CRUSHING_HAMMER, TRACKER, ARIADNE_COAL, STIM_PACK, SLEEPING_BAG, MATERIAL_BAG, DIVING_CAPSULE, MUSLI_BAR_PRESS, MUSLI_BAR, CHARGED_LAPIS_SQUEEZER, CHARGED_LAPIS, IRON_GRIT, GOLD_GRIT};
        CT_MUSLI_BAR_PRESS = ModContent.register(MusliBarPressItem.MusliBarPressContainer::new, "ct_musli_bar_press");
        CT_MATERIAL_BAG = ModContent.register(MaterialBoxItem.MaterialBoxContainer::new, "ct_material_bag");
        CONTAINER_TYPES = new ContainerType[]{CT_MUSLI_BAR_PRESS, CT_MATERIAL_BAG};
        registeredBlocks = new ArrayList();
        registeredBlocks.addAll(modBlocks);
        registeredItems = new ArrayList();
        registeredItems.addAll(Arrays.asList(modItems));
        for (Block e : registeredBlocks) {
            registeredItems.add((Item)new ModBlockItem(e, new Item.Properties()).setRegistryName(e.getRegistryName()));
        }
    }
}

