/*
 * Decompiled with CFR 0.152.
 */
package com.epic312.enhanced_mushrooms.common.event;

import com.epic312.enhanced_mushrooms.common.world.biome.EnMushroomsBiomeFeatures;
import com.epic312.enhanced_mushrooms.core.registry.EnhancedMushroomsBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BonemealEventHandler {
    @SubscribeEvent
    public void bonemealEvent(BonemealEvent event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            BlockPos pos = event.getPos();
            BlockState block = event.getBlock();
            Random rand = new Random();
            if (block.func_177230_c() == Blocks.field_150337_Q || block.func_177230_c() == Blocks.field_150338_P || block.func_177230_c().getRegistryName().equals((Object)new ResourceLocation("quark", "glowshroom"))) {
                event.setResult(Event.Result.ALLOW);
                if (this.canUseBonemeal((World)world, rand, pos, block)) {
                    if (block.func_177230_c() == Blocks.field_150337_Q) {
                        world.func_175656_a(pos, ((Block)EnhancedMushroomsBlocks.RED_MUSHROOM_STEM.get()).func_176223_P());
                    } else if (block.func_177230_c() == Blocks.field_150338_P) {
                        world.func_175656_a(pos, ((Block)EnhancedMushroomsBlocks.BROWN_MUSHROOM_STEM.get()).func_176223_P());
                    } else if (block.func_177230_c().getRegistryName().equals((Object)new ResourceLocation("quark", "glowshroom"))) {
                        System.out.print("gamer\n");
                        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    }
                    this.mushroomGrowth(world, pos, block, rand);
                }
            }
        }
    }

    public boolean canUseBonemeal(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)rand.nextFloat() < 0.4;
    }

    public static boolean placeGlowshroom(World worldIn, Random rand, BlockPos pos) {
        int j;
        int i = rand.nextInt(3) + 4;
        if (rand.nextInt(12) == 0) {
            i *= 2;
        }
        if ((j = pos.func_177956_o()) >= 1 && j + i + 1 < 256) {
            Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (!block.getRegistryName().equals((Object)new ResourceLocation("quark", "glowcelium"))) {
                return false;
            }
            BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
            for (int k = 0; k <= i; ++k) {
                int l = 0;
                if (k < i && k >= i - 3) {
                    l = 2;
                } else if (k == i) {
                    l = 1;
                }
                for (int i1 = -l; i1 <= l; ++i1) {
                    for (int j1 = -l; j1 <= l; ++j1) {
                        BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_189533_g((Vec3i)pos).func_196234_d(i1, k, j1));
                        if (blockstate.isAir((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos) || blockstate.func_203425_a(BlockTags.field_206952_E)) continue;
                        return false;
                    }
                }
            }
            BlockState blockstate1 = (BlockState)((Block)EnhancedMushroomsBlocks.GLOWSHROOM_CAP.get()).func_176223_P().func_206870_a((IProperty)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false));
            for (int l1 = i - 3; l1 <= i; ++l1) {
                int i2 = l1 < i ? 2 : 1;
                for (int l2 = -i2; l2 <= i2; ++l2) {
                    for (int k1 = -i2; k1 <= i2; ++k1) {
                        boolean flag5;
                        boolean flag = l2 == -i2;
                        boolean flag1 = l2 == i2;
                        boolean flag2 = k1 == -i2;
                        boolean flag3 = k1 == i2;
                        boolean flag4 = flag || flag1;
                        boolean bl = flag5 = flag2 || flag3;
                        if (l1 < i && flag4 == flag5) continue;
                        blockpos$mutableblockpos.func_189533_g((Vec3i)pos).func_196234_d(l2, l1, k1);
                        if (!worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).canBeReplacedByLeaves((IWorldReader)worldIn, (BlockPos)blockpos$mutableblockpos)) continue;
                        worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockstate1.func_206870_a((IProperty)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(l1 >= i - 1))).func_206870_a((IProperty)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(l2 < 0))).func_206870_a((IProperty)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(l2 > 0))).func_206870_a((IProperty)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(k1 < 0))).func_206870_a((IProperty)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(k1 > 0)), 2);
                    }
                }
            }
            BlockState blockstate2 = ((Block)EnhancedMushroomsBlocks.GLOWSHROOM_STEM.get()).func_176223_P();
            for (int j2 = 0; j2 < i; ++j2) {
                blockpos$mutableblockpos.func_189533_g((Vec3i)pos).func_189534_c(Direction.UP, j2);
                if (!worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).canBeReplacedByLeaves((IWorldReader)worldIn, (BlockPos)blockpos$mutableblockpos)) continue;
                worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, blockstate2, 3);
            }
            return true;
        }
        return false;
    }

    public boolean mushroomGrowth(ServerWorld world, BlockPos pos, BlockState state, Random rand) {
        ConfiguredFeature configuredfeature;
        world.func_217377_a(pos, false);
        if (state.func_177230_c() == Blocks.field_150338_P) {
            configuredfeature = Feature.field_202319_S.func_225566_b_((IFeatureConfig)EnMushroomsBiomeFeatures.BROWN_MUSHROOM_CONFIG);
        } else if (state.func_177230_c() == Blocks.field_150337_Q) {
            configuredfeature = Feature.field_202318_R.func_225566_b_((IFeatureConfig)EnMushroomsBiomeFeatures.RED_MUSHROOM_CONFIG);
        } else {
            if (state.func_177230_c().getRegistryName().equals((Object)new ResourceLocation("quark", "glowshroom"))) {
                if (BonemealEventHandler.placeGlowshroom((World)world, rand, pos)) {
                    return true;
                }
                world.func_180501_a(pos, state, 3);
                return false;
            }
            world.func_180501_a(pos, state, 3);
            return false;
        }
        if (configuredfeature.func_222734_a((IWorld)world, world.func_72863_F().func_201711_g(), rand, pos)) {
            return true;
        }
        world.func_180501_a(pos, state, 3);
        return false;
    }
}

