/*
 * Decompiled with CFR 0.152.
 */
package com.epic312.enhanced_mushrooms.core.registry.util;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.abnormals_core.client.renderer.ChestItemRenderer;
import com.teamabnormals.abnormals_core.common.blocks.chest.AbnormalsChestBlock;
import com.teamabnormals.abnormals_core.common.blocks.chest.AbnormalsTrappedChestBlock;
import com.teamabnormals.abnormals_core.common.blocks.sign.AbnormalsStandingSignBlock;
import com.teamabnormals.abnormals_core.common.blocks.sign.AbnormalsWallSignBlock;
import com.teamabnormals.abnormals_core.common.items.AbnormalsBoatItem;
import com.teamabnormals.abnormals_core.common.items.AbnormalsSignItem;
import com.teamabnormals.abnormals_core.common.tileentity.AbnormalsChestTileEntity;
import com.teamabnormals.abnormals_core.common.tileentity.AbnormalsTrappedChestTileEntity;
import com.teamabnormals.abnormals_core.core.registry.BoatRegistry;
import com.teamabnormals.abnormals_core.core.utils.RegistryHelper;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;

public class EMRegistryHelper
extends RegistryHelper {
    public EMRegistryHelper(String modID) {
        super(modID);
    }

    public RegistryObject<Item> createCompatBoatItem(String modId, String wood, RegistryObject<Block> block) {
        ItemGroup determinedGroup = !ModList.get().isLoaded(modId) && modId != "indev" ? null : ItemGroup.field_78029_e;
        String type = this.getModId() + ":" + wood;
        RegistryObject boat = this.getDeferredItemRegister().register(wood + "_boat", () -> new AbnormalsBoatItem(type, EMRegistryHelper.createSimpleItemProperty((int)1, (ItemGroup)determinedGroup)));
        BoatRegistry.registerBoat((String)type, (RegistryObject)boat, block);
        return boat;
    }

    public Pair<RegistryObject<AbnormalsStandingSignBlock>, RegistryObject<AbnormalsWallSignBlock>> createCompatSignBlock(String modId, String name, MaterialColor color, Block.Properties properties) {
        ItemGroup determinedGroup = !ModList.get().isLoaded(modId) && modId != "indev" ? null : ItemGroup.field_78031_c;
        ResourceLocation texture = new ResourceLocation(this.getModId(), "textures/entity/signs/" + name + ".png");
        RegistryObject standing = this.getDeferredBlockRegister().register(name + "_sign", () -> new AbnormalsStandingSignBlock(properties, texture));
        RegistryObject wall = this.getDeferredBlockRegister().register(name + "_wall_sign", () -> new AbnormalsWallSignBlock(properties.func_222379_b((Block)standing.get()), texture));
        this.createItem(name + "_sign", () -> new AbnormalsSignItem((Block)standing.get(), (Block)wall.get(), new Item.Properties().func_200917_a(16).func_200916_a(determinedGroup)));
        return Pair.of((Object)standing, (Object)wall);
    }

    public <B extends Block> RegistryObject<B> createTwoCompatBlock(String modId, String modId2, String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        ItemGroup determinedGroup = (!ModList.get().isLoaded(modId) || !ModList.get().isLoaded(modId2)) && modId != "indev" ? null : group;
        return this.createBlock(name, supplier, determinedGroup);
    }

    public Pair<RegistryObject<AbnormalsChestBlock>, RegistryObject<AbnormalsTrappedChestBlock>> createCompatChestsWithProperties(String name, Block.Properties properties) {
        ItemGroup chestGroup = !ModList.get().isLoaded("quark") && this.getModId() != "indev" ? null : ItemGroup.field_78031_c;
        ItemGroup trappedChestGroup = !ModList.get().isLoaded("quark") && this.getModId() != "indev" ? null : ItemGroup.field_78028_d;
        RegistryObject chest = this.getDeferredBlockRegister().register(name + "_chest", () -> new AbnormalsChestBlock(this.getModId(), name, properties));
        RegistryObject trappedChest = this.getDeferredBlockRegister().register(name + "_trapped_chest", () -> new AbnormalsTrappedChestBlock(this.getModId(), name, properties));
        this.getDeferredItemRegister().register(name + "_chest", () -> new BlockItem((Block)chest.get(), new Item.Properties().func_200916_a(chestGroup).setISTER(() -> EMRegistryHelper.chestISTER())));
        this.getDeferredItemRegister().register(name + "_trapped_chest", () -> new BlockItem((Block)trappedChest.get(), new Item.Properties().func_200916_a(trappedChestGroup).setISTER(() -> EMRegistryHelper.trappedChestISTER())));
        return Pair.of((Object)chest, (Object)trappedChest);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> chestISTER() {
        return () -> new ChestItemRenderer(AbnormalsChestTileEntity::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> trappedChestISTER() {
        return () -> new ChestItemRenderer(AbnormalsTrappedChestTileEntity::new);
    }
}

