/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.enchantment;

import cofh.lib.enchantment.EnchantmentCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.references.EnsorcellationReferences;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FireRebukeEnchantment
extends EnchantmentCoFH {
    private static HashSet<Tuple<Entity, Integer>> AFFLICTED_ENTITIES = new HashSet();
    public static int chance = 20;
    public static boolean mobsAffectPlayers = false;

    public FireRebukeEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentType.ARMOR_CHEST, Constants.ARMOR_SLOTS);
        this.maxLevel = 3;
    }

    public int func_77321_a(int level) {
        return 5 + 15 * (level - 1);
    }

    protected int maxDelegate(int level) {
        return super.func_77321_a(level) + 50;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.enable && (item instanceof ArmorItem || item instanceof HorseArmorItem || item.isShield(stack, null) || this.supportsEnchantment(stack));
    }

    public boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != Enchantments.field_92091_k && ench != EnsorcellationReferences.DISPLACEMENT && ench != EnsorcellationReferences.FROST_REBUKE;
    }

    public void func_151367_b(LivingEntity user, Entity attacker, int level) {
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        Map.Entry stack = EnchantmentHelper.func_222189_b((Enchantment)EnsorcellationReferences.FIRE_REBUKE, (LivingEntity)user);
        if (FireRebukeEnchantment.shouldHit(level, user.func_70681_au())) {
            FireRebukeEnchantment.onHit(user, attacker, level);
            if (stack != null) {
                ((ItemStack)stack.getValue()).func_222118_a(2, user, consumer -> consumer.func_213361_c((EquipmentSlotType)stack.getKey()));
            }
        }
    }

    public static void onHit(LivingEntity user, Entity attacker, int level) {
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        if (user instanceof PlayerEntity || !(attacker instanceof PlayerEntity) || mobsAffectPlayers) {
            ((LivingEntity)attacker).func_70653_a((Entity)user, 0.5f * (float)level, user.field_70165_t - attacker.field_70165_t, user.field_70161_v - attacker.field_70161_v);
        }
        Random rand = user.func_70681_au();
        AFFLICTED_ENTITIES.add((Tuple<Entity, Integer>)new Tuple((Object)attacker, (Object)(1 + rand.nextInt(3 * level))));
        if (attacker.field_70170_p instanceof ServerWorld) {
            for (int j = 0; j < 3 * level; ++j) {
                Utils.spawnParticles((World)attacker.field_70170_p, (IParticleData)ParticleTypes.field_197631_x, (double)(attacker.field_70165_t + rand.nextDouble()), (double)(attacker.field_70163_u + 1.0 + rand.nextDouble()), (double)(attacker.field_70161_v + rand.nextDouble()), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            }
        }
    }

    public static boolean shouldHit(int level, Random rand) {
        return rand.nextInt(100) < chance * level;
    }

    public static void setFireToMobs() {
        if (AFFLICTED_ENTITIES.isEmpty()) {
            return;
        }
        for (Tuple<Entity, Integer> entry : AFFLICTED_ENTITIES) {
            ((Entity)entry.func_76341_a()).func_70015_d(((Integer)entry.func_76340_b()).intValue());
        }
        AFFLICTED_ENTITIES.clear();
    }
}

