/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.event;

import cofh.core.util.helpers.MathHelper;
import cofh.core.util.references.EnsorcReferences;
import cofh.ensorcellation.enchantment.DisplacementEnchantment;
import cofh.ensorcellation.enchantment.FireRebukeEnchantment;
import cofh.ensorcellation.enchantment.FrostRebukeEnchantment;
import cofh.ensorcellation.enchantment.override.FrostWalkerEnchantmentImp;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.FrostWalkerEnchantment;
import net.minecraft.enchantment.ThornsEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class HorseEnchEvents {
    private static final int HORSE_MODIFIER = 3;

    private HorseEnchEvents() {
    }

    @SubscribeEvent
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        if (!(entity instanceof AbstractHorseEntity)) {
            return;
        }
        ItemStack armor = ((AbstractHorseEntity)entity).field_110296_bG.func_70301_a(1);
        if (!armor.func_190926_b()) {
            int encFrostWalker = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185301_j, (ItemStack)armor);
            if (event.getSource().equals(DamageSource.field_190095_e) && encFrostWalker > 0) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        if (!(entity instanceof AbstractHorseEntity)) {
            return;
        }
        ItemStack armor = ((AbstractHorseEntity)entity).field_110296_bG.func_70301_a(1);
        if (!armor.func_190926_b()) {
            int encProtectionProjectile;
            int encProtectionExplosion;
            int encProtectionFall;
            int encProtectionFire;
            int totalProtection = 0;
            int encProtection = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180310_c, (ItemStack)armor);
            if (encProtection > 0) {
                totalProtection += Enchantments.field_180310_c.func_77318_a(encProtection, source);
            }
            if ((encProtectionFire = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77329_d, (ItemStack)armor)) > 0) {
                totalProtection += Enchantments.field_77329_d.func_77318_a(encProtection, source);
            }
            if ((encProtectionFall = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180309_e, (ItemStack)armor)) > 0) {
                totalProtection += Enchantments.field_180309_e.func_77318_a(encProtection, source);
            }
            if ((encProtectionExplosion = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185297_d, (ItemStack)armor)) > 0) {
                totalProtection += Enchantments.field_185297_d.func_77318_a(encProtection, source);
            }
            if ((encProtectionProjectile = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180308_g, (ItemStack)armor)) > 0) {
                totalProtection += Enchantments.field_180308_g.func_77318_a(encProtection, source);
            }
            float damageReduction = Math.min((float)(totalProtection * 3), 20.0f);
            event.setAmount(event.getAmount() * (1.0f - damageReduction / 25.0f));
            if (attacker != null) {
                int encFrostRebuke;
                int encFireRebuke;
                int encDisplacement;
                int encThorns = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)armor);
                if (ThornsEnchantment.func_92094_a((int)encThorns, (Random)entity.func_70681_au())) {
                    attacker.func_70097_a(DamageSource.func_92087_a((Entity)entity), (float)ThornsEnchantment.func_92095_b((int)encThorns, (Random)MathHelper.RANDOM));
                }
                if (DisplacementEnchantment.shouldHit(encDisplacement = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.DISPLACEMENT, (ItemStack)armor), entity.func_70681_au())) {
                    DisplacementEnchantment.onHit(entity, attacker, encDisplacement);
                }
                if (FireRebukeEnchantment.shouldHit(encFireRebuke = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.FIRE_REBUKE, (ItemStack)armor), entity.func_70681_au())) {
                    FireRebukeEnchantment.onHit(entity, attacker, encFireRebuke);
                }
                if (FrostRebukeEnchantment.shouldHit(encFrostRebuke = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.FROST_REBUKE, (ItemStack)armor), entity.func_70681_au())) {
                    FrostRebukeEnchantment.onHit(entity, attacker, encFrostRebuke);
                }
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        int encFrostWalker;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof AbstractHorseEntity)) {
            return;
        }
        ItemStack armor = ((AbstractHorseEntity)entity).field_110296_bG.func_70301_a(1);
        if (!armor.func_190926_b() && (encFrostWalker = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185301_j, (ItemStack)armor)) > 0) {
            FrostWalkerEnchantment.func_185266_a((LivingEntity)entity, (World)entity.field_70170_p, (BlockPos)entity.func_233580_cy_(), (int)encFrostWalker);
            FrostWalkerEnchantmentImp.freezeNearby(entity, entity.field_70170_p, entity.func_233580_cy_(), encFrostWalker);
        }
    }
}

