/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.event;

import cofh.core.util.Utils;
import cofh.core.util.references.EnsorcReferences;
import cofh.ensorcellation.enchantment.SoulboundEnchantment;
import java.util.Iterator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.GameRules;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class SoulboundEvents {
    private SoulboundEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePlayerDropsEvent(LivingDropsEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (Utils.isFakePlayer((Entity)player) || player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
                return;
            }
            Iterator iter = event.getDrops().iterator();
            while (iter.hasNext()) {
                ItemStack stack = ((ItemEntity)iter.next()).func_92059_d();
                if (EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.SOULBOUND, (ItemStack)stack) <= 0 || !Utils.addToPlayerInventory((PlayerEntity)player, (ItemStack)stack)) continue;
                iter.remove();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePlayerCloneEvent(PlayerEvent.Clone event) {
        int encSoulbound;
        ItemStack stack;
        int i;
        if (!event.isWasDeath()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        PlayerEntity oldPlayer = event.getOriginal();
        if (Utils.isFakePlayer((Entity)player) || player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            return;
        }
        for (i = 0; i < oldPlayer.field_71071_by.field_70460_b.size(); ++i) {
            stack = (ItemStack)oldPlayer.field_71071_by.field_70460_b.get(i);
            encSoulbound = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.SOULBOUND, (ItemStack)stack);
            if (encSoulbound <= 0) continue;
            if (SoulboundEnchantment.permanent) {
                if (encSoulbound > 1) {
                    Utils.removeEnchantment((ItemStack)stack, (Enchantment)EnsorcReferences.SOULBOUND);
                    Utils.addEnchantment((ItemStack)stack, (Enchantment)EnsorcReferences.SOULBOUND, (int)1);
                }
            } else if (player.field_70170_p.field_73012_v.nextInt(1 + encSoulbound) == 0) {
                Utils.removeEnchantment((ItemStack)stack, (Enchantment)EnsorcReferences.SOULBOUND);
                if (encSoulbound > 1) {
                    Utils.addEnchantment((ItemStack)stack, (Enchantment)EnsorcReferences.SOULBOUND, (int)(encSoulbound - 1));
                }
            }
            if (!Utils.addToPlayerInventory((PlayerEntity)player, (ItemStack)stack)) continue;
            oldPlayer.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < oldPlayer.field_71071_by.field_70462_a.size(); ++i) {
            stack = (ItemStack)oldPlayer.field_71071_by.field_70462_a.get(i);
            encSoulbound = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.SOULBOUND, (ItemStack)stack);
            if (encSoulbound <= 0) continue;
            if (SoulboundEnchantment.permanent) {
                if (encSoulbound > 1) {
                    Utils.removeEnchantment((ItemStack)stack, (Enchantment)EnsorcReferences.SOULBOUND);
                    Utils.addEnchantment((ItemStack)stack, (Enchantment)EnsorcReferences.SOULBOUND, (int)1);
                }
            } else if (player.field_70170_p.field_73012_v.nextInt(1 + encSoulbound) == 0) {
                Utils.removeEnchantment((ItemStack)stack, (Enchantment)EnsorcReferences.SOULBOUND);
                if (encSoulbound > 1) {
                    Utils.addEnchantment((ItemStack)stack, (Enchantment)EnsorcReferences.SOULBOUND, (int)(encSoulbound - 1));
                }
            }
            if (!Utils.addToPlayerInventory((PlayerEntity)player, (ItemStack)stack)) continue;
            oldPlayer.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
    }
}

