/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.init;

import cofh.core.enchantment.EnchantmentCoFH;
import cofh.core.util.references.EnsorcReferences;
import cofh.ensorcellation.enchantment.AnglerEnchantment;
import cofh.ensorcellation.enchantment.DamageVillagerEnchantment;
import cofh.ensorcellation.enchantment.DisplacementEnchantment;
import cofh.ensorcellation.enchantment.ExpBoostEnchantment;
import cofh.ensorcellation.enchantment.FireRebukeEnchantment;
import cofh.ensorcellation.enchantment.FrostRebukeEnchantment;
import cofh.ensorcellation.enchantment.HunterEnchantment;
import cofh.ensorcellation.enchantment.PilferingEnchantment;
import cofh.ensorcellation.enchantment.SoulboundEnchantment;
import cofh.ensorcellation.enchantment.VitalityEnchantment;
import cofh.ensorcellation.enchantment.VorpalEnchantment;
import cofh.ensorcellation.enchantment.override.FrostWalkerEnchantmentImp;
import cofh.ensorcellation.enchantment.override.MendingEnchantmentAlt;
import cofh.ensorcellation.enchantment.override.ThornsEnchantmentImp;
import net.minecraft.enchantment.Enchantments;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class EnsorcConfig {
    private static boolean registered = false;
    private static final ForgeConfigSpec.Builder SERVER_CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec.Builder CLIENT_CONFIG;
    private static ForgeConfigSpec clientSpec;
    public static boolean enableMendingOverride;
    private static ForgeConfigSpec.BooleanValue enableProtectionMagic;
    private static ForgeConfigSpec.BooleanValue treasureProtectionMagic;
    private static ForgeConfigSpec.IntValue levelProtectionMagic;
    private static ForgeConfigSpec.BooleanValue enableDisplacement;
    private static ForgeConfigSpec.BooleanValue treasureDisplacement;
    private static ForgeConfigSpec.IntValue levelDisplacement;
    private static ForgeConfigSpec.IntValue chanceDisplacement;
    private static ForgeConfigSpec.BooleanValue allowMobsDisplacement;
    private static ForgeConfigSpec.BooleanValue enableFireRebuke;
    private static ForgeConfigSpec.BooleanValue treasureFireRebuke;
    private static ForgeConfigSpec.IntValue levelFireRebuke;
    private static ForgeConfigSpec.IntValue chanceFireRebuke;
    private static ForgeConfigSpec.BooleanValue allowMobsFireRebuke;
    private static ForgeConfigSpec.BooleanValue enableFrostRebuke;
    private static ForgeConfigSpec.BooleanValue treasureFrostRebuke;
    private static ForgeConfigSpec.IntValue levelFrostRebuke;
    private static ForgeConfigSpec.IntValue chanceFrostRebuke;
    private static ForgeConfigSpec.BooleanValue allowMobsFrostRebuke;
    private static ForgeConfigSpec.BooleanValue enableAirAffinity;
    private static ForgeConfigSpec.BooleanValue treasureAirAffinity;
    private static ForgeConfigSpec.BooleanValue enableExpBoost;
    private static ForgeConfigSpec.BooleanValue treasureExpBoost;
    private static ForgeConfigSpec.IntValue levelExpBoost;
    private static ForgeConfigSpec.IntValue amountExpBoost;
    private static ForgeConfigSpec.BooleanValue enableGourmand;
    private static ForgeConfigSpec.BooleanValue treasureGourmand;
    private static ForgeConfigSpec.IntValue levelGourmand;
    private static ForgeConfigSpec.BooleanValue enableReach;
    private static ForgeConfigSpec.BooleanValue treasureReach;
    private static ForgeConfigSpec.IntValue levelReach;
    private static ForgeConfigSpec.BooleanValue enableVitality;
    private static ForgeConfigSpec.BooleanValue treasureVitality;
    private static ForgeConfigSpec.IntValue levelVitality;
    private static ForgeConfigSpec.IntValue healthLevelVitality;
    private static ForgeConfigSpec.BooleanValue enableDamageEnder;
    private static ForgeConfigSpec.BooleanValue treasureDamageEnder;
    private static ForgeConfigSpec.IntValue levelDamageEnder;
    private static ForgeConfigSpec.BooleanValue enableDamageIllager;
    private static ForgeConfigSpec.BooleanValue treasureDamageIllager;
    private static ForgeConfigSpec.IntValue levelDamageIllager;
    private static ForgeConfigSpec.BooleanValue enableDamageVillager;
    private static ForgeConfigSpec.BooleanValue treasureDamageVillager;
    private static ForgeConfigSpec.IntValue levelDamageVillager;
    private static ForgeConfigSpec.BooleanValue dropsDamageVillager;
    private static ForgeConfigSpec.BooleanValue enableCavalier;
    private static ForgeConfigSpec.BooleanValue treasureCavalier;
    private static ForgeConfigSpec.IntValue levelCavalier;
    private static ForgeConfigSpec.BooleanValue enableFrostAspect;
    private static ForgeConfigSpec.BooleanValue treasureFrostAspect;
    private static ForgeConfigSpec.IntValue levelFrostAspect;
    private static ForgeConfigSpec.BooleanValue enableLeech;
    private static ForgeConfigSpec.BooleanValue treasureLeech;
    private static ForgeConfigSpec.IntValue levelLeech;
    private static ForgeConfigSpec.BooleanValue enableMagicEdge;
    private static ForgeConfigSpec.BooleanValue treasureMagicEdge;
    private static ForgeConfigSpec.IntValue levelMagicEdge;
    private static ForgeConfigSpec.BooleanValue enableVorpal;
    private static ForgeConfigSpec.BooleanValue treasureVorpal;
    private static ForgeConfigSpec.IntValue levelVorpal;
    private static ForgeConfigSpec.IntValue critBaseVorpal;
    private static ForgeConfigSpec.IntValue critLevelVorpal;
    private static ForgeConfigSpec.IntValue critDamageVorpal;
    private static ForgeConfigSpec.IntValue headBaseVorpal;
    private static ForgeConfigSpec.IntValue headLevelVorpal;
    private static ForgeConfigSpec.BooleanValue enableExcavating;
    private static ForgeConfigSpec.BooleanValue treasureExcavating;
    private static ForgeConfigSpec.IntValue levelExcavating;
    private static ForgeConfigSpec.BooleanValue enableHunter;
    private static ForgeConfigSpec.BooleanValue treasureHunter;
    private static ForgeConfigSpec.IntValue levelHunter;
    private static ForgeConfigSpec.IntValue chanceHunter;
    private static ForgeConfigSpec.BooleanValue enableQuickDraw;
    private static ForgeConfigSpec.BooleanValue treasureQuickDraw;
    private static ForgeConfigSpec.IntValue levelQuickDraw;
    private static ForgeConfigSpec.BooleanValue enableTrueshot;
    private static ForgeConfigSpec.BooleanValue treasureTrueshot;
    private static ForgeConfigSpec.IntValue levelTrueshot;
    private static ForgeConfigSpec.BooleanValue enableVolley;
    private static ForgeConfigSpec.BooleanValue treasureVolley;
    private static ForgeConfigSpec.BooleanValue enableAngler;
    private static ForgeConfigSpec.BooleanValue treasureAngler;
    private static ForgeConfigSpec.IntValue levelAngler;
    private static ForgeConfigSpec.IntValue chanceAngler;
    private static ForgeConfigSpec.BooleanValue enablePilfering;
    private static ForgeConfigSpec.BooleanValue treasurePilfering;
    private static ForgeConfigSpec.BooleanValue playerStealPilfering;
    private static ForgeConfigSpec.BooleanValue enableFurrowing;
    private static ForgeConfigSpec.BooleanValue treasureFurrowing;
    private static ForgeConfigSpec.IntValue levelFurrowing;
    private static ForgeConfigSpec.BooleanValue enableTilling;
    private static ForgeConfigSpec.BooleanValue treasureTilling;
    private static ForgeConfigSpec.IntValue levelTilling;
    private static ForgeConfigSpec.BooleanValue enableWeeding;
    private static ForgeConfigSpec.BooleanValue treasureWeeding;
    private static ForgeConfigSpec.BooleanValue enableBulwark;
    private static ForgeConfigSpec.BooleanValue treasureBulwark;
    private static ForgeConfigSpec.BooleanValue enablePhalanx;
    private static ForgeConfigSpec.BooleanValue treasurePhalanx;
    private static ForgeConfigSpec.IntValue levelPhalanx;
    private static ForgeConfigSpec.BooleanValue enableSoulbound;
    private static ForgeConfigSpec.BooleanValue treasureSoulbound;
    private static ForgeConfigSpec.IntValue levelSoulbound;
    private static ForgeConfigSpec.BooleanValue permanentSoulbound;
    private static ForgeConfigSpec.BooleanValue enableCurseFool;
    private static ForgeConfigSpec.BooleanValue enableCurseMercy;
    private static ForgeConfigSpec.BooleanValue enableProtection;
    private static ForgeConfigSpec.IntValue levelProtection;
    private static ForgeConfigSpec.BooleanValue enableProtectionBlast;
    private static ForgeConfigSpec.IntValue levelProtectionBlast;
    private static ForgeConfigSpec.BooleanValue enableProtectionFall;
    private static ForgeConfigSpec.IntValue levelProtectionFall;
    private static ForgeConfigSpec.BooleanValue enableProtectionFire;
    private static ForgeConfigSpec.IntValue levelProtectionFire;
    private static ForgeConfigSpec.BooleanValue enableProtectionProjectile;
    private static ForgeConfigSpec.IntValue levelProtectionProjectile;
    private static ForgeConfigSpec.BooleanValue enableFireAspect;
    private static ForgeConfigSpec.IntValue levelFireAspect;
    private static ForgeConfigSpec.BooleanValue enableFrostWalker;
    private static ForgeConfigSpec.BooleanValue treasureFrostWalker;
    private static ForgeConfigSpec.IntValue levelFrostWalker;
    private static ForgeConfigSpec.BooleanValue enableFreezeLava;
    private static ForgeConfigSpec.BooleanValue enableKnockback;
    private static ForgeConfigSpec.IntValue levelKnockback;
    private static ForgeConfigSpec.BooleanValue enableLooting;
    private static ForgeConfigSpec.IntValue levelLooting;
    private static ForgeConfigSpec.BooleanValue enableThorns;
    private static ForgeConfigSpec.IntValue levelThorns;
    private static ForgeConfigSpec.IntValue chanceThorns;
    private static ForgeConfigSpec.BooleanValue alternateMending;
    private static ForgeConfigSpec.BooleanValue treasureMending;
    private static ForgeConfigSpec.IntValue damageMending;

    public static void register() {
        if (registered) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().register(EnsorcConfig.class);
        registered = true;
        EnsorcConfig.genServerConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
    }

    private EnsorcConfig() {
    }

    private static void genServerConfig() {
        EnsorcConfig.genEnchantmentConfig();
        EnsorcConfig.genOverrideConfig();
        serverSpec = SERVER_CONFIG.build();
        EnsorcConfig.refreshServerConfig();
    }

    private static void genClientConfig() {
        clientSpec = CLIENT_CONFIG.build();
        EnsorcConfig.refreshClientConfig();
    }

    private static void genEnchantmentConfig() {
        String treasure = "This sets whether or not the Enchantment is considered a 'treasure' enchantment.";
        String level = "This option adjusts the maximum allowable level for the Enchantment.";
        SERVER_CONFIG.push("Enchantments");
        SERVER_CONFIG.push("Magic Protection");
        enableProtectionMagic = SERVER_CONFIG.comment("If TRUE, the Magic Protection Enchantment is available for Armor and Horse Armor.").define("Enable", true);
        treasureProtectionMagic = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelProtectionMagic = SERVER_CONFIG.comment(level).defineInRange("Max Level", 4, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Displacement");
        enableDisplacement = SERVER_CONFIG.comment("If TRUE, the Displacement Enchantment is available for Armor, Shields, and Horse Armor.").define("Enable", true);
        treasureDisplacement = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelDisplacement = SERVER_CONFIG.comment(level).defineInRange("Max Level", 3, 1, 10);
        chanceDisplacement = SERVER_CONFIG.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 20, 1, 100);
        allowMobsDisplacement = SERVER_CONFIG.comment("If TRUE, mobs wearing armor with this Enchantment can teleport players.").define("Mobs Teleport Players", DisplacementEnchantment.mobsAffectPlayers);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Flaming Rebuke");
        enableFireRebuke = SERVER_CONFIG.comment("If TRUE, the Flaming Rebuke Enchantment is available for Armor, Shields, and Horse Armor.").define("Enable", true);
        treasureFireRebuke = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelFireRebuke = SERVER_CONFIG.comment(level).defineInRange("Max Level", 3, 1, 10);
        chanceFireRebuke = SERVER_CONFIG.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 20, 1, 100);
        allowMobsFireRebuke = SERVER_CONFIG.comment("If TRUE, mobs wearing armor with this Enchantment can knockback players.").define("Mobs Knockback Players", FireRebukeEnchantment.mobsAffectPlayers);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Chilling Rebuke");
        enableFrostRebuke = SERVER_CONFIG.comment("If TRUE, the Chilling Rebuke Enchantment is available for Armor, Shields, and Horse Armor.").define("Enable", true);
        treasureFrostRebuke = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelFrostRebuke = SERVER_CONFIG.comment(level).defineInRange("Max Level", 3, 1, 10);
        chanceFrostRebuke = SERVER_CONFIG.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 20, 1, 100);
        allowMobsFrostRebuke = SERVER_CONFIG.comment("If TRUE, mobs wearing armor with this Enchantment can knockback players.").define("Mobs Knockback Players", FrostRebukeEnchantment.mobsAffectPlayers);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Air Affinity");
        enableAirAffinity = SERVER_CONFIG.comment("If TRUE, the Air Affinity Enchantment is available for Helmets.").define("Enable", true);
        treasureAirAffinity = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Insight");
        enableExpBoost = SERVER_CONFIG.comment("If TRUE, the Insight Enchantment is available for Helmets.").define("Enable", true);
        treasureExpBoost = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelExpBoost = SERVER_CONFIG.comment(level).defineInRange("Max Level", 3, 1, 10);
        amountExpBoost = SERVER_CONFIG.comment("Adjust this to change the max experience awarded per level of the Enchantment.").defineInRange("Experience Amount", 4, 1, 1000);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Gourmand");
        enableGourmand = SERVER_CONFIG.comment("If TRUE, the Gourmand Enchantment is available for Helmets.").define("Enable", true);
        treasureGourmand = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelGourmand = SERVER_CONFIG.comment(level).defineInRange("Max Level", 2, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Reach");
        enableReach = SERVER_CONFIG.comment("If TRUE, the Reach Enchantment is available for Chestplates.").define("Enable", true);
        treasureReach = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelReach = SERVER_CONFIG.comment(level).defineInRange("Max Level", 3, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Vitality");
        enableVitality = SERVER_CONFIG.comment("If TRUE, the Vitality Enchantment is available for Chestplates.").define("Enable", true);
        treasureVitality = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelVitality = SERVER_CONFIG.comment(level).defineInRange("Max Level", 3, 1, 10);
        healthLevelVitality = SERVER_CONFIG.comment("Adjust this value to set the health granted level of the Enchantment. (There are 2 health per heart icon.)").defineInRange("Health / Level", 4, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Ender Disruption");
        enableDamageEnder = SERVER_CONFIG.comment("If TRUE, the Ender Disruption Enchantment is available for various Weapons.").define("Enable", true);
        treasureDamageEnder = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelDamageEnder = SERVER_CONFIG.comment(level).defineInRange("Max Level", 5, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Vigilante");
        enableDamageIllager = SERVER_CONFIG.comment("If TRUE, the Vigilante Enchantment is available for various Weapons.").define("Enable", true);
        treasureDamageIllager = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelDamageIllager = SERVER_CONFIG.comment(level).defineInRange("Max Level", 5, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Outlaw");
        enableDamageVillager = SERVER_CONFIG.comment("If TRUE, the Outlaw Enchantment is available for various Weapons.").define("Enable", true);
        treasureDamageVillager = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelDamageVillager = SERVER_CONFIG.comment(level).defineInRange("Max Level", 5, 1, 10);
        dropsDamageVillager = SERVER_CONFIG.comment("If TRUE, the Outlaw Enchantment causes Villagers (and Iron Golems) to drop Emeralds when killed.").define("Emerald Drops", true);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Cavalier");
        enableCavalier = SERVER_CONFIG.comment("If TRUE, the Cavalier Enchantment is available for various Weapons.").define("Enable", true);
        treasureCavalier = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelCavalier = SERVER_CONFIG.comment(level).defineInRange("Max Level", 3, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Frost Aspect");
        enableFrostAspect = SERVER_CONFIG.comment("If TRUE, the Frost Aspect Enchantment is available for various Weapons.").define("Enable", true);
        treasureFrostAspect = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelFrostAspect = SERVER_CONFIG.comment(level).defineInRange("Max Level", 2, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Leech");
        enableLeech = SERVER_CONFIG.comment("If TRUE, the Leech Enchantment is available for various Weapons.").define("Enable", true);
        treasureLeech = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelLeech = SERVER_CONFIG.comment(level).defineInRange("Max Level", 4, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Magic Edge");
        enableMagicEdge = SERVER_CONFIG.comment("If TRUE, the Magic Edge Enchantment is available for various Weapons.").define("Enable", true);
        treasureMagicEdge = SERVER_CONFIG.comment(treasure).define("Treasure", true);
        levelMagicEdge = SERVER_CONFIG.comment(level).defineInRange("Max Level", 3, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Vorpal");
        enableVorpal = SERVER_CONFIG.comment("If TRUE, the Vorpal Enchantment is available for various Weapons.").define("Enable", true);
        treasureVorpal = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelVorpal = SERVER_CONFIG.comment(level).defineInRange("Max Level", 3, 1, 10);
        critBaseVorpal = SERVER_CONFIG.comment("Adjust this value to set the base critical hit chance of the Enchantment (in percentage).").defineInRange("Base Critical Chance", 5, 1, 100);
        critLevelVorpal = SERVER_CONFIG.comment("Adjust this value to set the additional critical hit chance per level of the Enchantment (in percentage).").defineInRange("Critical Chance / Level", 5, 1, 100);
        critDamageVorpal = SERVER_CONFIG.comment("Adjust this value to set the critical hit damage multiplier.").defineInRange("Critical Damage Multiplier", 5, 2, 1000);
        headBaseVorpal = SERVER_CONFIG.comment("Adjust this value to set the base critical hit chance for the Enchantment (in percentage).").defineInRange("Base Head Drop Chance", 10, 1, 100);
        headLevelVorpal = SERVER_CONFIG.comment("Adjust this value to set the critical hit chance per level of the Enchantment (in percentage).").defineInRange("Head Drop Chance / Level", 10, 1, 100);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Excavating");
        enableExcavating = SERVER_CONFIG.comment("If TRUE, the Excavating Enchantment is available for various Tools.").define("Enable", true);
        treasureExcavating = SERVER_CONFIG.comment(treasure).define("Treasure", true);
        levelExcavating = SERVER_CONFIG.comment(level).defineInRange("Max Level", 2, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Hunter's Bounty");
        enableHunter = SERVER_CONFIG.comment("If TRUE, the Hunter's Bounty Enchantment is available for Bows.").define("Enable", true);
        treasureHunter = SERVER_CONFIG.comment(treasure).define("Treasure", true);
        levelHunter = SERVER_CONFIG.comment(level).defineInRange("Max Level", 2, 1, 10);
        chanceHunter = SERVER_CONFIG.comment("Adjust this value to set the chance of an additional drop per level of the Enchantment (in percentage).").defineInRange("Effect Chance", 50, 1, 100);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Quick Draw");
        enableQuickDraw = SERVER_CONFIG.comment("If TRUE, the Quick Draw Enchantment is available for various Bows.").define("Enable", true);
        treasureQuickDraw = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelQuickDraw = SERVER_CONFIG.comment(level).defineInRange("Max Level", 3, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Trueshot");
        enableTrueshot = SERVER_CONFIG.comment("If TRUE, the Trueshot Enchantment is available for various Bows.").define("Enable", true);
        treasureTrueshot = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelTrueshot = SERVER_CONFIG.comment(level).defineInRange("Max Level", 2, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Volley");
        enableVolley = SERVER_CONFIG.comment("If TRUE, the Volley Enchantment is available for various Bows.").define("Enable", true);
        treasureVolley = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Angler's Bounty");
        enableAngler = SERVER_CONFIG.comment("If TRUE, the Angler's Bounty Enchantment is available for Fishing Rods.").define("Enable", true);
        treasureAngler = SERVER_CONFIG.comment(treasure).define("Treasure", true);
        levelAngler = SERVER_CONFIG.comment(level).defineInRange("Max Level", 2, 1, 10);
        chanceAngler = SERVER_CONFIG.comment("Adjust this value to set the chance of an additional drop per level of the Enchantment (in percentage).").defineInRange("Effect Chance", 50, 1, 100);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Pilfering");
        enablePilfering = SERVER_CONFIG.comment("If TRUE, the Pilfering Enchantment is available for Fishing Rods.").define("Enable", true);
        treasurePilfering = SERVER_CONFIG.comment(treasure).define("Treasure", true);
        playerStealPilfering = SERVER_CONFIG.comment("This sets whether or not the Enchantment works on Players.").define("Allow Player Stealing", true);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Furrowing");
        enableFurrowing = SERVER_CONFIG.comment("If TRUE, the Furrowing Enchantment is available for Hoes.").define("Enable", true);
        treasureFurrowing = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelFurrowing = SERVER_CONFIG.comment(level).defineInRange("Max Level", 4, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Tilling");
        enableTilling = SERVER_CONFIG.comment("If TRUE, the Tilling Enchantment is available for Hoes.").define("Enable", true);
        treasureTilling = SERVER_CONFIG.comment(treasure).define("Treasure", true);
        levelTilling = SERVER_CONFIG.comment(level).defineInRange("Max Level", 4, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Weeding");
        enableWeeding = SERVER_CONFIG.comment("If TRUE, the Weeding Enchantment is available for Hoes.").define("Enable", true);
        treasureWeeding = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Bulwark");
        enableBulwark = SERVER_CONFIG.comment("If TRUE, the Bulwark Enchantment is available for Shields.").define("Enable", true);
        treasureBulwark = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Phalanx");
        enablePhalanx = SERVER_CONFIG.comment("If TRUE, the Phalanx Enchantment is available for Shields.").define("Enable", true);
        treasurePhalanx = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelPhalanx = SERVER_CONFIG.comment(level).defineInRange("Max Level", 2, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Soulbound");
        enableSoulbound = SERVER_CONFIG.comment("If TRUE, the Soulbound Enchantment is available.").define("Enable", true);
        treasureSoulbound = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelSoulbound = SERVER_CONFIG.comment("This option adjusts the maximum allowable level for the Enchantment. If permanent, this setting is ignored.").defineInRange("Max Level", 3, 1, 10);
        permanentSoulbound = SERVER_CONFIG.comment("If TRUE, the Soulbound Enchantment is permanent (and will remove excess levels when triggered).").define("Permanent", true);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Curse of Foolishness");
        enableCurseFool = SERVER_CONFIG.comment("If TRUE, the Curse of Foolishness Enchantment is available for various Tools and Weapons.").define("Enable", true);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Curse of Mercy");
        enableCurseMercy = SERVER_CONFIG.comment("If TRUE, the Curse of Mercy Enchantment is available for various Weapons.").define("Enable", true);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.pop();
    }

    private static void genOverrideConfig() {
        String treasure = "This sets whether or not the Enchantment is considered a 'treasure' enchantment.";
        String level = "This option adjusts the maximum allowable level for the Enchantment.";
        SERVER_CONFIG.push("Overrides");
        SERVER_CONFIG.push("Protection");
        enableProtection = SERVER_CONFIG.comment("If TRUE, the Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        levelProtection = SERVER_CONFIG.comment(level).defineInRange("Max Level", 4, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Blast Protection");
        enableProtectionBlast = SERVER_CONFIG.comment("If TRUE, the Blast Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        levelProtectionBlast = SERVER_CONFIG.comment(level).defineInRange("Max Level", 4, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Feather Falling");
        enableProtectionFall = SERVER_CONFIG.comment("If TRUE, the Feather Falling Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        levelProtectionFall = SERVER_CONFIG.comment(level).defineInRange("Max Level", 4, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Fire Protection");
        enableProtectionFire = SERVER_CONFIG.comment("If TRUE, the Fire Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        levelProtectionFire = SERVER_CONFIG.comment(level).defineInRange("Max Level", 4, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Projectile Protection");
        enableProtectionProjectile = SERVER_CONFIG.comment("If TRUE, the Projectile Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        levelProtectionProjectile = SERVER_CONFIG.comment(level).defineInRange("Max Level", 4, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Fire Aspect");
        enableFireAspect = SERVER_CONFIG.comment("If TRUE, the Fire Aspect Enchantment is replaced with a more configurable version which works on more items, such as Axes.").define("Enable", true);
        levelFireAspect = SERVER_CONFIG.comment(level).defineInRange("Max Level", 2, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Frost Walker");
        enableFrostWalker = SERVER_CONFIG.comment("If TRUE, the Frost Walker Enchantment is replaced with an improved and more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        treasureFrostWalker = SERVER_CONFIG.comment(treasure).define("Treasure", true);
        levelFrostWalker = SERVER_CONFIG.comment(level).defineInRange("Max Level", 2, 1, 10);
        enableFreezeLava = SERVER_CONFIG.comment("If TRUE, the Frost Walker Enchantment will also chill Lava into Glossed Magma.").define("Freeze Lava", true);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Knockback");
        enableKnockback = SERVER_CONFIG.comment("If TRUE, the Knockback Enchantment is replaced with a more configurable version which works on more items, such as Axes.").define("Enable", true);
        levelKnockback = SERVER_CONFIG.comment(level).defineInRange("Max Level", 2, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Looting");
        enableLooting = SERVER_CONFIG.comment("If TRUE, the Looting Enchantment is replaced with a more configurable version which works on more items, such as Axes.").define("Enable", true);
        levelLooting = SERVER_CONFIG.comment(level).defineInRange("Max Level", 3, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Thorns");
        enableThorns = SERVER_CONFIG.comment("If TRUE, the Thorns Enchantment is replaced with a more configurable version which works on more items, such as Shields and Horse Armor.").define("Enable", true);
        levelThorns = SERVER_CONFIG.comment(level).defineInRange("Max Level", 4, 1, 10);
        chanceThorns = SERVER_CONFIG.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 15, 1, 100);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Mending");
        alternateMending = SERVER_CONFIG.comment("If TRUE, the Mending Enchantment is replaced with a new Enchantment - Preservation. This enchantment allows you to repair items at an Anvil without paying an increasing XP cost for every time you repair it. Additionally, these repairs have a much lower chance of damaging the anvil.").define("Alternate Mending", false);
        treasureMending = SERVER_CONFIG.comment(treasure).define("Treasure", true);
        damageMending = SERVER_CONFIG.comment("Adjust this value to set the chance of an Anvil being damaged when used to repair an item with Preservation (in percentage). Only used if Alternate Mending (Preservation) is enabled.").defineInRange("Anvil Damage Chance", 3, 0, 12);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.pop();
    }

    private static void refreshServerConfig() {
        enableMendingOverride = (Boolean)alternateMending.get();
        EnsorcConfig.refreshEnchantmentConfig();
        EnsorcConfig.refreshOverrideConfig();
        EnsorcConfig.refreshPotionConfig();
    }

    private static void refreshClientConfig() {
    }

    private static void refreshEnchantmentConfig() {
        if (EnsorcReferences.PROTECTION_MAGIC instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.PROTECTION_MAGIC).setEnable(((Boolean)enableProtectionMagic.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.PROTECTION_MAGIC).setTreasure(((Boolean)treasureProtectionMagic.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.PROTECTION_MAGIC).setMaxLevel(((Integer)levelProtectionMagic.get()).intValue());
        }
        if (EnsorcReferences.DISPLACEMENT instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.DISPLACEMENT).setEnable(((Boolean)enableDisplacement.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DISPLACEMENT).setTreasure(((Boolean)treasureDisplacement.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DISPLACEMENT).setMaxLevel(((Integer)levelDisplacement.get()).intValue());
            DisplacementEnchantment.chance = (Integer)chanceDisplacement.get();
            DisplacementEnchantment.mobsAffectPlayers = (Boolean)allowMobsDisplacement.get();
        }
        if (EnsorcReferences.FIRE_REBUKE instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.FIRE_REBUKE).setEnable(((Boolean)enableFireRebuke.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FIRE_REBUKE).setTreasure(((Boolean)treasureFireRebuke.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FIRE_REBUKE).setMaxLevel(((Integer)levelFireRebuke.get()).intValue());
            FireRebukeEnchantment.chance = (Integer)chanceFireRebuke.get();
            FireRebukeEnchantment.mobsAffectPlayers = (Boolean)allowMobsFireRebuke.get();
        }
        if (EnsorcReferences.FROST_REBUKE instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.FROST_REBUKE).setEnable(((Boolean)enableFrostRebuke.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FROST_REBUKE).setTreasure(((Boolean)treasureFrostRebuke.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FROST_REBUKE).setMaxLevel(((Integer)levelFrostRebuke.get()).intValue());
            FrostRebukeEnchantment.chance = (Integer)chanceFrostRebuke.get();
            FrostRebukeEnchantment.mobsAffectPlayers = (Boolean)allowMobsFrostRebuke.get();
        }
        if (EnsorcReferences.AIR_AFFINITY instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.AIR_AFFINITY).setEnable(((Boolean)enableAirAffinity.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.AIR_AFFINITY).setTreasure(((Boolean)treasureAirAffinity.get()).booleanValue());
        }
        if (EnsorcReferences.EXP_BOOST instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.EXP_BOOST).setEnable(((Boolean)enableExpBoost.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.EXP_BOOST).setTreasure(((Boolean)treasureExpBoost.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.EXP_BOOST).setMaxLevel(((Integer)levelExpBoost.get()).intValue());
            ExpBoostEnchantment.experience = (Integer)amountExpBoost.get();
        }
        if (EnsorcReferences.GOURMAND instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.GOURMAND).setEnable(((Boolean)enableGourmand.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.GOURMAND).setTreasure(((Boolean)treasureGourmand.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.GOURMAND).setMaxLevel(((Integer)levelGourmand.get()).intValue());
        }
        if (EnsorcReferences.REACH instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.REACH).setEnable(((Boolean)enableReach.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.REACH).setTreasure(((Boolean)treasureReach.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.REACH).setMaxLevel(((Integer)levelReach.get()).intValue());
        }
        if (EnsorcReferences.VITALITY instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.VITALITY).setEnable(((Boolean)enableVitality.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.VITALITY).setTreasure(((Boolean)treasureVitality.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.VITALITY).setMaxLevel(((Integer)levelVitality.get()).intValue());
            VitalityEnchantment.health = (Integer)healthLevelVitality.get();
        }
        if (EnsorcReferences.DAMAGE_ENDER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ENDER).setEnable(((Boolean)enableDamageEnder.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ENDER).setTreasure(((Boolean)treasureDamageEnder.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ENDER).setMaxLevel(((Integer)levelDamageEnder.get()).intValue());
        }
        if (EnsorcReferences.DAMAGE_ILLAGER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ILLAGER).setEnable(((Boolean)enableDamageIllager.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ILLAGER).setTreasure(((Boolean)treasureDamageIllager.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ILLAGER).setMaxLevel(((Integer)levelDamageIllager.get()).intValue());
        }
        if (EnsorcReferences.DAMAGE_VILLAGER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_VILLAGER).setEnable(((Boolean)enableDamageVillager.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_VILLAGER).setTreasure(((Boolean)treasureDamageVillager.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_VILLAGER).setMaxLevel(((Integer)levelDamageVillager.get()).intValue());
            DamageVillagerEnchantment.enableEmeraldDrops = (Boolean)dropsDamageVillager.get();
        }
        if (EnsorcReferences.CAVALIER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.CAVALIER).setEnable(((Boolean)enableCavalier.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.CAVALIER).setTreasure(((Boolean)treasureCavalier.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.CAVALIER).setMaxLevel(((Integer)levelCavalier.get()).intValue());
        }
        if (EnsorcReferences.FROST_ASPECT instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.FROST_ASPECT).setEnable(((Boolean)enableFrostAspect.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FROST_ASPECT).setTreasure(((Boolean)treasureFrostAspect.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FROST_ASPECT).setMaxLevel(((Integer)levelFrostAspect.get()).intValue());
        }
        if (EnsorcReferences.LEECH instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.LEECH).setEnable(((Boolean)enableLeech.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.LEECH).setTreasure(((Boolean)treasureLeech.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.LEECH).setMaxLevel(((Integer)levelLeech.get()).intValue());
        }
        if (EnsorcReferences.MAGIC_EDGE instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.MAGIC_EDGE).setEnable(((Boolean)enableMagicEdge.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.MAGIC_EDGE).setTreasure(((Boolean)treasureMagicEdge.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.MAGIC_EDGE).setMaxLevel(((Integer)levelMagicEdge.get()).intValue());
        }
        if (EnsorcReferences.VORPAL instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.VORPAL).setEnable(((Boolean)enableVorpal.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.VORPAL).setTreasure(((Boolean)treasureVorpal.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.VORPAL).setMaxLevel(((Integer)levelVorpal.get()).intValue());
            VorpalEnchantment.critBase = (Integer)critBaseVorpal.get();
            VorpalEnchantment.critLevel = (Integer)critLevelVorpal.get();
            VorpalEnchantment.critDamage = (Integer)critDamageVorpal.get();
            VorpalEnchantment.headBase = (Integer)headBaseVorpal.get();
            VorpalEnchantment.headLevel = (Integer)headLevelVorpal.get();
        }
        if (EnsorcReferences.EXCAVATING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.EXCAVATING).setEnable(((Boolean)enableExcavating.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.EXCAVATING).setTreasure(((Boolean)treasureExcavating.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.EXCAVATING).setMaxLevel(((Integer)levelExcavating.get()).intValue());
        }
        if (EnsorcReferences.HUNTER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.HUNTER).setEnable(((Boolean)enableHunter.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.HUNTER).setTreasure(((Boolean)treasureHunter.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.HUNTER).setMaxLevel(((Integer)levelHunter.get()).intValue());
            HunterEnchantment.chance = (Integer)chanceHunter.get();
        }
        if (EnsorcReferences.QUICK_DRAW instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.QUICK_DRAW).setEnable(((Boolean)enableQuickDraw.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.QUICK_DRAW).setTreasure(((Boolean)treasureQuickDraw.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.QUICK_DRAW).setMaxLevel(((Integer)levelQuickDraw.get()).intValue());
        }
        if (EnsorcReferences.TRUESHOT instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.TRUESHOT).setEnable(((Boolean)enableTrueshot.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.TRUESHOT).setTreasure(((Boolean)treasureTrueshot.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.TRUESHOT).setMaxLevel(((Integer)levelTrueshot.get()).intValue());
        }
        if (EnsorcReferences.VOLLEY instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.VOLLEY).setEnable(((Boolean)enableVolley.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.VOLLEY).setTreasure(((Boolean)treasureVolley.get()).booleanValue());
        }
        if (EnsorcReferences.ANGLER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.ANGLER).setEnable(((Boolean)enableAngler.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.ANGLER).setTreasure(((Boolean)treasureAngler.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.ANGLER).setMaxLevel(((Integer)levelAngler.get()).intValue());
            AnglerEnchantment.chance = (Integer)chanceAngler.get();
        }
        if (EnsorcReferences.PILFERING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.PILFERING).setEnable(((Boolean)enablePilfering.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.PILFERING).setTreasure(((Boolean)treasurePilfering.get()).booleanValue());
            PilferingEnchantment.allowPlayerStealing = (Boolean)playerStealPilfering.get();
        }
        if (EnsorcReferences.FURROWING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.FURROWING).setEnable(((Boolean)enableFurrowing.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FURROWING).setTreasure(((Boolean)treasureFurrowing.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FURROWING).setMaxLevel(((Integer)levelFurrowing.get()).intValue());
        }
        if (EnsorcReferences.TILLING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.TILLING).setEnable(((Boolean)enableTilling.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.TILLING).setTreasure(((Boolean)treasureTilling.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.TILLING).setMaxLevel(((Integer)levelTilling.get()).intValue());
        }
        if (EnsorcReferences.WEEDING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.WEEDING).setEnable(((Boolean)enableWeeding.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.WEEDING).setTreasure(((Boolean)treasureWeeding.get()).booleanValue());
        }
        if (EnsorcReferences.BULWARK instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.BULWARK).setEnable(((Boolean)enableBulwark.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.BULWARK).setTreasure(((Boolean)treasureBulwark.get()).booleanValue());
        }
        if (EnsorcReferences.PHALANX instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.PHALANX).setEnable(((Boolean)enablePhalanx.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.PHALANX).setTreasure(((Boolean)treasurePhalanx.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.PHALANX).setMaxLevel(((Integer)levelPhalanx.get()).intValue());
        }
        if (EnsorcReferences.SOULBOUND instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.SOULBOUND).setEnable(((Boolean)enableSoulbound.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.SOULBOUND).setTreasure(((Boolean)treasureSoulbound.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.SOULBOUND).setMaxLevel(((Integer)levelSoulbound.get()).intValue());
            SoulboundEnchantment.permanent = (Boolean)permanentSoulbound.get();
        }
        if (EnsorcReferences.CURSE_FOOL instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.CURSE_FOOL).setEnable(((Boolean)enableCurseFool.get()).booleanValue());
        }
        if (EnsorcReferences.CURSE_MERCY instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.CURSE_MERCY).setEnable(((Boolean)enableCurseMercy.get()).booleanValue());
        }
    }

    private static void refreshOverrideConfig() {
        if (Enchantments.field_180310_c instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.field_180310_c).setEnable(((Boolean)enableProtection.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_180310_c).setMaxLevel(((Integer)levelProtection.get()).intValue());
        }
        if (Enchantments.field_185297_d instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.field_185297_d).setEnable(((Boolean)enableProtectionBlast.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_185297_d).setMaxLevel(((Integer)levelProtectionBlast.get()).intValue());
        }
        if (Enchantments.field_180309_e instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.field_180309_e).setEnable(((Boolean)enableProtectionFall.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_180309_e).setMaxLevel(((Integer)levelProtectionFall.get()).intValue());
        }
        if (Enchantments.field_77329_d instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.field_77329_d).setEnable(((Boolean)enableProtectionFire.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_77329_d).setMaxLevel(((Integer)levelProtectionFire.get()).intValue());
        }
        if (Enchantments.field_180308_g instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.field_180308_g).setEnable(((Boolean)enableProtectionProjectile.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_180308_g).setMaxLevel(((Integer)levelProtectionProjectile.get()).intValue());
        }
        if (Enchantments.field_77334_n instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.field_77334_n).setEnable(((Boolean)enableFireAspect.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_77334_n).setMaxLevel(((Integer)levelFireAspect.get()).intValue());
        }
        if (Enchantments.field_185301_j instanceof FrostWalkerEnchantmentImp) {
            ((EnchantmentCoFH)Enchantments.field_185301_j).setEnable(((Boolean)enableFrostWalker.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_185301_j).setTreasure(((Boolean)treasureFrostWalker.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_185301_j).setMaxLevel(((Integer)levelFrostWalker.get()).intValue());
            ((FrostWalkerEnchantmentImp)Enchantments.field_185301_j).setFreezeLava((Boolean)enableFreezeLava.get());
        }
        if (Enchantments.field_180313_o instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.field_180313_o).setEnable(((Boolean)enableKnockback.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_180313_o).setMaxLevel(((Integer)levelKnockback.get()).intValue());
        }
        if (Enchantments.field_185304_p instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.field_185304_p).setEnable(((Boolean)enableLooting.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_185304_p).setMaxLevel(((Integer)levelLooting.get()).intValue());
        }
        if (Enchantments.field_92091_k instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.field_92091_k).setEnable(((Boolean)enableThorns.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_92091_k).setMaxLevel(((Integer)levelThorns.get()).intValue());
            ThornsEnchantmentImp.chance = (Integer)chanceThorns.get();
        }
        if (Enchantments.field_185296_A instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.field_185296_A).setEnable(((Boolean)alternateMending.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.field_185296_A).setTreasure(((Boolean)treasureMending.get()).booleanValue());
            MendingEnchantmentAlt.anvilDamage = (float)((Integer)damageMending.get()).intValue() / 100.0f;
        }
    }

    private static void refreshPotionConfig() {
    }

    @SubscribeEvent
    public static void configLoading(ModConfig.Loading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                EnsorcConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                EnsorcConfig.refreshServerConfig();
            }
        }
    }

    @SubscribeEvent
    public static void configReloading(ModConfig.Reloading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                EnsorcConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                EnsorcConfig.refreshServerConfig();
            }
        }
    }

    static {
        CLIENT_CONFIG = new ForgeConfigSpec.Builder();
        enableMendingOverride = false;
    }
}

