/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.gui.component;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import me.paulf.fairylights.client.gui.EditLetteredConnectionScreen;
import me.paulf.fairylights.client.gui.component.ColorButton;
import me.paulf.fairylights.util.Mth;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.ArrayUtils;

public class PaletteButton
extends Button {
    private static final int TEX_U = 0;
    private static final int TEX_V = 40;
    private static final int SELECT_U = 28;
    private static final int SELECT_V = 40;
    private static final int COLOR_U = 34;
    private static final int COLOR_V = 40;
    private static final int COLOR_WIDTH = 6;
    private static final int COLOR_HEIGHT = 6;
    private static final TextFormatting[] IDX_COLOR = new TextFormatting[]{TextFormatting.WHITE, TextFormatting.GRAY, TextFormatting.DARK_GRAY, TextFormatting.BLACK, TextFormatting.RED, TextFormatting.DARK_RED, TextFormatting.YELLOW, TextFormatting.GOLD, TextFormatting.LIGHT_PURPLE, TextFormatting.DARK_PURPLE, TextFormatting.GREEN, TextFormatting.DARK_GREEN, TextFormatting.BLUE, TextFormatting.DARK_BLUE, TextFormatting.AQUA, TextFormatting.DARK_AQUA};
    private static final int[] COLOR_IDX = Mth.invertMap(IDX_COLOR, Enum::ordinal);
    private final ColorButton colorBtn;

    public PaletteButton(int x, int y, ColorButton colorBtn, String msg, Button.IPressable pressable) {
        super(x, y, 28, 28, msg, pressable);
        this.colorBtn = colorBtn;
    }

    public void onPress() {
        this.colorBtn.setDisplayColor(IDX_COLOR[(ArrayUtils.indexOf((Object[])IDX_COLOR, (Object)this.colorBtn.getDisplayColor()) + 1) % IDX_COLOR.length]);
        super.onPress();
    }

    public void onClick(double mouseX, double mouseY) {
        int idx = this.getMouseOverIndex(mouseX, mouseY);
        if (idx > -1) {
            this.colorBtn.setDisplayColor(IDX_COLOR[idx]);
            super.onPress();
        }
    }

    public void renderButton(int mouseX, int mouseY, float delta) {
        if (this.visible) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(EditLetteredConnectionScreen.WIDGETS_TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.blit(this.x, this.y, 0, 40, this.width, this.height);
            if (this.colorBtn.hasDisplayColor()) {
                int idx = COLOR_IDX[this.colorBtn.getDisplayColor().ordinal()];
                int selectX = this.x + 2 + idx % 4 * 6;
                int selectY = this.y + 2 + idx / 4 * 6;
                this.blit(selectX, selectY, 28, 40, 6, 6);
            }
            for (int i = 0; i < IDX_COLOR.length; ++i) {
                TextFormatting color = IDX_COLOR[i];
                int rgb = StyledString.getColor(color);
                float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                float b = (float)(rgb & 0xFF) / 255.0f;
                RenderSystem.color4f((float)r, (float)g, (float)b, (float)1.0f);
                this.blit(this.x + 2 + i % 4 * 6, this.y + 2 + i / 4 * 6, 34, 40, 6, 6);
            }
            int selectIndex = this.getMouseOverIndex(mouseX, mouseY);
            if (selectIndex > -1) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                int hoverSelectX = this.x + 2 + selectIndex % 4 * 6;
                int hoverSelectY = this.y + 2 + selectIndex / 4 * 6;
                this.blit(hoverSelectX, hoverSelectY, 28, 40, 6, 6);
                RenderSystem.disableBlend();
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private int getMouseOverIndex(double mouseX, double mouseY) {
        int relX = MathHelper.func_76128_c((double)(mouseX - (double)this.x - 3.0));
        int relY = MathHelper.func_76128_c((double)(mouseY - (double)this.y - 3.0));
        if (relX < 0 || relY < 0 || relX > 22 || relY > 22) {
            return -1;
        }
        int bucketX = relX % 6;
        int bucketY = relY % 6;
        if (bucketX > 3 || bucketY > 3) {
            return -1;
        }
        int x = relX / 6;
        int y = relY / 6;
        return x + y * 4;
    }
}

