/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import me.paulf.fairylights.client.renderer.block.entity.FastenerRenderer;
import me.paulf.fairylights.server.block.entity.FastenerBlockEntity;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.fastener.BlockView;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.util.matrix.Matrix;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.Vec3d;

public final class FastenerBlockEntityRenderer
extends TileEntityRenderer<FastenerBlockEntity> {
    private final BlockView view;
    private final FastenerRenderer renderer = new FastenerRenderer();

    public FastenerBlockEntityRenderer(TileEntityRendererDispatcher dispatcher, BlockView view) {
        super(dispatcher);
        this.view = view;
    }

    public boolean isGlobalRenderer(FastenerBlockEntity fastener) {
        return true;
    }

    public void render(FastenerBlockEntity fastener, float delta, MatrixStack matrix, IRenderTypeBuffer bufferSource, int packedLight, int packedOverlay) {
        fastener.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(f -> {
            matrix.func_227860_a_();
            Vec3d offset = fastener.getOffset();
            matrix.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            this.renderer.render((Fastener<?>)f, delta, matrix, bufferSource, packedLight, packedOverlay);
            matrix.func_227865_b_();
        });
    }

    static class GlMatrix
    implements Matrix {
        static final GlMatrix INSTANCE = new GlMatrix();

        GlMatrix() {
        }

        @Override
        public void translate(float x, float y, float z) {
            RenderSystem.translatef((float)x, (float)y, (float)z);
        }

        @Override
        public void rotate(float angle, float x, float y, float z) {
            RenderSystem.rotatef((float)angle, (float)x, (float)y, (float)z);
        }
    }
}

