/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.client.model.light.BowModel;
import me.paulf.fairylights.client.renderer.block.entity.GarlandTinselRenderer;
import me.paulf.fairylights.client.renderer.block.entity.GarlandVineRenderer;
import me.paulf.fairylights.client.renderer.block.entity.HangingLightsRenderer;
import me.paulf.fairylights.client.renderer.block.entity.LetterBuntingRenderer;
import me.paulf.fairylights.client.renderer.block.entity.PennantBuntingRenderer;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.GarlandTinselConnection;
import me.paulf.fairylights.server.connection.GarlandVineConnection;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.connection.LetterBuntingConnection;
import me.paulf.fairylights.server.connection.PennantBuntingConnection;
import me.paulf.fairylights.server.fastener.Fastener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class FastenerRenderer {
    private final HangingLightsRenderer hangingLights = new HangingLightsRenderer();
    private final GarlandVineRenderer garland = new GarlandVineRenderer();
    private final GarlandTinselRenderer tinsel = new GarlandTinselRenderer();
    private final PennantBuntingRenderer pennants = new PennantBuntingRenderer();
    private final LetterBuntingRenderer letters = new LetterBuntingRenderer();
    private final BowModel bow = new BowModel();

    public void render(Fastener<?> fastener, float delta, MatrixStack matrix, IRenderTypeBuffer source, int packedLight, int packedOverlay) {
        boolean renderBow = true;
        for (Connection conn : fastener.getAllConnections()) {
            if (conn.getFastener() == fastener) {
                this.renderConnection(delta, matrix, source, packedLight, packedOverlay, conn);
            }
            if (!renderBow || !(conn instanceof GarlandVineConnection) || fastener.getFacing().func_176740_k() == Direction.Axis.Y) continue;
            IVertexBuilder buf = ClientProxy.SOLID_TEXTURE.func_229311_a_(source, RenderType::func_228638_b_);
            matrix.func_227860_a_();
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - fastener.getFacing().func_185119_l()));
            this.bow.func_225598_a_(matrix, buf, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrix.func_227865_b_();
            renderBow = false;
        }
    }

    private void renderConnection(float delta, MatrixStack matrix, IRenderTypeBuffer source, int packedLight, int packedOverlay, Connection conn) {
        if (conn instanceof HangingLightsConnection) {
            this.hangingLights.render((HangingLightsConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof GarlandVineConnection) {
            this.garland.render((GarlandVineConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof GarlandTinselConnection) {
            this.tinsel.render((GarlandTinselConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof PennantBuntingConnection) {
            this.pennants.render((PennantBuntingConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof LetterBuntingConnection) {
            this.letters.render((LetterBuntingConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        }
    }

    public static void renderBakedModel(ResourceLocation path, MatrixStack matrix, IVertexBuilder buf, float r, float g, float b, int packedLight, int packedOverlay) {
        FastenerRenderer.renderBakedModel(Minecraft.func_71410_x().func_209506_al().getModel(path), matrix, buf, r, g, b, packedLight, packedOverlay);
    }

    public static void renderBakedModel(IBakedModel model, MatrixStack matrix, IVertexBuilder buf, float r, float g, float b, int packedLight, int packedOverlay) {
        FastenerRenderer.renderBakedModel(model, ItemCameraTransforms.TransformType.FIXED, matrix, buf, r, g, b, packedLight, packedOverlay);
    }

    public static void renderBakedModel(IBakedModel model, ItemCameraTransforms.TransformType type, MatrixStack matrix, IVertexBuilder buf, float r, float g, float b, int packedLight, int packedOverlay) {
        model.func_177552_f().func_181688_b(type).func_228830_a_(false, matrix);
        for (Direction side : Direction.values()) {
            for (BakedQuad quad : model.getQuads(null, side, new Random(42L), (IModelData)EmptyModelData.INSTANCE)) {
                buf.func_227889_a_(matrix.func_227866_c_(), quad, r, g, b, packedLight, packedOverlay);
            }
        }
        for (BakedQuad quad : model.getQuads(null, null, new Random(42L), (IModelData)EmptyModelData.INSTANCE)) {
            buf.func_227889_a_(matrix.func_227866_c_(), quad, r, g, b, packedLight, packedOverlay);
        }
    }
}

