/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.collision;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.collision.Collidable;
import me.paulf.fairylights.server.collision.Intersection;
import net.minecraft.util.math.Vec3d;

public final class CollidableList
implements Collidable {
    private final ImmutableList<Collidable> collision;

    private CollidableList(Builder builder) {
        this.collision = builder.collision.build();
    }

    @Override
    @Nullable
    public Intersection intersect(Vec3d origin, Vec3d end) {
        Intersection result = null;
        double distance = Double.MAX_VALUE;
        for (Collidable collidable : this.collision) {
            double d;
            Intersection r = collidable.intersect(origin, end);
            if (r == null || !((d = r.getResult().func_72438_d(origin)) < distance)) continue;
            result = r;
            distance = d;
        }
        return result;
    }

    public static class Builder {
        final ImmutableList.Builder<Collidable> collision = new ImmutableList.Builder();

        public Builder add(Collidable collidable) {
            this.collision.add((Object)collidable);
            return this;
        }

        public CollidableList build() {
            return new CollidableList(this);
        }
    }
}

