/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.collision.Collidable;
import me.paulf.fairylights.server.collision.CollidableList;
import me.paulf.fairylights.server.collision.FeatureCollisionTree;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import me.paulf.fairylights.server.feature.Feature;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.net.serverbound.InteractionConnectionMessage;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.util.Catenary;
import me.paulf.fairylights.util.CubicBezier;
import me.paulf.fairylights.util.NBTSerializable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public abstract class Connection
implements NBTSerializable {
    public static final int MAX_LENGTH = 32;
    public static final double PULL_RANGE = 5.0;
    public static final FeatureType CORD_FEATURE = FeatureType.register("cord");
    private static final CubicBezier SLACK_CURVE = new CubicBezier(0.495f, 0.505f, 0.495f, 0.505f);
    private static final float MAX_SLACK = 3.0f;
    private final ConnectionType<?> type;
    protected final Fastener<?> fastener;
    private final UUID uuid;
    private FastenerAccessor destination;
    @Nullable
    private FastenerAccessor prevDestination;
    protected World world;
    @Nullable
    private Catenary catenary;
    @Nullable
    protected Catenary prevCatenary;
    protected float slack = 1.0f;
    private Collidable collision = Collidable.empty();
    private boolean updateCatenary;
    private int prevStretchStage;
    private boolean removed;
    private boolean drop;

    public Connection(ConnectionType<?> type, World world, Fastener<?> fastener, UUID uuid) {
        this.type = type;
        this.world = world;
        this.fastener = fastener;
        this.uuid = uuid;
        this.computeCatenary();
    }

    public ConnectionType<?> getType() {
        return this.type;
    }

    @Nullable
    public final Catenary getCatenary() {
        return this.catenary;
    }

    @Nullable
    public final Catenary getPrevCatenary() {
        return this.prevCatenary == null ? this.catenary : this.prevCatenary;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public final World getWorld() {
        return this.world;
    }

    public final Collidable getCollision() {
        return this.collision;
    }

    public final Fastener<?> getFastener() {
        return this.fastener;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    public final void setDestination(Fastener<?> destination) {
        this.prevDestination = this.destination;
        this.destination = destination.createAccessor();
        this.computeCatenary();
    }

    public final FastenerAccessor getDestination() {
        return this.destination;
    }

    public boolean isDestination(FastenerAccessor location) {
        return this.destination.equals(location);
    }

    public void setDrop() {
        this.drop = true;
    }

    public void noDrop() {
        this.drop = false;
    }

    public boolean shouldDrop() {
        return this.drop;
    }

    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack((IItemProvider)this.getType().getItem());
        CompoundNBT tagCompound = this.serializeLogic();
        if (!tagCompound.isEmpty()) {
            stack.func_77982_d(tagCompound);
        }
        return stack;
    }

    public float getRadius() {
        return 0.0625f;
    }

    public final boolean isDynamic() {
        return this.fastener.isMoving() || this.destination.get(this.world, false).filter(Fastener::isMoving).isPresent();
    }

    public final boolean isModifiable(PlayerEntity player) {
        return this.world.func_175660_a(player, this.fastener.getPos());
    }

    public final void remove() {
        if (!this.removed) {
            this.removed = true;
            this.onRemove();
        }
    }

    public final boolean isRemoved() {
        return this.removed;
    }

    public void computeCatenary() {
        this.updateCatenary = true;
    }

    public void processClientAction(PlayerEntity player, PlayerAction action, Intersection intersection) {
        FairyLights.NETWORK.sendToServer((Object)new InteractionConnectionMessage(this, action, intersection));
    }

    public void disconnect(PlayerEntity player, Vec3d hit) {
        this.destination.get(this.world).ifPresent(f -> this.disconnect((Fastener<?>)f, hit));
    }

    private void disconnect(Fastener<?> destinationFastener, Vec3d hit) {
        this.fastener.removeConnection(this);
        destinationFastener.removeConnection(this.uuid);
        if (this.shouldDrop()) {
            ItemStack stack = this.getItemStack();
            ItemEntity item = new ItemEntity(this.world, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, stack);
            float scale = 0.05f;
            item.func_213293_j(this.world.field_73012_v.nextGaussian() * (double)0.05f, this.world.field_73012_v.nextGaussian() * (double)0.05f + (double)0.2f, this.world.field_73012_v.nextGaussian() * (double)0.05f);
            this.world.func_217376_c((Entity)item);
        }
        this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, (SoundEvent)FLSounds.CORD_DISCONNECT.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public boolean reconnect(Fastener<?> destination) {
        return this.fastener.reconnect(this.world, this, destination);
    }

    public boolean interact(PlayerEntity player, Vec3d hit, FeatureType featureType, int feature, ItemStack heldStack, Hand hand) {
        Item item = heldStack.func_77973_b();
        if (item instanceof ConnectionItem && !this.matches(heldStack)) {
            return this.replace(player, hit, heldStack);
        }
        if (heldStack.func_77973_b().func_206844_a(Tags.Items.STRING)) {
            return this.slacken(hit, heldStack, 0.2f);
        }
        if (heldStack.func_77973_b() == Items.field_151055_y) {
            return this.slacken(hit, heldStack, -0.2f);
        }
        return false;
    }

    public boolean matches(ItemStack stack) {
        if (this.getType().getItem().equals(stack.func_77973_b())) {
            CompoundNBT tag = stack.func_77978_p();
            return tag == null || NBTUtil.func_181123_a((INBT)this.serializeLogic(), (INBT)tag, (boolean)true);
        }
        return false;
    }

    private boolean replace(PlayerEntity player, Vec3d hit, ItemStack heldStack) {
        return (Boolean)this.destination.get(this.world).map(dest -> {
            this.fastener.removeConnection(this);
            dest.removeConnection(this.uuid);
            if (this.shouldDrop()) {
                player.field_71071_by.func_70441_a(this.getItemStack());
            }
            CompoundNBT data = heldStack.func_77978_p();
            ConnectionType<?> type = ((ConnectionItem)heldStack.func_77973_b()).getConnectionType();
            Connection conn = this.fastener.connect(this.world, (Fastener<?>)dest, type, data == null ? new CompoundNBT() : data, true);
            conn.slack = this.slack;
            conn.onConnect(player.field_70170_p, player, heldStack);
            heldStack.func_190918_g(1);
            this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, (SoundEvent)FLSounds.CORD_CONNECT.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }).orElse((Object)false);
    }

    private boolean slacken(Vec3d hit, ItemStack heldStack, float amount) {
        if (this.slack <= 0.0f && amount < 0.0f || this.slack >= 3.0f && amount > 0.0f) {
            return true;
        }
        this.slack = MathHelper.func_76131_a((float)(this.slack + amount), (float)0.0f, (float)3.0f);
        if (this.slack < 0.01f) {
            this.slack = 0.0f;
        }
        this.computeCatenary();
        this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, (SoundEvent)FLSounds.CORD_STRETCH.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + (3.0f - this.slack) * 0.4f);
        return true;
    }

    public void onConnect(World world, PlayerEntity user, ItemStack heldStack) {
    }

    protected void onRemove() {
    }

    protected void onUpdate() {
    }

    protected void onCalculateCatenary(boolean relocated) {
    }

    public final boolean update(Vec3d from) {
        this.prevCatenary = this.catenary;
        boolean changed = (Boolean)this.destination.get(this.world, false).map(dest -> {
            Vec3d point = dest.getConnectionPoint();
            boolean c = this.updateCatenary(from, (Fastener<?>)dest, point);
            this.onUpdate();
            double dist = point.func_72438_d(from);
            double pull = dist - 32.0 + 5.0;
            if (pull > 0.0) {
                int stage = (int)(pull + (double)0.1f);
                if (stage > this.prevStretchStage) {
                    this.world.func_184148_a(null, point.field_72450_a, point.field_72448_b, point.field_72449_c, (SoundEvent)FLSounds.CORD_STRETCH.get(), SoundCategory.BLOCKS, 0.25f, 0.5f + (float)stage / 8.0f);
                }
                this.prevStretchStage = stage;
            }
            if (dist > 37.0) {
                this.world.func_184148_a(null, point.field_72450_a, point.field_72448_b, point.field_72449_c, (SoundEvent)FLSounds.CORD_SNAP.get(), SoundCategory.BLOCKS, 0.75f, 0.8f + this.world.field_73012_v.nextFloat() * 0.3f);
                this.remove();
            } else if (dest.isMoving()) {
                dest.resistSnap(from);
            }
            return c;
        }).orElse((Object)false);
        if (this.destination.isGone(this.world)) {
            this.remove();
        }
        return changed;
    }

    private boolean updateCatenary(Vec3d from, Fastener<?> dest, Vec3d point) {
        if (this.updateCatenary || this.isDynamic()) {
            Vec3d vec = point.func_178788_d(from);
            if (vec.func_72433_c() > 1.0E-6) {
                Direction facing = this.fastener.getFacing();
                this.catenary = Catenary.from(vec, facing.func_176740_k() != Direction.Axis.Y ? (float)Math.toRadians(90.0f + facing.func_185119_l()) : 0.0f, SLACK_CURVE, this.slack);
                this.onCalculateCatenary(!this.destination.equals(this.prevDestination));
                CollidableList.Builder bob = new CollidableList.Builder();
                this.addCollision(bob, from);
                this.collision = bob.build();
            }
            this.updateCatenary = false;
            this.prevDestination = this.destination;
            return true;
        }
        return false;
    }

    public void addCollision(CollidableList.Builder collision, Vec3d origin) {
        if (this.catenary == null) {
            return;
        }
        int count = this.catenary.getCount();
        if (count < 2) {
            return;
        }
        float r = this.getRadius();
        Catenary.SegmentIterator it = this.catenary.iterator();
        AxisAlignedBB[] bounds = new AxisAlignedBB[count - 1];
        int index = 0;
        while (it.next()) {
            float x0 = it.getX(0.0f);
            float y0 = it.getY(0.0f);
            float z0 = it.getZ(0.0f);
            float x1 = it.getX(1.0f);
            float y1 = it.getY(1.0f);
            float z1 = it.getZ(1.0f);
            bounds[index++] = new AxisAlignedBB(origin.field_72450_a + (double)x0, origin.field_72448_b + (double)y0, origin.field_72449_c + (double)z0, origin.field_72450_a + (double)x1, origin.field_72448_b + (double)y1, origin.field_72449_c + (double)z1).func_186662_g((double)r);
        }
        collision.add(FeatureCollisionTree.build(CORD_FEATURE, i -> Segment.INSTANCE, i -> bounds[i], 1, bounds.length - 2));
    }

    public void deserialize(Fastener<?> destination, CompoundNBT compound, boolean drop) {
        this.destination = destination.createAccessor();
        this.drop = drop;
        this.deserializeLogic(compound);
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("destination", (INBT)FastenerType.serialize(this.destination));
        compound.func_218657_a("logic", (INBT)this.serializeLogic());
        compound.func_74776_a("slack", this.slack);
        if (!this.drop) {
            compound.func_74757_a("drop", false);
        }
        return compound;
    }

    @Override
    public void deserialize(CompoundNBT compound) {
        this.destination = FastenerType.deserialize(compound.func_74775_l("destination"));
        this.deserializeLogic(compound.func_74775_l("logic"));
        this.slack = compound.func_150297_b("slack", 99) ? compound.func_74760_g("slack") : 1.0f;
        this.drop = !compound.func_150297_b("drop", 99) || compound.func_74767_n("drop");
        this.updateCatenary = true;
    }

    public CompoundNBT serializeLogic() {
        return new CompoundNBT();
    }

    public void deserializeLogic(CompoundNBT compound) {
    }

    static class Segment
    implements Feature {
        static final Segment INSTANCE = new Segment();

        Segment() {
        }

        @Override
        public int getId() {
            return 0;
        }
    }
}

