/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public interface Fastener<F extends FastenerAccessor>
extends ICapabilitySerializable<CompoundNBT> {
    public CompoundNBT serializeNBT();

    public Optional<Connection> get(UUID var1);

    public List<Connection> getOwnConnections();

    public List<Connection> getAllConnections();

    default public Optional<Connection> getFirstConnection() {
        return this.getAllConnections().stream().findFirst();
    }

    public AxisAlignedBB getBounds();

    public Vec3d getConnectionPoint();

    public BlockPos getPos();

    public Direction getFacing();

    public void setWorld(World var1);

    @Nullable
    public World getWorld();

    public F createAccessor();

    public boolean isMoving();

    default public void resistSnap(Vec3d from) {
    }

    public boolean update();

    public void setDirty();

    public void dropItems(World var1, BlockPos var2);

    public void remove();

    public boolean hasNoConnections();

    public boolean hasConnectionWith(Fastener<?> var1);

    @Nullable
    public Connection getConnectionTo(FastenerAccessor var1);

    public boolean removeConnection(UUID var1);

    public boolean removeConnection(Connection var1);

    public boolean reconnect(World var1, Connection var2, Fastener<?> var3);

    public Connection connect(World var1, Fastener<?> var2, ConnectionType<?> var3, CompoundNBT var4, boolean var5);

    public Connection createOutgoingConnection(World var1, UUID var2, Fastener<?> var3, ConnectionType<?> var4, CompoundNBT var5, boolean var6);

    public void createIncomingConnection(World var1, UUID var2, Fastener<?> var3, ConnectionType<?> var4);
}

