/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener.accessor;

import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.fastener.EntityFastener;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;

public abstract class EntityFastenerAccessor<E extends Entity>
implements FastenerAccessor {
    private final Class<? extends E> entityClass;
    private UUID uuid;
    @Nullable
    private E entity;
    @Nullable
    private Vec3d pos;

    public EntityFastenerAccessor(Class<? extends E> entityClass) {
        this(entityClass, (UUID)null);
    }

    public EntityFastenerAccessor(Class<? extends E> entityClass, EntityFastener<E> fastener) {
        this(entityClass, fastener.getEntity().func_110124_au());
        this.entity = fastener.getEntity();
        this.pos = this.entity.func_213303_ch();
    }

    public EntityFastenerAccessor(Class<? extends E> entityClass, UUID uuid) {
        this.entityClass = entityClass;
        this.uuid = uuid;
    }

    @Override
    public LazyOptional<Fastener<?>> get(World world, boolean load) {
        block3: {
            block4: {
                if (this.entity != null) break block3;
                if (!(world instanceof ServerWorld)) break block4;
                Entity e = ((ServerWorld)world).func_217461_a(this.uuid);
                if (!this.entityClass.isInstance(e)) break block3;
                this.entity = (Entity)this.entityClass.cast(e);
                break block3;
            }
            if (this.pos != null) {
                for (Entity entity : world.func_225317_b(this.entityClass, new AxisAlignedBB(this.pos.func_178786_a(1.0, 1.0, 1.0), this.pos.func_72441_c(1.0, 1.0, 1.0)))) {
                    if (!this.uuid.equals(entity.func_110124_au())) continue;
                    this.entity = entity;
                    break;
                }
            }
        }
        if (this.entity != null && ((Entity)this.entity).field_70170_p == world) {
            this.pos = this.entity.func_213303_ch();
            return this.entity.getCapability(CapabilityHandler.FASTENER_CAP);
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean isGone(World world) {
        return !world.field_72995_K && this.entity != null && (!this.entity.getCapability(CapabilityHandler.FASTENER_CAP).isPresent() || ((Entity)this.entity).field_70170_p != world);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EntityFastenerAccessor) {
            return this.uuid.equals(((EntityFastenerAccessor)obj).uuid);
        }
        return false;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_186854_a("UUID", this.uuid);
        if (this.pos != null) {
            ListNBT pos = new ListNBT();
            pos.add((Object)DoubleNBT.func_229684_a_((double)this.pos.field_72450_a));
            pos.add((Object)DoubleNBT.func_229684_a_((double)this.pos.field_72448_b));
            pos.add((Object)DoubleNBT.func_229684_a_((double)this.pos.field_72449_c));
            tag.func_218657_a("Pos", (INBT)pos);
        }
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        this.uuid = tag.func_186857_a("UUID");
        if (tag.func_150297_b("Pos", 9)) {
            ListNBT pos = tag.func_150295_c("Pos", 6);
            this.pos = new Vec3d(pos.func_150309_d(0), pos.func_150309_d(1), pos.func_150309_d(2));
        } else {
            this.pos = null;
        }
        this.entity = null;
    }
}

