/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.feature.light.ColorLightBehavior;
import me.paulf.fairylights.server.feature.light.FixedColorBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.util.Mth;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ColorChangingBehavior
implements ColorLightBehavior {
    private final float[] red;
    private final float[] green;
    private final float[] blue;
    private final float rate;
    private boolean powered;

    public ColorChangingBehavior(float[] red, float[] green, float[] blue, float rate) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.rate = rate;
    }

    @Override
    public float getRed(float delta) {
        return this.get(this.red, delta);
    }

    @Override
    public float getGreen(float delta) {
        return this.get(this.green, delta);
    }

    @Override
    public float getBlue(float delta) {
        return this.get(this.blue, delta);
    }

    private float get(float[] values, float delta) {
        float p = this.powered ? Mth.mod((float)Util.func_211177_b() * 0.02f * this.rate, (float)values.length) : 0.0f;
        int i = (int)p;
        return MathHelper.func_219799_g((float)(p - (float)i), (float)values[i % values.length], (float)values[(i + 1) % values.length]);
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        this.powered = powered;
    }

    @Override
    public void tick(World world, Vec3d origin, Light<?> light) {
    }

    public static ColorLightBehavior create(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return new FixedColorBehavior(1.0f, 1.0f, 1.0f);
        }
        ListNBT list = tag.func_150295_c("colors", 3);
        float[] red = new float[list.size()];
        float[] green = new float[list.size()];
        float[] blue = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            int color = list.func_186858_c(i);
            red[i] = (float)(color >> 16 & 0xFF) / 255.0f;
            green[i] = (float)(color >> 8 & 0xFF) / 255.0f;
            blue[i] = (float)(color & 0xFF) / 255.0f;
        }
        return new ColorChangingBehavior(red, green, blue, (float)list.size() / 960.0f);
    }

    public static int animate(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return 0xFFFFFF;
        }
        ListNBT list = tag.func_150295_c("colors", 3);
        if (list.isEmpty()) {
            return 0xFFFFFF;
        }
        if (list.size() == 1) {
            return list.func_186858_c(0);
        }
        float p = Mth.mod((float)Util.func_211177_b() * 0.02f * ((float)list.size() / 960.0f), (float)list.size());
        int i = (int)p;
        int c0 = list.func_186858_c(i % list.size());
        float r0 = (float)(c0 >> 16 & 0xFF) / 255.0f;
        float g0 = (float)(c0 >> 8 & 0xFF) / 255.0f;
        float b0 = (float)(c0 & 0xFF) / 255.0f;
        int c1 = list.func_186858_c((i + 1) % list.size());
        float r1 = (float)(c1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(c1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(c1 & 0xFF) / 255.0f;
        return (int)(MathHelper.func_219799_g((float)(p - (float)i), (float)r0, (float)r1) * 255.0f) << 16 | (int)(MathHelper.func_219799_g((float)(p - (float)i), (float)g0, (float)g1) * 255.0f) << 8 | (int)(MathHelper.func_219799_g((float)(p - (float)i), (float)b0, (float)b1) * 255.0f);
    }

    public static boolean exists(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("colors", 9);
    }
}

