/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.config.FLConfig;
import me.paulf.fairylights.server.feature.HangingFeature;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.server.item.LightVariant;
import me.paulf.fairylights.server.sound.FLSounds;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class Light<T extends LightBehavior>
extends HangingFeature {
    private static final int SWAY_RATE = 10;
    private static final int SWAY_PEAK_COUNT = 5;
    private static final int SWAY_CYCLE = 50;
    private final ItemStack item;
    private final LightVariant<T> variant;
    private final T behavior;
    private int sway;
    private boolean swaying;
    private boolean swayDirection;
    private int tick;
    private int lastJingledTick = -1;
    private boolean powered;

    public Light(int index, Vec3d point, float yaw, float pitch, ItemStack item, LightVariant<T> variant, float descent) {
        super(index, point, yaw, pitch, 0.0f, descent);
        this.item = item;
        this.variant = variant;
        this.behavior = variant.createBehavior(item);
    }

    public T getBehavior() {
        return this.behavior;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public LightVariant<T> getVariant() {
        return this.variant;
    }

    public void jingle(World world, Vec3d origin, int note) {
        this.jingle(world, origin, note, ParticleTypes.field_197597_H);
    }

    public void jingle(World world, Vec3d origin, int note, BasicParticleType particle) {
        this.jingle(world, origin, note, (SoundEvent)FLSounds.JINGLE_BELL.get(), particle);
    }

    public void jingle(World world, Vec3d origin, int note, SoundEvent sound, BasicParticleType ... particles) {
        if (world.field_72995_K) {
            double x = origin.field_72450_a + this.point.field_72450_a;
            double y = origin.field_72448_b + this.point.field_72448_b;
            double z = origin.field_72449_c + this.point.field_72449_c;
            for (BasicParticleType particle : particles) {
                double vx = world.field_73012_v.nextGaussian();
                double vy = world.field_73012_v.nextGaussian();
                double vz = world.field_73012_v.nextGaussian();
                double t = world.field_73012_v.nextDouble() * 0.2 + 0.2;
                double mag = t / Math.sqrt(vx * vx + vy * vy + vz * vz);
                world.func_195594_a((IParticleData)particle, x + (vx *= mag), y + (vy *= mag), z + (vz *= mag), particle == ParticleTypes.field_197597_H ? (double)note / 24.0 : 0.0, 0.0, 0.0);
            }
            if (this.lastJingledTick != this.tick) {
                world.func_184134_a(x, y, z, sound, SoundCategory.BLOCKS, (float)FLConfig.getJingleAmplitude() / 16.0f, (float)Math.pow(2.0, (float)(note - 12) / 12.0f), false);
                this.startSwaying(world.field_73012_v.nextBoolean());
                this.lastJingledTick = this.tick;
            }
        }
    }

    public void startSwaying(boolean swayDirection) {
        this.swayDirection = swayDirection;
        this.swaying = true;
        this.sway = 0;
    }

    public void stopSwaying() {
        this.sway = 0;
        this.roll = 0.0f;
        this.swaying = false;
    }

    public void power(boolean powered, boolean now) {
        this.behavior.power(powered, now, this);
        this.powered = powered;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void tick(World world, Vec3d origin) {
        super.tick(world);
        this.behavior.tick(world, origin, this);
        if (this.swaying) {
            if (this.sway >= 50) {
                this.stopSwaying();
            } else {
                this.roll = (float)(Math.sin((double)((this.swayDirection ? 1 : -1) * 2) * Math.PI / 10.0 * (double)this.sway) * Math.pow(114.59155902616465, (float)(-this.sway) / 50.0f));
                ++this.sway;
            }
        }
        ++this.tick;
    }

    @Override
    public AxisAlignedBB getBounds() {
        return this.getVariant().getBounds();
    }

    @Override
    public boolean parallelsCord() {
        return this.getVariant().parallelsCord();
    }
}

