/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.function.Function;
import me.paulf.fairylights.server.feature.light.BrightnessLightBehavior;
import me.paulf.fairylights.server.feature.light.ColorChangingBehavior;
import me.paulf.fairylights.server.feature.light.ColorLightBehavior;
import me.paulf.fairylights.server.feature.light.CompositeBehavior;
import me.paulf.fairylights.server.feature.light.DefaultBrightnessBehavior;
import me.paulf.fairylights.server.feature.light.FixedColorBehavior;
import me.paulf.fairylights.server.feature.light.IncandescentBehavior;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.server.feature.light.MeteorLightBehavior;
import me.paulf.fairylights.server.feature.light.MultiLightBehavior;
import me.paulf.fairylights.server.feature.light.StandardLightBehavior;
import me.paulf.fairylights.server.feature.light.TorchLightBehavior;
import me.paulf.fairylights.server.feature.light.TwinkleBehavior;
import me.paulf.fairylights.server.item.LightVariant;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;

public class SimpleLightVariant<T extends LightBehavior>
implements LightVariant<T> {
    public static final LightVariant<StandardLightBehavior> FAIRY_LIGHT = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.138, -0.138, -0.138, 0.138, 0.138, 0.138), 0.044, SimpleLightVariant::standardBehavior, true);
    public static final LightVariant<StandardLightBehavior> PAPER_LANTERN = new SimpleLightVariant<StandardLightBehavior>(false, 1.0f, new AxisAlignedBB(-0.25, -0.906, -0.25, 0.25, 0.091, 0.25), 0.0, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> ORB_LANTERN = new SimpleLightVariant<StandardLightBehavior>(false, 1.0f, new AxisAlignedBB(-0.262, -0.512, -0.262, 0.262, 0.091, 0.262), 0.044, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> FLOWER_LIGHT = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.483, -0.227, -0.483, 0.436, 0.185, 0.436), 0.069, SimpleLightVariant::standardBehavior, true);
    public static final LightVariant<StandardLightBehavior> CANDLE_LANTERN_LIGHT = new SimpleLightVariant<StandardLightBehavior>(false, 1.5f, new AxisAlignedBB(-0.198, -0.531, -0.198, 0.198, 0.091, 0.198), 0.0, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> OIL_LANTERN_LIGHT = new SimpleLightVariant<StandardLightBehavior>(false, 1.5f, new AxisAlignedBB(-0.219, -0.656, -0.188, 0.219, 0.091, 0.188), 0.0, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> JACK_O_LANTERN = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.231, -0.419, -0.231, 0.231, 0.122, 0.231), 0.044, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> SKULL_LIGHT = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.2, -0.404, -0.2, 0.2, 0.122, 0.2), 0.044, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> GHOST_LIGHT = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.27, -0.39, -0.27, 0.27, 0.169, 0.27), 0.075, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> SPIDER_LIGHT = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.575, -0.834, -0.2, 0.575, 0.122, 0.2), 0.06, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> WITCH_LIGHT = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.294, -0.419, -0.294, 0.294, 0.173, 0.294), 0.044, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> SNOWFLAKE_LIGHT = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.518, -1.05, -0.082, 0.517, 0.072, 0.082), 0.044, SimpleLightVariant::standardBehavior);
    public static final LightVariant<StandardLightBehavior> HEART_LIGHT = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.28, -0.408, -0.106, 0.274, 0.063, 0.106), 0.062, SimpleLightVariant::standardBehavior, true);
    public static final LightVariant<StandardLightBehavior> MOON_LIGHT = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.2, -0.669, -0.144, 0.3, 0.063, 0.144), 0.044, SimpleLightVariant::standardBehavior, true);
    public static final LightVariant<StandardLightBehavior> STAR_LIGHT = new SimpleLightVariant<StandardLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.2, -0.669, -0.144, 0.3, 0.063, 0.144), 0.044, SimpleLightVariant::standardBehavior, true);
    public static final LightVariant<MultiLightBehavior> ICICLE_LIGHTS = new SimpleLightVariant<MultiLightBehavior>(false, 0.625f, new AxisAlignedBB(-0.264, -1.032, -0.253, 0.276, 0.091, 0.266), 0.012, stack -> MultiLightBehavior.create(4, () -> SimpleLightVariant.standardBehavior(stack)));
    public static final LightVariant<MeteorLightBehavior> METEOR_LIGHT = new SimpleLightVariant<MeteorLightBehavior>(false, 1.5f, new AxisAlignedBB(-0.09, -1.588, -0.09, 0.09, 0.091, 0.09), 0.0, stack -> {
        ColorLightBehavior color = ColorChangingBehavior.exists(stack) ? ColorChangingBehavior.create(stack) : FixedColorBehavior.create(stack);
        return new MeteorLightBehavior(color);
    });
    public static final LightVariant<BrightnessLightBehavior> OIL_LANTERN = new SimpleLightVariant<BrightnessLightBehavior>(false, 1.5f, new AxisAlignedBB(-0.219, -0.656, -0.188, 0.219, 0.091, 0.188), 0.0, stack -> new TorchLightBehavior(0.13));
    public static final LightVariant<BrightnessLightBehavior> CANDLE_LANTERN = new SimpleLightVariant<BrightnessLightBehavior>(false, 1.5f, new AxisAlignedBB(-0.198, -0.531, -0.198, 0.198, 0.091, 0.198), 0.0, stack -> new TorchLightBehavior(0.2));
    public static final LightVariant<BrightnessLightBehavior> INCANDESCENT_LIGHT = new SimpleLightVariant<BrightnessLightBehavior>(true, 1.0f, new AxisAlignedBB(-0.166, -0.291, -0.166, 0.166, 0.062, 0.166), 0.103, stack -> new IncandescentBehavior(), true);
    private final boolean parallelsCord;
    private final float spacing;
    private final AxisAlignedBB bounds;
    private final double floorOffset;
    private final Function<ItemStack, T> behaviorFactory;
    private final boolean orientable;

    SimpleLightVariant(boolean parallelsCord, float spacing, AxisAlignedBB bounds, double floorOffset, Function<ItemStack, T> behaviorFactory) {
        this(parallelsCord, spacing, bounds, floorOffset, behaviorFactory, false);
    }

    SimpleLightVariant(boolean parallelsCord, float spacing, AxisAlignedBB bounds, double floorOffset, Function<ItemStack, T> behaviorFactory, boolean orientable) {
        this.parallelsCord = parallelsCord;
        this.spacing = spacing;
        this.bounds = bounds;
        this.floorOffset = floorOffset;
        this.behaviorFactory = behaviorFactory;
        this.orientable = orientable;
    }

    @Override
    public boolean parallelsCord() {
        return this.parallelsCord;
    }

    @Override
    public float getSpacing() {
        return this.spacing;
    }

    @Override
    public AxisAlignedBB getBounds() {
        return this.bounds;
    }

    @Override
    public double getFloorOffset() {
        return this.floorOffset;
    }

    @Override
    public T createBehavior(ItemStack stack) {
        return (T)((LightBehavior)this.behaviorFactory.apply(stack));
    }

    @Override
    public boolean isOrientable() {
        return this.orientable;
    }

    private static StandardLightBehavior standardBehavior(ItemStack stack) {
        BrightnessLightBehavior brightness = TwinkleBehavior.exists(stack) ? new TwinkleBehavior(0.05f, 40) : new DefaultBrightnessBehavior();
        ColorLightBehavior color = ColorChangingBehavior.exists(stack) ? ColorChangingBehavior.create(stack) : FixedColorBehavior.create(stack);
        return new CompositeBehavior(brightness, color);
    }
}

