/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.model.light;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.paulf.fairylights.client.model.light.LightModel;
import me.paulf.fairylights.server.feature.light.BrightnessLightBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;

public class IncandescentLightModel
extends LightModel<BrightnessLightBehavior> {
    final ModelRenderer bulb;
    final ModelRenderer filament;

    public IncandescentLightModel() {
        this.unlit.func_78784_a(90, 10);
        this.unlit.func_228300_a_(-1.0f, -0.01f, -1.0f, 2.0f, 1.0f, 2.0f);
        this.bulb = new ModelRenderer((Model)this, 98, 10);
        this.bulb.func_228300_a_(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f);
        this.filament = new ModelRenderer((Model)this, 90, 13);
        this.filament.func_228300_a_(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f);
    }

    @Override
    public void animate(Light<?> light, BrightnessLightBehavior behavior, float delta) {
        super.animate(light, behavior, delta);
        this.brightness = behavior.getBrightness(delta);
    }

    @Override
    protected int getLight(int packedLight) {
        return (int)Math.max(this.brightness * 15.0f * 16.0f, (float)(packedLight & 0xFF)) | packedLight & 0xFF0000;
    }

    @Override
    public void func_225598_a_(MatrixStack matrix, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
        super.func_225598_a_(matrix, builder, light, overlay, r, g, b, a);
        int emissiveLight = this.getLight(light);
        float cr = 0.23f;
        float cg = 0.18f;
        float cb = 0.14f;
        float br = this.brightness;
        this.filament.func_228309_a_(matrix, builder, emissiveLight, overlay, r * (0.23f * (1.0f - br) + br), g * (0.18f * (1.0f - br) + br), b * (0.14f * (1.0f - br) + br), a);
    }

    @Override
    public void renderTranslucent(MatrixStack matrix, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
        float bi = this.brightness;
        int emissiveLight = this.getLight(light);
        float br = 1.0f;
        float bg = 0.73f;
        float bb = 0.3f;
        this.bulb.func_228309_a_(matrix, builder, emissiveLight, overlay, r * (1.0f * bi + (1.0f - bi)), g * (0.73f * bi + (1.0f - bi)), b * (0.3f * bi + (1.0f - bi)), bi * 0.4f + 0.25f);
        super.renderTranslucent(matrix, builder, light, overlay, r, g, b, a);
    }
}

