/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.client.TranslucentLightRenderer;
import me.paulf.fairylights.client.model.light.CandleLanternModel;
import me.paulf.fairylights.client.model.light.ColorCandleLanternModel;
import me.paulf.fairylights.client.model.light.ColorOilLanternModel;
import me.paulf.fairylights.client.model.light.FairyLightModel;
import me.paulf.fairylights.client.model.light.FlowerLightModel;
import me.paulf.fairylights.client.model.light.GhostLightModel;
import me.paulf.fairylights.client.model.light.HeartLightModel;
import me.paulf.fairylights.client.model.light.IcicleLightsModel;
import me.paulf.fairylights.client.model.light.IncandescentLightModel;
import me.paulf.fairylights.client.model.light.JackOLanternLightModel;
import me.paulf.fairylights.client.model.light.LightModel;
import me.paulf.fairylights.client.model.light.MeteorLightModel;
import me.paulf.fairylights.client.model.light.MoonLightModel;
import me.paulf.fairylights.client.model.light.OilLanternModel;
import me.paulf.fairylights.client.model.light.OrbLanternModel;
import me.paulf.fairylights.client.model.light.PaperLanternModel;
import me.paulf.fairylights.client.model.light.SkullLightModel;
import me.paulf.fairylights.client.model.light.SnowflakeLightModel;
import me.paulf.fairylights.client.model.light.SpiderLightModel;
import me.paulf.fairylights.client.model.light.StarLightModel;
import me.paulf.fairylights.client.model.light.WitchLightModel;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.server.item.LightVariant;
import me.paulf.fairylights.server.item.SimpleLightVariant;
import me.paulf.fairylights.util.Mth;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;

public class LightRenderer {
    private final LightModelProvider<LightBehavior> defaultLight = LightModelProvider.of(new DefaultModel());
    private final Map<LightVariant<?>, LightModelProvider<?>> lights = new ImmutableMap.Builder().put(SimpleLightVariant.FAIRY_LIGHT, LightModelProvider.of(new FairyLightModel())).put(SimpleLightVariant.PAPER_LANTERN, LightModelProvider.of(new PaperLanternModel())).put(SimpleLightVariant.ORB_LANTERN, LightModelProvider.of(new OrbLanternModel())).put(SimpleLightVariant.FLOWER_LIGHT, LightModelProvider.of(new FlowerLightModel())).put(SimpleLightVariant.CANDLE_LANTERN_LIGHT, LightModelProvider.of(new ColorCandleLanternModel())).put(SimpleLightVariant.OIL_LANTERN_LIGHT, LightModelProvider.of(new ColorOilLanternModel())).put(SimpleLightVariant.JACK_O_LANTERN, LightModelProvider.of(new JackOLanternLightModel())).put(SimpleLightVariant.SKULL_LIGHT, LightModelProvider.of(new SkullLightModel())).put(SimpleLightVariant.GHOST_LIGHT, LightModelProvider.of(new GhostLightModel())).put(SimpleLightVariant.SPIDER_LIGHT, LightModelProvider.of(new SpiderLightModel())).put(SimpleLightVariant.WITCH_LIGHT, LightModelProvider.of(new WitchLightModel())).put(SimpleLightVariant.SNOWFLAKE_LIGHT, LightModelProvider.of(new SnowflakeLightModel())).put(SimpleLightVariant.HEART_LIGHT, LightModelProvider.of(new HeartLightModel())).put(SimpleLightVariant.MOON_LIGHT, LightModelProvider.of(new MoonLightModel())).put(SimpleLightVariant.STAR_LIGHT, LightModelProvider.of(new StarLightModel())).put(SimpleLightVariant.ICICLE_LIGHTS, LightModelProvider.of(IntStream.rangeClosed(0, 4).mapToObj(IcicleLightsModel::new).toArray(IcicleLightsModel[]::new), (models, i) -> models[i < 0 ? 4 : Mth.mod(Mth.hash(i), 4) + 1])).put(SimpleLightVariant.METEOR_LIGHT, LightModelProvider.of(new MeteorLightModel())).put(SimpleLightVariant.OIL_LANTERN, LightModelProvider.of(new OilLanternModel())).put(SimpleLightVariant.CANDLE_LANTERN, LightModelProvider.of(new CandleLanternModel())).put(SimpleLightVariant.INCANDESCENT_LIGHT, LightModelProvider.of(new IncandescentLightModel())).build();

    public Data start(IRenderTypeBuffer source) {
        IVertexBuilder solid = ClientProxy.SOLID_TEXTURE.func_229311_a_(source, RenderType::func_228638_b_);
        return new Data(solid, TranslucentLightRenderer.get(source, ClientProxy.TRANSLUCENT_TEXTURE));
    }

    public <T extends LightBehavior> LightModel<T> getModel(Light<?> light, int index) {
        return this.getModel(light.getVariant(), index);
    }

    public <T extends LightBehavior> LightModel<T> getModel(LightVariant<?> variant, int index) {
        return this.lights.getOrDefault(variant, this.defaultLight).get(index);
    }

    public void render(MatrixStack matrix, Data data, Light<?> light, int index, float delta, int packedLight, int packedOverlay) {
        this.render(matrix, data, light, this.getModel(light, index), delta, packedLight, packedOverlay);
    }

    public <T extends LightBehavior> void render(MatrixStack matrix, Data data, Light<T> light, LightModel<T> model, float delta, int packedLight, int packedOverlay) {
        model.animate(light, light.getBehavior(), delta);
        model.func_225598_a_(matrix, data.solid, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        model.renderTranslucent(matrix, data.translucent, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    static class Data {
        final IVertexBuilder solid;
        final IVertexBuilder translucent;

        Data(IVertexBuilder solid, IVertexBuilder translucent) {
            this.solid = solid;
            this.translucent = translucent;
        }
    }

    static interface LightModelProvider<T extends LightBehavior> {
        public LightModel<T> get(int var1);

        public static <T extends LightBehavior> LightModelProvider<T> of(LightModel<T> model) {
            return i -> model;
        }

        public static <T extends LightBehavior> LightModelProvider<T> of(Supplier<LightModel<T>> model) {
            return i -> (LightModel)((Object)((Object)model.get()));
        }

        public static <T extends LightBehavior, D> LightModelProvider<T> of(D data, BiFunction<? super D, Integer, LightModel<T>> function) {
            return i -> (LightModel)((Object)((Object)function.apply((Object)data, i)));
        }
    }

    static class DefaultModel
    extends LightModel<LightBehavior> {
        DefaultModel() {
        }
    }
}

