/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.tutorial;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.paulf.fairylights.client.FLClientConfig;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.util.LazyItemStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ClippyController {
    private final ImmutableMap<String, Supplier<State>> states = (ImmutableMap)Stream.of(NoProgressState::new, CraftHangingLightsState::new, CompleteState::new).collect(ImmutableMap.toImmutableMap(s -> ((State)s.get()).name(), Function.identity()));
    private State state = new NoProgressState();

    public void init(IEventBus modBus) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getWorld() instanceof ClientWorld) {
                this.reload();
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Minecraft mc = Minecraft.func_71410_x();
            if (event.phase == TickEvent.Phase.END && !mc.func_147113_T() && mc.field_71439_g != null) {
                this.state.tick(mc.field_71439_g, this);
            }
        });
        modBus.addListener(e -> {
            if (e.getConfig().getSpec() == FLClientConfig.SPEC && Minecraft.func_71410_x().field_71439_g != null) {
                this.reload();
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            this.reload();
            this.state.tick(e.getPlayer(), this);
        });
    }

    private void reload() {
        this.setState((State)((Supplier)this.states.getOrDefault(FLClientConfig.TUTORIAL.progress.get(), NoProgressState::new)).get());
    }

    private void setState(State state) {
        this.state.stop();
        this.state = state;
        this.state.start();
        FLClientConfig.TUTORIAL.progress.set((Object)this.state.name());
        FLClientConfig.TUTORIAL.progress.save();
    }

    static class Balloon
    implements IToast {
        final LazyItemStack stack;
        final ITextComponent title;
        @Nullable
        final ITextComponent subtitle;
        IToast.Visibility visibility;

        Balloon(LazyItemStack stack, ITextComponent title, @Nullable ITextComponent subtitle) {
            this.stack = stack;
            this.title = title;
            this.subtitle = subtitle;
            this.visibility = IToast.Visibility.SHOW;
        }

        void hide() {
            this.visibility = IToast.Visibility.HIDE;
        }

        public IToast.Visibility func_230444_a_(MatrixStack stack, ToastGui toastGui, long delta) {
            toastGui.func_192989_b().func_110434_K().func_110577_a(field_193654_a);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            toastGui.func_238474_b_(stack, 0, 0, 0, 96, 160, 32);
            toastGui.func_192989_b().func_175599_af().func_184391_a(null, this.stack.get(), 8, 8);
            if (this.subtitle == null) {
                toastGui.func_192989_b().field_71466_p.func_243248_b(stack, this.title, 30.0f, 12.0f, -11534256);
            } else {
                toastGui.func_192989_b().field_71466_p.func_243248_b(stack, this.title, 30.0f, 7.0f, -11534256);
                toastGui.func_192989_b().field_71466_p.func_243248_b(stack, this.subtitle, 30.0f, 18.0f, -16777216);
            }
            return this.visibility;
        }
    }

    static class CompleteState
    implements State {
        CompleteState() {
        }

        @Override
        public String name() {
            return "complete";
        }
    }

    static class CraftHangingLightsState
    implements State {
        final Balloon balloon = new Balloon(new LazyItemStack(FLItems.HANGING_LIGHTS, Item::func_190903_i), (ITextComponent)new TranslationTextComponent("tutorial.fairylights.craft_hanging_lights.title"), (ITextComponent)new TranslationTextComponent("tutorial.fairylights.craft_hanging_lights.description"));

        CraftHangingLightsState() {
        }

        @Override
        public String name() {
            return "hanging_lights";
        }

        @Override
        public void start() {
            Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)this.balloon);
        }

        @Override
        public void tick(ClientPlayerEntity player, ClippyController controller) {
            if (player.field_71070_bA.func_75138_a().stream().noneMatch(stack -> stack.func_77973_b().func_206844_a(FLCraftingRecipes.LIGHTS)) && !player.field_71071_by.func_70445_o().func_77973_b().func_206844_a(FLCraftingRecipes.LIGHTS)) {
                controller.setState(new NoProgressState());
            } else if (FLItems.HANGING_LIGHTS.filter(i -> player.field_71071_by.func_70445_o().func_77973_b() == i || player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)i)) || player.func_146107_m().func_77444_a(Stats.field_188066_af.func_199076_b((Object)i)) > 0).isPresent()) {
                controller.setState(new CompleteState());
            }
        }

        @Override
        public void stop() {
            this.balloon.hide();
        }
    }

    static class NoProgressState
    implements State {
        NoProgressState() {
        }

        @Override
        public String name() {
            return "none";
        }

        @Override
        public void tick(ClientPlayerEntity player, ClippyController controller) {
            if (player.field_71071_by.func_199712_a(FLCraftingRecipes.LIGHTS)) {
                controller.setState(new CraftHangingLightsState());
            }
        }
    }

    static interface State {
        public String name();

        default public void start() {
        }

        default public void tick(ClientPlayerEntity player, ClippyController controller) {
        }

        default public void stop() {
        }
    }
}

