/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener;

import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.fastener.EntityFastener;
import me.paulf.fairylights.server.fastener.accessor.PlayerFastenerAccessor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public final class PlayerFastener
extends EntityFastener<PlayerEntity> {
    public PlayerFastener(PlayerEntity entity) {
        super(entity);
    }

    @Override
    public Vector3d getConnectionPoint() {
        double dy;
        double forwardDist;
        Vector3d point = super.getConnectionPoint();
        if (((PlayerEntity)this.entity).func_184613_cA()) {
            return point;
        }
        double angle = (((PlayerEntity)this.entity).field_70761_aq - 90.0f) * ((float)Math.PI / 180);
        double perpAngle = angle - 1.5707963267948966;
        boolean sneaking = ((PlayerEntity)this.entity).func_225608_bj_();
        double perpDist = 0.4 * (double)(this.matchesStack(((PlayerEntity)this.entity).func_184614_ca()) ? 1 : -1);
        if (sneaking) {
            forwardDist = 0.0;
            dy = 0.6;
        } else {
            forwardDist = 0.2;
            dy = 0.8;
        }
        double dx = Math.cos(perpAngle) * perpDist - Math.cos(angle) * forwardDist;
        double dz = Math.sin(perpAngle) * perpDist - Math.sin(angle) * forwardDist;
        return point.func_72441_c(dx, dy, dz);
    }

    @Override
    public boolean isMoving() {
        return true;
    }

    @Override
    public boolean update() {
        if (!(this.hasNoConnections() || this.matchesStack(((PlayerEntity)this.entity).func_184614_ca()) || this.matchesStack(((PlayerEntity)this.entity).func_184592_cb()))) {
            for (Connection connection : this.getAllConnections()) {
                if (connection.shouldDrop()) continue;
                connection.remove();
            }
        }
        return super.update();
    }

    private boolean matchesStack(ItemStack stack) {
        return this.getFirstConnection().filter(connection -> connection.matches(stack)).isPresent();
    }

    @Override
    public void resistSnap(Vector3d from) {
        double dist = this.getConnectionPoint().func_72438_d(from);
        if (dist > 32.0) {
            double arcX;
            double arcY;
            double arcZ;
            double dx = ((PlayerEntity)this.entity).func_226277_ct_() - from.field_72450_a;
            double dy = ((PlayerEntity)this.entity).func_226278_cu_() - from.field_72448_b;
            double dz = ((PlayerEntity)this.entity).func_226281_cx_() - from.field_72449_c;
            double vectorX = dx / dist;
            double vectorY = dy / dist;
            double vectorZ = dz / dist;
            double factor = Math.min((dist - 32.0) / 5.0, 5.0);
            Vector3d motion = ((PlayerEntity)this.entity).func_213322_ci();
            double tangent = Math.cos(MathHelper.func_181159_b((double)dy, (double)Math.sqrt(dx * dx + dz * dz))) * Math.signum(motion.field_72448_b);
            double speed = motion.func_72433_c();
            double swing = Math.abs(speed) < 1.0E-6 ? 0.0 : (1.0 - Math.abs(motion.field_72448_b / speed - tangent)) * 0.1;
            double mag = Math.sqrt(motion.field_72450_a * motion.field_72450_a + tangent * tangent + motion.field_72449_c * motion.field_72449_c);
            if (dy > 0.0 || Math.abs(mag) < 1.0E-6) {
                arcZ = 0.0;
                arcY = 0.0;
                arcX = 0.0;
            } else {
                arcX = motion.field_72450_a / mag * swing;
                arcY = tangent / mag * swing;
                arcZ = motion.field_72449_c / mag * swing;
            }
            ((PlayerEntity)this.entity).func_213293_j(motion.field_72450_a + vectorX * -Math.abs(vectorX) * factor + arcX, motion.field_72448_b + vectorY * -Math.abs(vectorY) * factor + arcY, motion.field_72449_c + vectorZ * -Math.abs(vectorZ) * factor + arcZ);
            ((PlayerEntity)this.entity).field_70143_R = 0.0f;
            if (this.entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)this.entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(this.entity));
            }
        }
    }

    @Override
    public PlayerFastenerAccessor createAccessor() {
        return new PlayerFastenerAccessor(this);
    }
}

