/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature;

import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.Feature;
import me.paulf.fairylights.util.Mth;
import me.paulf.fairylights.util.matrix.MatrixStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class HangingFeature
implements Feature {
    protected final int index;
    protected Vector3d point;
    protected Vector3d prevPoint;
    private Vector3d targetPoint;
    protected float yaw;
    protected float pitch;
    protected float roll;
    protected float prevYaw;
    protected float prevPitch;
    protected float prevRoll;
    protected float targetYaw;
    protected float targetPitch;
    protected final float descent;

    public HangingFeature(int index, Vector3d point, float yaw, float pitch, float roll, float descent) {
        this.index = index;
        this.prevPoint = this.targetPoint = point;
        this.point = this.targetPoint;
        this.yaw = this.targetYaw = yaw;
        this.prevYaw = this.targetYaw;
        this.pitch = this.targetPitch = pitch;
        this.prevPitch = this.targetPitch;
        this.prevRoll = this.roll = roll;
        this.descent = descent;
    }

    public void set(Vector3d point, float yaw, float pitch) {
        this.targetPoint = point;
        this.targetYaw = yaw;
        this.targetPitch = pitch;
    }

    @Override
    public final int getId() {
        return this.index;
    }

    public final Vector3d getPoint() {
        return this.targetPoint;
    }

    public final Vector3d getPoint(float delta) {
        return this.point.func_178788_d(this.prevPoint).func_186678_a((double)delta).func_178787_e(this.prevPoint);
    }

    public final float getYaw() {
        return this.yaw;
    }

    public final float getPitch() {
        return this.pitch;
    }

    public final float getRoll() {
        return this.roll;
    }

    public final float getYaw(float t) {
        return Mth.lerpAngle(this.prevYaw, this.yaw, t);
    }

    public final float getPitch(float t) {
        return Mth.lerpAngle(this.prevPitch, this.pitch, t);
    }

    public final float getRoll(float t) {
        return Mth.lerpAngle(this.prevRoll, this.roll, t);
    }

    public float getDescent() {
        return this.descent;
    }

    public final Vector3d getAbsolutePoint(Fastener<?> fastener) {
        return this.getAbsolutePoint(fastener.getConnectionPoint());
    }

    public final Vector3d getAbsolutePoint(Vector3d origin) {
        return this.point.func_178787_e(origin);
    }

    public Vector3d getTransformedPoint(Vector3d origin, Vector3d point) {
        MatrixStack matrix = new MatrixStack();
        matrix.rotate(-this.getYaw(), 0.0f, 1.0f, 0.0f);
        if (this.parallelsCord()) {
            matrix.rotate(this.getPitch(), 0.0f, 0.0f, 1.0f);
        }
        matrix.rotate(this.getRoll(), 1.0f, 0.0f, 0.0f);
        matrix.translate(0.0f, -this.getDescent(), 0.0f);
        return this.point.func_178787_e(matrix.transform(point)).func_178787_e(origin);
    }

    public void tick(World world) {
        this.prevPoint = this.point;
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        this.prevRoll = this.roll;
        this.point = this.targetPoint;
        this.yaw = this.targetYaw;
        this.pitch = this.targetPitch;
    }

    public abstract AxisAlignedBB getBounds();

    public abstract boolean parallelsCord();
}

