/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.jingle;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.sound.FLSounds;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public final class JinglePlayer {
    private State<?> state = new NotPlayingState();

    @Nullable
    public Jingle getJingle() {
        return this.state.getJingle();
    }

    public boolean isPlaying() {
        return this.state.isPlaying();
    }

    public float getProgress() {
        return this.state.getProgress();
    }

    public void play(Jingle jingle, int lightOffset) {
        this.state = new PlayingState(jingle, lightOffset);
    }

    public void tick(World world, Vector3d origin, Light<?>[] lights, boolean isClient) {
        this.state = this.state.tick(world, origin, lights, isClient);
    }

    public CompoundNBT serialize() {
        return StateType.serialize(this.state);
    }

    public void deserialize(CompoundNBT compound) {
        this.state = StateType.deserialize(compound);
    }

    private static final class PlayingState
    extends State<PlayingState> {
        public static final StateFactory<PlayingState> FACTORY = PlayingState.newFactory();
        private final Jingle jingle;
        private final int lightOffset;
        private final List<Jingle.PlayTick> playTicks;
        private final int length;
        private final BasicParticleType[] noteParticle;
        private int index;
        private int rest;
        private int time;

        private PlayingState(Jingle jingle, int lightOffset) {
            this(jingle, lightOffset, jingle.getPlayTicks(), jingle.getLength(), PlayingState.getParticles(jingle));
        }

        private PlayingState(Jingle jingle, int lightOffset, List<Jingle.PlayTick> playTicks, int length, BasicParticleType[] noteParticle) {
            this.jingle = jingle;
            this.lightOffset = lightOffset;
            this.playTicks = playTicks;
            this.length = length;
            this.noteParticle = noteParticle;
        }

        @Override
        public Jingle getJingle() {
            return this.jingle;
        }

        @Override
        public boolean isPlaying() {
            return true;
        }

        @Override
        public float getProgress() {
            return (float)this.time / (float)this.length;
        }

        @Override
        public State<?> tick(World world, Vector3d origin, Light<?>[] lights, boolean isClient) {
            ++this.time;
            if (this.rest <= 0) {
                if (this.index >= this.playTicks.size()) {
                    return new NotPlayingState();
                }
                Jingle.PlayTick playTick = this.playTicks.get(this.index++);
                this.rest = playTick.getDuration() - 1;
                if (isClient) {
                    this.play(world, origin, lights, playTick);
                }
            } else {
                --this.rest;
            }
            return this;
        }

        private void play(World world, Vector3d origin, Light<?>[] lights, Jingle.PlayTick playTick) {
            for (int note : playTick.getNotes()) {
                int idx = note - this.jingle.getLowestNote() + this.lightOffset;
                if (idx < 0 || idx >= lights.length) continue;
                lights[idx].jingle(world, origin, note, (SoundEvent)FLSounds.JINGLE_BELL.get(), this.noteParticle);
            }
        }

        @Override
        public StateFactory<PlayingState> getFactory() {
            return FACTORY;
        }

        @Override
        public PlayingState resolve() {
            return this;
        }

        private static StateFactory<PlayingState> newFactory() {
            return new StateFactory<PlayingState>(){

                @Override
                public String getId() {
                    return "playing";
                }

                @Override
                public CompoundNBT serialize(PlayingState state) {
                    CompoundNBT compound = new CompoundNBT();
                    Jingle.CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)state.jingle).result().ifPresent(jingle -> {
                        compound.func_218657_a("jingle", jingle);
                        compound.func_74768_a("lightOffset", state.lightOffset);
                        compound.func_74768_a("index", state.index);
                        compound.func_74768_a("rest", state.rest);
                        compound.func_74768_a("time", state.time);
                    });
                    return compound;
                }

                @Override
                public State<?> deserialize(CompoundNBT compound) {
                    return Jingle.CODEC.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compound.func_74775_l("jingle")).result().map(jingle -> {
                        int lightOffset = compound.func_74762_e("lightOffset");
                        PlayingState state = new PlayingState((Jingle)jingle, lightOffset);
                        state.index = compound.func_74762_e("index");
                        state.rest = compound.func_74762_e("rest");
                        state.time = compound.func_74762_e("time");
                        return state;
                    }).orElseGet(() -> new NotPlayingState());
                }
            };
        }

        private static BasicParticleType[] getParticles(Jingle jingle) {
            if (jingle.getTitle().hashCode() == -222984226) {
                return new BasicParticleType[]{ParticleTypes.field_197597_H, ParticleTypes.field_197595_F};
            }
            if (jingle.getTitle().hashCode() == -1006999363 || jingle.getTitle().hashCode() == 1895267316) {
                return new BasicParticleType[]{ParticleTypes.field_197597_H, ParticleTypes.field_197633_z};
            }
            return new BasicParticleType[]{ParticleTypes.field_197597_H};
        }
    }

    private static final class NotPlayingState
    extends State<NotPlayingState> {
        public static final StateFactory<NotPlayingState> FACTORY = NotPlayingState.newFactory();

        private NotPlayingState() {
        }

        @Override
        public Jingle getJingle() {
            return null;
        }

        @Override
        public boolean isPlaying() {
            return false;
        }

        @Override
        public float getProgress() {
            return 0.0f;
        }

        @Override
        public State<?> tick(World world, Vector3d origin, Light<?>[] lights, boolean isClient) {
            return this;
        }

        @Override
        public StateFactory<NotPlayingState> getFactory() {
            return FACTORY;
        }

        @Override
        public NotPlayingState resolve() {
            return this;
        }

        private static StateFactory<NotPlayingState> newFactory() {
            return new StateFactory<NotPlayingState>(){

                @Override
                public String getId() {
                    return "not_playing";
                }

                @Override
                public CompoundNBT serialize(NotPlayingState state) {
                    return new CompoundNBT();
                }

                public NotPlayingState deserialize(CompoundNBT compound) {
                    return new NotPlayingState();
                }
            };
        }
    }

    private static abstract class State<S extends State<S>> {
        private State() {
        }

        public abstract Jingle getJingle();

        public abstract boolean isPlaying();

        public abstract float getProgress();

        public abstract State<?> tick(World var1, Vector3d var2, Light<?>[] var3, boolean var4);

        public abstract StateFactory<S> getFactory();

        public abstract S resolve();
    }

    private static abstract class StateFactory<S extends State<S>> {
        private StateFactory() {
        }

        public abstract String getId();

        public abstract CompoundNBT serialize(S var1);

        public abstract State<?> deserialize(CompoundNBT var1);
    }

    private static enum StateType {
        NOT_PLAYING(NotPlayingState.FACTORY),
        PLAYING(PlayingState.FACTORY);

        private static final Map<String, StateType> MAP;
        private final StateFactory<?> factory;

        private StateType(StateFactory<?> factory) {
            this.factory = factory;
        }

        private String getId() {
            return this.factory.getId();
        }

        private StateFactory<?> getFactory() {
            return this.factory;
        }

        public static <S extends State<S>> CompoundNBT serialize(State<S> state) {
            StateFactory<S> factory = state.getFactory();
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a("state", factory.getId());
            compound.func_218657_a("data", (INBT)factory.serialize(state.resolve()));
            return compound;
        }

        public static State<?> deserialize(CompoundNBT compound) {
            return MAP.getOrDefault(compound.func_74779_i("state"), NOT_PLAYING).getFactory().deserialize(compound.func_74775_l("data"));
        }

        static {
            MAP = Stream.of(StateType.values()).collect(Collectors.toMap(StateType::getId, Function.identity()));
        }
    }
}

