/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util.crafting;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import me.paulf.fairylights.util.crafting.GenericRecipe;
import me.paulf.fairylights.util.crafting.ingredient.AuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.BasicRegularIngredient;
import me.paulf.fairylights.util.crafting.ingredient.InertBasicAuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.LazyTagIngredient;
import me.paulf.fairylights.util.crafting.ingredient.RegularIngredient;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public final class GenericRecipeBuilder {
    private static final char EMPTY_SPACE = ' ';
    private final ResourceLocation name;
    private final Supplier<? extends IRecipeSerializer<GenericRecipe>> serializer;
    private ItemStack output;
    private char outputChar = '\u0000';
    private char[] shape = new char[0];
    private int width;
    private int height;
    private final Map<Character, RegularIngredient> ingredients = new HashMap<Character, RegularIngredient>();
    private final List<AuxiliaryIngredient<?>> auxiliaryIngredients = new ArrayList();

    public GenericRecipeBuilder(ResourceLocation name, Supplier<? extends IRecipeSerializer<GenericRecipe>> serializer) {
        this(name, serializer, ItemStack.field_190927_a);
    }

    public GenericRecipeBuilder(ResourceLocation name, Supplier<? extends IRecipeSerializer<GenericRecipe>> serializer, Item item) {
        this(name, serializer, new ItemStack((IItemProvider)item));
    }

    public GenericRecipeBuilder(ResourceLocation name, Supplier<? extends IRecipeSerializer<GenericRecipe>> serializer, Block block) {
        this(name, serializer, new ItemStack((IItemProvider)block));
    }

    public GenericRecipeBuilder(ResourceLocation name, Supplier<? extends IRecipeSerializer<GenericRecipe>> serializer, ItemStack output) {
        this.name = name;
        this.serializer = serializer;
        this.output = Objects.requireNonNull(output, "output");
    }

    public GenericRecipeBuilder withShape(String ... shape) {
        Objects.requireNonNull(shape, "shape");
        this.width = 0;
        this.height = 0;
        for (String row : shape) {
            if (row != null && row.length() > this.width) {
                this.width = row.length();
            }
            ++this.height;
        }
        StringBuilder bob = new StringBuilder();
        for (String row : shape) {
            bob.append(Strings.nullToEmpty((String)row));
            int trail = this.width - (row == null ? 0 : row.length());
            while (trail-- > 0) {
                bob.append(' ');
            }
        }
        this.shape = bob.toString().toCharArray();
        return this;
    }

    public GenericRecipeBuilder withOutput(Item item) {
        return this.withOutput(Objects.requireNonNull(item, "item"), 1);
    }

    public GenericRecipeBuilder withOutput(Item item, int size) {
        return this.withOutput(new ItemStack((IItemProvider)Objects.requireNonNull(item, "item"), size));
    }

    public GenericRecipeBuilder withOutput(Block block) {
        return this.withOutput(Objects.requireNonNull(block, "block"), 1);
    }

    public GenericRecipeBuilder withOutput(Block block, int size) {
        return this.withOutput(new ItemStack((IItemProvider)Objects.requireNonNull(block, "block"), size));
    }

    public GenericRecipeBuilder withOutput(ItemStack output) {
        this.output = Objects.requireNonNull(output, "output");
        return this;
    }

    public GenericRecipeBuilder withOutput(char key) {
        this.outputChar = key;
        return this;
    }

    public GenericRecipeBuilder withIngredient(char key, Item item) {
        return this.withIngredient(key, new ItemStack((IItemProvider)Objects.requireNonNull(item, "item"), 1));
    }

    public GenericRecipeBuilder withIngredient(char key, Block block) {
        return this.withIngredient(key, new ItemStack((IItemProvider)Objects.requireNonNull(block, "block"), 1));
    }

    public GenericRecipeBuilder withIngredient(char key, ItemStack stack) {
        return this.withIngredient(key, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Objects.requireNonNull(stack, "stack")}));
    }

    public GenericRecipeBuilder withIngredient(char key, Ingredient ingredient) {
        return this.withIngredient(key, new BasicRegularIngredient(ingredient));
    }

    public GenericRecipeBuilder withIngredient(char key, ITag<Item> tag) {
        return this.withIngredient(key, new BasicRegularIngredient(LazyTagIngredient.of(tag)));
    }

    public GenericRecipeBuilder withIngredient(char key, RegularIngredient ingredient) {
        this.ingredients.put(Character.valueOf(key), Objects.requireNonNull(ingredient, "ingredient"));
        return this;
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(Item item) {
        return this.withAuxiliaryIngredient(new ItemStack((IItemProvider)Objects.requireNonNull(item, "item")));
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(Item item, boolean isRequired, int limit) {
        return this.withAuxiliaryIngredient(new ItemStack((IItemProvider)Objects.requireNonNull(item, "item")), isRequired, limit);
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(Block block) {
        return this.withAuxiliaryIngredient(new ItemStack((IItemProvider)Objects.requireNonNull(block, "block")));
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(Block block, boolean isRequired, int limit) {
        return this.withAuxiliaryIngredient(new ItemStack((IItemProvider)Objects.requireNonNull(block, "block")), isRequired, limit);
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(ItemStack stack) {
        return this.withAuxiliaryIngredient(Objects.requireNonNull(stack, "stack"), false, 1);
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(ItemStack stack, boolean isRequired, int limit) {
        return this.withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Objects.requireNonNull(stack, "stack")}), isRequired, limit));
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(Tag<Item> tag) {
        return this.withAuxiliaryIngredient(tag, false, 1);
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(Tag<Item> tag, boolean isRequired, int limit) {
        return this.withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(LazyTagIngredient.of(tag), isRequired, limit));
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(Ingredient ingredient) {
        return this.withAuxiliaryIngredient(ingredient, false, 1);
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(Ingredient ingredient, boolean isRequired, int limit) {
        return this.withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(ingredient, isRequired, limit));
    }

    public GenericRecipeBuilder withAuxiliaryIngredient(AuxiliaryIngredient<?> ingredient) {
        this.auxiliaryIngredients.add(Objects.requireNonNull(ingredient, "ingredient"));
        return this;
    }

    public GenericRecipe build() {
        RegularIngredient[] ingredients = new RegularIngredient[this.width * this.height];
        int output = -1;
        for (int i = 0; i < this.shape.length; ++i) {
            char key = this.shape[i];
            RegularIngredient ingredient = this.ingredients.get(Character.valueOf(key));
            if (ingredient == null) {
                if (key != ' ') {
                    throw new IllegalArgumentException("An ingredient is missing for the shape, \"" + key + "\"");
                }
                ingredient = GenericRecipe.EMPTY;
            }
            ingredients[i] = ingredient;
            if (output != -1 || key != this.outputChar) continue;
            output = i;
        }
        AuxiliaryIngredient[] auxiliaryIngredients = this.auxiliaryIngredients.toArray(new AuxiliaryIngredient[0]);
        return new GenericRecipe(this.name, this.serializer, this.output, ingredients, auxiliaryIngredients, this.width, this.height, output);
    }

    private static RegularIngredient asIngredient(Object object) {
        if (object instanceof Item) {
            return new BasicRegularIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(Item)object}));
        }
        if (object instanceof Block) {
            return new BasicRegularIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(Block)object}));
        }
        if (object instanceof ItemStack) {
            return new BasicRegularIngredient(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)object}));
        }
        if (object instanceof Tag) {
            return new BasicRegularIngredient(LazyTagIngredient.of((ITag<Item>)((Tag)object)));
        }
        if (object instanceof RegularIngredient) {
            return (RegularIngredient)object;
        }
        throw new IllegalArgumentException("Unknown ingredient object: " + object);
    }
}

