/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block;

import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.entity.MerchantEntity;
import net.blay09.mods.farmingforblockheads.entity.ModEntities;
import net.blay09.mods.farmingforblockheads.tile.MarketTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class MarketBlock
extends ContainerBlock {
    public static final String name = "market";
    public static final ResourceLocation registryName = new ResourceLocation("farmingforblockheads", "market");
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape RENDER_SHAPE = Block.func_208617_a((double)0.0, (double)0.01, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public MarketBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(2.0f));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new MarketTileEntity();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext useContext) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)useContext.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        BlockPos entityPos = pos.func_177972_a(facing.func_176734_d());
        MerchantEntity.SpawnAnimationType spawnAnimationType = MerchantEntity.SpawnAnimationType.MAGIC;
        if (world.func_175710_j(entityPos)) {
            spawnAnimationType = MerchantEntity.SpawnAnimationType.FALLING;
        } else if (!world.func_175623_d(entityPos.func_177977_b())) {
            spawnAnimationType = MerchantEntity.SpawnAnimationType.DIGGING;
        }
        if (!world.field_72995_K) {
            MerchantEntity merchant = new MerchantEntity(ModEntities.merchant, world);
            merchant.setMarket(pos, facing);
            merchant.setToFacingAngle();
            merchant.setSpawnAnimation(spawnAnimationType);
            if (world.func_175710_j(entityPos)) {
                merchant.func_70107_b((double)entityPos.func_177958_n() + 0.5, entityPos.func_177956_o() + 172, (double)entityPos.func_177952_p() + 0.5);
            } else if (!world.func_175623_d(entityPos.func_177977_b())) {
                merchant.func_70107_b((double)entityPos.func_177958_n() + 0.5, entityPos.func_177956_o(), (double)entityPos.func_177952_p() + 0.5);
            } else {
                merchant.func_70107_b((double)entityPos.func_177958_n() + 0.5, entityPos.func_177956_o(), (double)entityPos.func_177952_p() + 0.5);
            }
            world.func_217376_c((Entity)merchant);
            merchant.func_213386_a((IWorld)world, world.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof MarketTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((MarketTileEntity)tileEntity), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)mirror.func_185800_a(facing).func_185831_a(facing));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return RENDER_SHAPE;
    }
}

