/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.client.gui.widget.MarketFilterButton;
import net.blay09.mods.farmingforblockheads.container.MarketBuySlot;
import net.blay09.mods.farmingforblockheads.container.MarketClientContainer;
import net.blay09.mods.farmingforblockheads.container.MarketContainer;
import net.blay09.mods.farmingforblockheads.container.MarketFakeSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MarketScreen
extends ContainerScreen<MarketContainer> {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final int VISIBLE_ROWS = 4;
    private static final ResourceLocation TEXTURE = new ResourceLocation("farmingforblockheads", "textures/gui/market.png");
    private final List<MarketFilterButton> filterButtons = Lists.newArrayList();
    private final MarketClientContainer clientContainer;
    private boolean isEventHandler;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private TextFieldWidget searchBar;

    public MarketScreen(MarketContainer container, PlayerInventory playerInventory, ITextComponent displayName) {
        super((Container)container, playerInventory, displayName);
        this.clientContainer = (MarketClientContainer)container;
    }

    public void func_231160_c_() {
        this.field_147000_g = 174;
        super.func_231160_c_();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.searchBar = new TextFieldWidget(fontRenderer, this.field_147003_i + this.field_146999_f - 78, this.field_147009_r - 5, 70, 10, this.searchBar, (ITextComponent)new StringTextComponent(""));
        this.func_212928_a((IGuiEventListener)this.searchBar);
        this.func_230480_a_((Widget)this.searchBar);
        this.updateCategoryFilters();
        if (!this.isEventHandler) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.isEventHandler = true;
        }
        this.recalculateScrollBar();
    }

    private void updateCategoryFilters() {
        IMarketCategory[] categories;
        for (MarketFilterButton filterButton : this.filterButtons) {
            this.field_230710_m_.remove((Object)filterButton);
            this.field_230705_e_.remove((Object)filterButton);
        }
        this.filterButtons.clear();
        int curY = -80;
        for (IMarketCategory category : categories = (IMarketCategory[])this.clientContainer.getCategories().stream().sorted().toArray(IMarketCategory[]::new)) {
            MarketFilterButton filterButton = new MarketFilterButton(this.field_230708_k_ / 2 + 87, this.field_230709_l_ / 2 + curY, this.clientContainer, category, button -> {
                if (this.clientContainer.getCurrentCategory() == category) {
                    this.clientContainer.setFilterCategory(null);
                } else {
                    this.clientContainer.setFilterCategory(category);
                }
                this.clientContainer.populateMarketSlots();
                this.setCurrentOffset(this.currentOffset);
            });
            this.func_230480_a_((Widget)filterButton);
            this.filterButtons.add(filterButton);
            curY += 20;
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (Math.abs(delta) > 0.0) {
            this.setCurrentOffset(delta > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (button != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 1 && mouseX >= (double)this.searchBar.field_230690_l_ && mouseX < (double)(this.searchBar.field_230690_l_ + this.searchBar.func_230998_h_()) && mouseY >= (double)this.searchBar.field_230691_m_ && mouseY < (double)(this.searchBar.field_230691_m_ + this.searchBar.getHeight())) {
            this.searchBar.func_146180_a("");
            this.clientContainer.search(null);
            this.clientContainer.populateMarketSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (mouseX >= (double)this.scrollBarXPos && mouseX <= (double)(this.scrollBarXPos + 7) && mouseY >= (double)this.scrollBarYPos && mouseY <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = (int)mouseY;
            this.indexWhenClicked = this.currentOffset;
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231042_a_(char c, int keyCode) {
        boolean result = super.func_231042_a_(c, keyCode);
        this.clientContainer.search(this.searchBar.func_146179_b());
        this.clientContainer.populateMarketSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.func_231046_a_(keyCode, scanCode, modifiers) || this.searchBar.func_230999_j_()) {
            if (keyCode == 256) {
                this.getMinecraft().field_71439_g.func_71053_j();
            } else {
                this.clientContainer.search(this.searchBar.func_146179_b());
                this.clientContainer.populateMarketSlots();
                this.setCurrentOffset(this.currentOffset);
            }
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        for (Button button : this.filterButtons) {
            if (!button.func_231047_b_((double)mouseX, (double)mouseY) || !button.field_230693_o_) continue;
            this.func_238654_b_(matrixStack, ((MarketFilterButton)button).getTooltipLines(), mouseX, mouseY);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.clientContainer.isDirty()) {
            this.updateCategoryFilters();
            this.recalculateScrollBar();
            this.clientContainer.setDirty(false);
        }
        FontRenderer fontRenderer = this.getMinecraft().field_71466_p;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r - 10, 0, 0, this.field_146999_f, this.field_147000_g + 10);
        if (((MarketContainer)this.field_147002_h).getSelectedEntry() != null && !((MarketContainer)this.field_147002_h).isReadyToBuy()) {
            this.func_238474_b_(matrixStack, this.field_147003_i + 43, this.field_147009_r + 40, 176, 0, 14, 14);
        }
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        fontRenderer.func_238405_a_(matrixStack, I18n.func_135052_a((String)"container.farmingforblockheads:market", (Object[])new Object[0]), (float)(this.field_147003_i + 10), (float)(this.field_147009_r + 10), 0xFFFFFF);
        if (((MarketContainer)this.field_147002_h).getSelectedEntry() == null) {
            this.func_238471_a_(matrixStack, fontRenderer, I18n.func_135052_a((String)"gui.farmingforblockheads:market.no_selection", (Object[])new Object[0]), this.field_147003_i + 49, this.field_147009_r + 65, 0xFFFFFF);
        } else {
            this.func_238472_a_(matrixStack, fontRenderer, (ITextProperties)this.getPriceText(((MarketContainer)this.field_147002_h).getSelectedEntry()), this.field_147003_i + 49, this.field_147009_r + 65, 0xFFFFFF);
        }
        MarketScreen.func_238467_a_((MatrixStack)matrixStack, (int)this.scrollBarXPos, (int)this.scrollBarYPos, (int)(this.scrollBarXPos + 7), (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public Collection<MarketFilterButton> getFilterButtons() {
        return this.filterButtons;
    }

    public void func_231164_f_() {
        if (this.isEventHandler) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.isEventHandler = false;
        }
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f)));
        this.scrollBarXPos = this.field_147003_i + this.field_146999_f - 7 - 9;
        this.scrollBarYPos = this.field_147009_r + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4));
        this.clientContainer.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Slot hoverSlot = this.getSlotUnderMouse();
        if (hoverSlot != null && event.getItemStack() == hoverSlot.func_75211_c()) {
            IMarketEntry hoverEntry = null;
            if (hoverSlot instanceof MarketFakeSlot) {
                hoverEntry = ((MarketFakeSlot)hoverSlot).getEntry();
            } else if (hoverSlot instanceof MarketBuySlot) {
                hoverEntry = ((MarketContainer)this.field_147002_h).getSelectedEntry();
            }
            if (hoverEntry != null) {
                event.getToolTip().add(this.getPriceTooltipText(hoverEntry));
            }
        }
    }

    private ITextComponent getPriceTooltipText(IMarketEntry entry) {
        TranslationTextComponent result = new TranslationTextComponent("gui.farmingforblockheads:market.tooltip_cost", new Object[]{this.getPriceText(entry)});
        result.func_240699_a_(this.getPriceColor(entry));
        return result;
    }

    private ITextComponent getPriceText(IMarketEntry entry) {
        TranslationTextComponent textComponent = new TranslationTextComponent("gui.farmingforblockheads:market.cost", new Object[]{entry.getCostItem().func_190916_E(), entry.getCostItem().func_200301_q()});
        textComponent.func_240699_a_(this.getPriceColor(entry));
        return textComponent;
    }

    private TextFormatting getPriceColor(IMarketEntry entry) {
        TextFormatting color = TextFormatting.GREEN;
        String unlocalizedName = entry.getCostItem().func_77977_a().toLowerCase(Locale.ENGLISH);
        if (unlocalizedName.contains("diamond")) {
            color = TextFormatting.AQUA;
        } else if (unlocalizedName.contains("gold")) {
            color = TextFormatting.YELLOW;
        } else if (unlocalizedName.contains("iron")) {
            color = TextFormatting.WHITE;
        }
        return color;
    }
}

