/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.api.IMarketOverrideData;
import net.blay09.mods.farmingforblockheads.api.IMarketRegistryDefaultHandler;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;

public class MarketRegistry {
    public static final MarketRegistry INSTANCE = new MarketRegistry();
    private final Map<ResourceLocation, IMarketCategory> indexedCategories = Maps.newHashMap();
    private final ArrayListMultimap<IMarketCategory, IMarketEntry> entries = ArrayListMultimap.create();
    private final Map<String, IMarketOverrideData> groupOverrides = Maps.newHashMap();
    private final Map<String, IMarketOverrideData> entryOverrides = Maps.newHashMap();
    private final Map<String, IMarketRegistryDefaultHandler> defaultHandlers = Maps.newHashMap();

    public static void resetCategories() {
        MarketRegistry.INSTANCE.indexedCategories.clear();
    }

    public void registerCategory(IMarketCategory category) {
        if (this.indexedCategories.containsKey(category.getRegistryName())) {
            throw new RuntimeException("Attempted to register duplicate market category " + category.getRegistryName());
        }
        this.indexedCategories.put(category.getRegistryName(), category);
    }

    public void registerGroupOverride(String key, IMarketOverrideData override) {
        this.groupOverrides.put(key, override);
    }

    public void registerEntryOverride(String key, IMarketOverrideData override) {
        this.entryOverrides.put(key, override);
    }

    public void registerEntry(ItemStack outputItem, ItemStack costItem, @Nullable IMarketCategory category) {
        String registryName = Objects.toString(outputItem.func_77973_b().getRegistryName());
        IMarketOverrideData override = this.entryOverrides.get(registryName);
        if (category == null) {
            category = MarketRegistry.determineCategory(outputItem);
        }
        if (override == null || override.isEnabled()) {
            ItemStack payment = override != null && override.getPayment() != null ? override.getPayment() : costItem;
            ItemStack alteredOutputItem = override != null ? ItemHandlerHelper.copyStackWithSize((ItemStack)outputItem, (int)override.getAmount()) : outputItem;
            this.entries.put((Object)category, (Object)new MarketEntry(alteredOutputItem, payment, category));
        }
    }

    public void registerDefaults() {
        for (Map.Entry<String, IMarketRegistryDefaultHandler> entry : this.defaultHandlers.entrySet()) {
            IMarketOverrideData override = this.groupOverrides.get(entry.getKey());
            IMarketRegistryDefaultHandler defaultHandler = entry.getValue();
            boolean enabled = defaultHandler.isEnabledByDefault();
            if (override != null) {
                enabled = override.isEnabled();
            }
            if (!enabled) continue;
            ItemStack payment = override != null && override.getPayment() != null ? override.getPayment() : defaultHandler.getDefaultPayment();
            defaultHandler.register(payment);
        }
    }

    @Nullable
    public static IMarketEntry getEntryFor(ItemStack outputItem) {
        for (IMarketEntry entry : MarketRegistry.INSTANCE.entries.values()) {
            if (!entry.getOutputItem().func_77969_a(outputItem) || !ItemStack.func_77970_a((ItemStack)entry.getOutputItem(), (ItemStack)outputItem) || outputItem.func_190916_E() != entry.getOutputItem().func_190916_E()) continue;
            return entry;
        }
        return null;
    }

    public static ArrayListMultimap<IMarketCategory, IMarketEntry> getGroupedEntries() {
        return MarketRegistry.INSTANCE.entries;
    }

    public static Collection<IMarketEntry> getEntries() {
        return MarketRegistry.INSTANCE.entries.values();
    }

    private static IMarketCategory determineCategory(ItemStack outputStack) {
        IMarketCategory category = FarmingForBlockheadsAPI.getMarketCategoryOther();
        ResourceLocation registryName = outputStack.func_77973_b().getRegistryName();
        if (registryName != null) {
            if (registryName.func_110623_a().contains("sapling")) {
                category = FarmingForBlockheadsAPI.getMarketCategorySaplings();
            } else if (registryName.func_110623_a().contains("seed")) {
                category = FarmingForBlockheadsAPI.getMarketCategorySeeds();
            } else if (registryName.func_110623_a().contains("flower")) {
                category = FarmingForBlockheadsAPI.getMarketCategoryFlowers();
            }
        }
        return category;
    }

    public static void registerDefaultHandler(String defaultKey, IMarketRegistryDefaultHandler handler) {
        if (MarketRegistry.INSTANCE.defaultHandlers.containsKey(defaultKey)) {
            throw new RuntimeException("Attempted to register duplicate default handler " + defaultKey);
        }
        MarketRegistry.INSTANCE.defaultHandlers.put(defaultKey, handler);
    }

    public static Collection<IMarketCategory> getCategories() {
        return MarketRegistry.INSTANCE.indexedCategories.values();
    }

    @Nullable
    public static IMarketCategory getCategory(ResourceLocation id) {
        return MarketRegistry.INSTANCE.indexedCategories.get(id);
    }

    public void reset() {
        this.entryOverrides.clear();
        this.groupOverrides.clear();
        this.defaultHandlers.clear();
        this.indexedCategories.clear();
        this.entries.clear();
    }
}

