/*
 * Decompiled with CFR 0.152.
 */
package com.sindarin.farsightedmobs;

import com.sindarin.farsightedmobs.Config;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="farsightedmobs")
public class FarsightedMobs {
    public static final String MOD_ID = "farsightedmobs";
    public static final Logger LOGGER = LogManager.getLogger((String)"farsightedmobs");

    public FarsightedMobs() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.serverSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register(Config.class);
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinWorldEvent event) {
        EntityType type;
        MonsterEntity mob;
        double originalFollow;
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity instanceof MonsterEntity && (originalFollow = (mob = (MonsterEntity)livingEntity).func_233638_c_(Attributes.field_233819_b_)) < (Double)Config.SERVER.defaultHostileRange.get()) {
            FarsightedMobs.ChangeBaseAttributeValue((LivingEntity)mob, Attributes.field_233819_b_, (Double)Config.SERVER.defaultHostileRange.get());
        }
        if (!Config.SERVER.mobAttributeMap.containsKey(type = livingEntity.func_200600_R())) {
            return;
        }
        List<Pair<Attribute, Double>> values = Config.SERVER.mobAttributeMap.get(type);
        for (Pair<Attribute, Double> change : values) {
            FarsightedMobs.ChangeBaseAttributeValue(livingEntity, (Attribute)change.getLeft(), (Double)change.getRight());
        }
    }

    private static void ChangeBaseAttributeValue(LivingEntity entity, Attribute attribute, double value) {
        ModifiableAttributeInstance attributeInstance = entity.func_110148_a(attribute);
        if (attributeInstance == null) {
            LOGGER.warn("No attribute instance found for " + attribute.getRegistryName());
            return;
        }
        attributeInstance.func_111128_a(value);
    }
}

