/*
 * Decompiled with CFR 0.152.
 */
package com.epic312.fruitful.common.world.biome;

import com.epic312.fruitful.core.FruitfulConfig;
import com.epic312.fruitful.core.registry.FruitfulBlocks;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.treedecorator.BeehiveTreeDecorator;
import net.minecraft.world.gen.treedecorator.CocoaTreeDecorator;
import net.minecraft.world.gen.treedecorator.LeaveVineTreeDecorator;
import net.minecraft.world.gen.treedecorator.TrunkVineTreeDecorator;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;

public class FruitfulBiomeFeatures {
    public static BlockState OAK_LOG = Blocks.field_196617_K.func_176223_P();
    public static BlockState OAK_LEAVES = Blocks.field_196642_W.func_176223_P();
    public static BlockState APPLE_OAK_LEAVES = ((Block)FruitfulBlocks.APPLE_OAK_LEAVES.get()).func_176223_P();
    public static BlockState BIRCH_LOG = Blocks.field_196619_M.func_176223_P();
    public static BlockState BIRCH_LEAVES = Blocks.field_196647_Y.func_176223_P();
    public static BlockState PEACH_BIRCH_LEAVES = ((Block)FruitfulBlocks.PEACH_BIRCH_LEAVES.get()).func_176223_P();
    public static BlockState JUNGLE_LOG = Blocks.field_196620_N.func_176223_P();
    public static BlockState JUNGLE_LEAVES = Blocks.field_196648_Z.func_176223_P();
    public static BlockState ORANGE_JUNGLE_LEAVES = ((Block)FruitfulBlocks.ORANGE_JUNGLE_LEAVES.get()).func_176223_P();
    private static Random probeRand = new Random();
    private static BlockPos probePos = new BlockPos(0, 0, 0);
    private static final BeehiveTreeDecorator FruitfulBeehiveDecorator1 = new BeehiveTreeDecorator(0.002f);
    private static final BeehiveTreeDecorator FruitfulBeehiveDecorator2 = new BeehiveTreeDecorator(0.02f);
    private static final BeehiveTreeDecorator FruitfulBeehiveDecorator3 = new BeehiveTreeDecorator(0.05f);
    public static final BaseTreeFeatureConfig APPLE_OAK_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(OAK_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(OAK_LEAVES, 99).func_227407_a_(APPLE_OAK_LEAVES, 1), (FoliagePlacer)new BlobFoliagePlacer(2, 0, 0, 0, 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig APPLE_OAK_TREE_CONFIG_1 = APPLE_OAK_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)FruitfulBeehiveDecorator1));
    public static final BaseTreeFeatureConfig APPLE_OAK_TREE_CONFIG_2 = APPLE_OAK_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)FruitfulBeehiveDecorator2));
    public static final BaseTreeFeatureConfig APPLE_OAK_TREE_WITH_MORE_BEEHIVES_CONFIG = APPLE_OAK_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)FruitfulBeehiveDecorator3));
    public static final BaseTreeFeatureConfig DENSE_APPLE_OAK_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(OAK_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(OAK_LEAVES, 8).func_227407_a_(APPLE_OAK_LEAVES, 2), (FoliagePlacer)new BlobFoliagePlacer(2, 0, 0, 0, 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig APPLE_FANCY_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(OAK_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(OAK_LEAVES, 99).func_227407_a_(APPLE_OAK_LEAVES, 1), (FoliagePlacer)new FancyFoliagePlacer(2, 0, 4, 0, 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_();
    public static final BaseTreeFeatureConfig APPLE_FANCY_TREE_CONFIG_1 = APPLE_FANCY_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)FruitfulBeehiveDecorator1));
    public static final BaseTreeFeatureConfig APPLE_FANCY_TREE_CONFIG_2 = APPLE_FANCY_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)FruitfulBeehiveDecorator2));
    public static final BaseTreeFeatureConfig APPLE_FANCY_TREE_WITH_MORE_BEEHIVES_CONFIG = APPLE_FANCY_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)FruitfulBeehiveDecorator3));
    public static final BaseTreeFeatureConfig DENSE_APPLE_FANCY_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(OAK_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(OAK_LEAVES, 8).func_227407_a_(APPLE_OAK_LEAVES, 2), (FoliagePlacer)new FancyFoliagePlacer(2, 0, 4, 0, 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_();
    public static final BaseTreeFeatureConfig PEACH_BIRCH_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BIRCH_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(BIRCH_LEAVES, 149).func_227407_a_(PEACH_BIRCH_LEAVES, 1), (FoliagePlacer)new BlobFoliagePlacer(2, 0, 0, 0, 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(5, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig PEACH_BIRCH_TREE_CONFIG_1 = PEACH_BIRCH_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)FruitfulBeehiveDecorator1));
    public static final BaseTreeFeatureConfig PEACH_BIRCH_TREE_CONFIG_2 = PEACH_BIRCH_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)FruitfulBeehiveDecorator2));
    public static final BaseTreeFeatureConfig PEACH_BIRCH_TREE_WITH_MORE_BEEHIVES_CONFIG = PEACH_BIRCH_TREE_CONFIG.func_236685_a_((List)ImmutableList.of((Object)FruitfulBeehiveDecorator3));
    public static final BaseTreeFeatureConfig TALL_PEACH_BIRCH_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BIRCH_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(BIRCH_LEAVES, 149).func_227407_a_(PEACH_BIRCH_LEAVES, 1), (FoliagePlacer)new BlobFoliagePlacer(2, 0, 0, 0, 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(5, 2, 6), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.of((Object)FruitfulBeehiveDecorator1)).func_225568_b_();
    public static final BaseTreeFeatureConfig DENSE_PEACH_BIRCH_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BIRCH_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(BIRCH_LEAVES, 10).func_227407_a_(PEACH_BIRCH_LEAVES, 2), (FoliagePlacer)new BlobFoliagePlacer(2, 0, 0, 0, 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(5, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig ORANGE_JUNGLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(JUNGLE_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(JUNGLE_LEAVES, 99).func_227407_a_(ORANGE_JUNGLE_LEAVES, 1), (FoliagePlacer)new BlobFoliagePlacer(2, 0, 0, 0, 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 8, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236703_a_((List)ImmutableList.of((Object)new CocoaTreeDecorator(0.2f), (Object)TrunkVineTreeDecorator.field_236879_b_, (Object)LeaveVineTreeDecorator.field_236871_b_)).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig ORANGE_JUNGLE_SAPLING_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(JUNGLE_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(JUNGLE_LEAVES, 99).func_227407_a_(ORANGE_JUNGLE_LEAVES, 1), (FoliagePlacer)new BlobFoliagePlacer(2, 0, 0, 0, 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 8, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig DENSE_ORANGE_JUNGLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(JUNGLE_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(JUNGLE_LEAVES, 8).func_227407_a_(ORANGE_JUNGLE_LEAVES, 2), (FoliagePlacer)new BlobFoliagePlacer(2, 0, 0, 0, 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 8, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_();

    public static void addFruitTrees(Biome biome) {
        int i;
        boolean oranges;
        boolean peaches;
        boolean apples;
        List list = biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION);
        ArrayList<ConfiguredFeature> toRemove = new ArrayList<ConfiguredFeature>();
        int listSize = list.size();
        if (((Boolean)FruitfulConfig.COMMON.whitelist.get()).booleanValue()) {
            apples = ((ArrayList)FruitfulConfig.COMMON.appleBiomes.get()).contains(biome.getRegistryName().toString());
            peaches = ((ArrayList)FruitfulConfig.COMMON.peachBiomes.get()).contains(biome.getRegistryName().toString());
            oranges = ((ArrayList)FruitfulConfig.COMMON.orangeBiomes.get()).contains(biome.getRegistryName().toString());
        } else {
            apples = !((ArrayList)FruitfulConfig.COMMON.appleBiomes.get()).contains(biome.getRegistryName().toString());
            peaches = !((ArrayList)FruitfulConfig.COMMON.peachBiomes.get()).contains(biome.getRegistryName().toString());
            oranges = !((ArrayList)FruitfulConfig.COMMON.orangeBiomes.get()).contains(biome.getRegistryName().toString());
        }
        for (i = 0; i < listSize; ++i) {
            ConfiguredFeature tempFeature;
            ConfiguredFeature configuredFeature = (ConfiguredFeature)list.get(i);
            if (!(configuredFeature.field_222738_b instanceof DecoratedFeatureConfig)) continue;
            DecoratedFeatureConfig decorated = (DecoratedFeatureConfig)configuredFeature.field_222738_b;
            if (decorated.field_214689_a.field_222738_b instanceof MultipleRandomFeatureConfig) {
                MultipleRandomFeatureConfig tree = (MultipleRandomFeatureConfig)decorated.field_214689_a.field_222738_b;
                ArrayList<ConfiguredRandomFeatureList> tempFeatures = new ArrayList<ConfiguredRandomFeatureList>();
                for (ConfiguredRandomFeatureList crfl : tree.field_202449_a) {
                    if (crfl.field_214842_a.field_222737_a instanceof TreeFeature) {
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_226739_a_ && apples) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_OAK_TREE_CONFIG), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_230132_o_ && apples) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_OAK_TREE_CONFIG_1), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_230133_p_ && apples) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_OAK_TREE_CONFIG_2), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_226816_k_ && apples) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_OAK_TREE_WITH_MORE_BEEHIVES_CONFIG), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_226815_j_ && apples) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_FANCY_TREE_CONFIG), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_230131_m_ && apples) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_FANCY_TREE_CONFIG_1), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_230134_q_ && apples) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_FANCY_TREE_CONFIG_2), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_226817_l_ && apples) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)APPLE_FANCY_TREE_WITH_MORE_BEEHIVES_CONFIG), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_226812_g_ && peaches) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PEACH_BIRCH_TREE_CONFIG), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_230129_h_ && peaches) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PEACH_BIRCH_TREE_CONFIG_1), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_230135_r_ && peaches) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PEACH_BIRCH_TREE_CONFIG_2), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_230136_s_ && peaches) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PEACH_BIRCH_TREE_WITH_MORE_BEEHIVES_CONFIG), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_230130_i_ && peaches) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)TALL_PEACH_BIRCH_TREE_CONFIG), crfl.field_214844_c));
                            continue;
                        }
                        if (crfl.field_214842_a.field_222738_b == DefaultBiomeFeatures.field_226792_b_ && oranges) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_236291_c_.func_225566_b_((IFeatureConfig)ORANGE_JUNGLE_TREE_CONFIG), crfl.field_214844_c));
                            continue;
                        }
                        tempFeatures.add(crfl);
                        continue;
                    }
                    tempFeatures.add(crfl);
                }
                if (tree.field_202452_d.field_222737_a instanceof TreeFeature) {
                    BaseTreeFeatureConfig tempDefCfg = (BaseTreeFeatureConfig)tree.field_202452_d.field_222738_b;
                    BaseTreeFeatureConfig treeCfg = (BaseTreeFeatureConfig)tree.field_202452_d.field_222738_b;
                    if (treeCfg == DefaultBiomeFeatures.field_226739_a_ && apples) {
                        tempDefCfg = APPLE_OAK_TREE_CONFIG;
                    } else if (treeCfg == DefaultBiomeFeatures.field_230132_o_ && apples) {
                        tempDefCfg = APPLE_OAK_TREE_CONFIG_1;
                    } else if (treeCfg == DefaultBiomeFeatures.field_230133_p_ && apples) {
                        tempDefCfg = APPLE_OAK_TREE_CONFIG_2;
                    } else if (treeCfg == DefaultBiomeFeatures.field_226816_k_ && apples) {
                        tempDefCfg = APPLE_OAK_TREE_WITH_MORE_BEEHIVES_CONFIG;
                    } else if (treeCfg == DefaultBiomeFeatures.field_226815_j_ && apples) {
                        tempDefCfg = APPLE_FANCY_TREE_CONFIG;
                    } else if (treeCfg == DefaultBiomeFeatures.field_230131_m_ && apples) {
                        tempDefCfg = APPLE_FANCY_TREE_CONFIG_1;
                    } else if (treeCfg == DefaultBiomeFeatures.field_230134_q_ && apples) {
                        tempDefCfg = APPLE_FANCY_TREE_CONFIG_2;
                    } else if (treeCfg == DefaultBiomeFeatures.field_226817_l_ && apples) {
                        tempDefCfg = APPLE_FANCY_TREE_WITH_MORE_BEEHIVES_CONFIG;
                    } else if (treeCfg == DefaultBiomeFeatures.field_226812_g_ && peaches) {
                        tempDefCfg = PEACH_BIRCH_TREE_CONFIG;
                    } else if (treeCfg == DefaultBiomeFeatures.field_230129_h_ && peaches) {
                        tempDefCfg = PEACH_BIRCH_TREE_CONFIG_1;
                    } else if (treeCfg == DefaultBiomeFeatures.field_230135_r_ && peaches) {
                        tempDefCfg = PEACH_BIRCH_TREE_CONFIG_2;
                    } else if (treeCfg == DefaultBiomeFeatures.field_230136_s_ && peaches) {
                        tempDefCfg = PEACH_BIRCH_TREE_WITH_MORE_BEEHIVES_CONFIG;
                    } else if (treeCfg == DefaultBiomeFeatures.field_230130_i_ && peaches) {
                        tempDefCfg = TALL_PEACH_BIRCH_TREE_CONFIG;
                    } else if (treeCfg == DefaultBiomeFeatures.field_226792_b_ && oranges) {
                        tempDefCfg = ORANGE_JUNGLE_TREE_CONFIG;
                    }
                    ConfiguredFeature tempDef = new ConfiguredFeature(tree.field_202452_d.field_222737_a, (IFeatureConfig)tempDefCfg);
                    ConfiguredFeature tempFeature2 = new ConfiguredFeature((Feature)((DecoratedFeature)configuredFeature.field_222737_a), (IFeatureConfig)new DecoratedFeatureConfig(new ConfiguredFeature(decorated.field_214689_a.field_222737_a, (IFeatureConfig)new MultipleRandomFeatureConfig(tempFeatures, tempDef)), decorated.field_214690_b));
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, tempFeature2);
                } else {
                    tempFeature = new ConfiguredFeature((Feature)((DecoratedFeature)configuredFeature.field_222737_a), (IFeatureConfig)new DecoratedFeatureConfig(new ConfiguredFeature(decorated.field_214689_a.field_222737_a, (IFeatureConfig)new MultipleRandomFeatureConfig(tempFeatures, tree.field_202452_d)), decorated.field_214690_b));
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, tempFeature);
                }
                toRemove.add(configuredFeature);
                continue;
            }
            if (!(decorated.field_214689_a.field_222738_b instanceof BaseTreeFeatureConfig)) continue;
            BaseTreeFeatureConfig tempDefCfg = (BaseTreeFeatureConfig)decorated.field_214689_a.field_222738_b;
            BaseTreeFeatureConfig treeCfg = (BaseTreeFeatureConfig)decorated.field_214689_a.field_222738_b;
            if (treeCfg == DefaultBiomeFeatures.field_226739_a_ && apples) {
                tempDefCfg = APPLE_OAK_TREE_CONFIG;
            } else if (treeCfg == DefaultBiomeFeatures.field_230132_o_ && apples) {
                tempDefCfg = APPLE_OAK_TREE_CONFIG_1;
            } else if (treeCfg == DefaultBiomeFeatures.field_230133_p_ && apples) {
                tempDefCfg = APPLE_OAK_TREE_CONFIG_2;
            } else if (treeCfg == DefaultBiomeFeatures.field_226816_k_ && apples) {
                tempDefCfg = APPLE_OAK_TREE_WITH_MORE_BEEHIVES_CONFIG;
            } else if (treeCfg == DefaultBiomeFeatures.field_226815_j_ && apples) {
                tempDefCfg = APPLE_FANCY_TREE_CONFIG;
            } else if (treeCfg == DefaultBiomeFeatures.field_230131_m_ && apples) {
                tempDefCfg = APPLE_FANCY_TREE_CONFIG_1;
            } else if (treeCfg == DefaultBiomeFeatures.field_230134_q_ && apples) {
                tempDefCfg = APPLE_FANCY_TREE_CONFIG_2;
            } else if (treeCfg == DefaultBiomeFeatures.field_226817_l_ && apples) {
                tempDefCfg = APPLE_FANCY_TREE_WITH_MORE_BEEHIVES_CONFIG;
            } else if (treeCfg == DefaultBiomeFeatures.field_226812_g_ && peaches) {
                tempDefCfg = PEACH_BIRCH_TREE_CONFIG;
            } else if (treeCfg == DefaultBiomeFeatures.field_230129_h_ && peaches) {
                tempDefCfg = PEACH_BIRCH_TREE_CONFIG_1;
            } else if (treeCfg == DefaultBiomeFeatures.field_230135_r_ && peaches) {
                tempDefCfg = PEACH_BIRCH_TREE_CONFIG_2;
            } else if (treeCfg == DefaultBiomeFeatures.field_230136_s_ && peaches) {
                tempDefCfg = PEACH_BIRCH_TREE_WITH_MORE_BEEHIVES_CONFIG;
            } else if (treeCfg == DefaultBiomeFeatures.field_230130_i_ && peaches) {
                tempDefCfg = TALL_PEACH_BIRCH_TREE_CONFIG;
            } else if (treeCfg == DefaultBiomeFeatures.field_226792_b_ && oranges) {
                tempDefCfg = ORANGE_JUNGLE_TREE_CONFIG;
            }
            tempFeature = new ConfiguredFeature((Feature)((DecoratedFeature)configuredFeature.field_222737_a), (IFeatureConfig)new DecoratedFeatureConfig(new ConfiguredFeature(decorated.field_214689_a.field_222737_a, (IFeatureConfig)tempDefCfg), decorated.field_214690_b));
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, tempFeature);
            toRemove.add(configuredFeature);
        }
        for (i = 0; i < toRemove.size(); ++i) {
            list.remove(toRemove.get(i));
        }
    }
}

