/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.NetherFossilStructure;
import net.minecraft.world.gen.NetherFossilStructure$sam$java_util_function_Function$0;
import net.minecraft.world.gen.NetherFossilStructure$sam$net_minecraft_world_gen_feature_structure_Structure_IStartFactory$0;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.futuremc.feature.BlockStateSample;
import thedarkcolour.futuremc.feature.structure.NetherFossilPieces;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u001d\u0012\u0016\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0014J\u0014\u0010\u000b\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0014J\b\u0010\f\u001a\u00020\bH\u0014J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lnet/minecraft/world/gen/NetherFossilStructure;", "Lnet/minecraft/world/gen/feature/structure/ScatteredStructure;", "Lnet/minecraft/world/gen/feature/NoFeatureConfig;", "configFactory", "Lkotlin/Function1;", "Lcom/mojang/datafixers/Dynamic;", "(Lkotlin/jvm/functions/Function1;)V", "getBiomeFeatureDistance", "", "chunkGenerator", "Lnet/minecraft/world/gen/ChunkGenerator;", "getBiomeFeatureSeparation", "getSeedModifier", "getSize", "getStartFactory", "Lnet/minecraft/world/gen/feature/structure/Structure$IStartFactory;", "getStructureName", "", "Start", "futuremc"})
public final class NetherFossilStructure
extends ScatteredStructure<NoFeatureConfig> {
    protected int func_202382_c() {
        return 14357921;
    }

    @NotNull
    public Structure.IStartFactory func_214557_a() {
        Object object = getStartFactory.1.INSTANCE;
        if (object != null) {
            Function6 function6 = object;
            object = new NetherFossilStructure$sam$net_minecraft_world_gen_feature_structure_Structure_IStartFactory$0(function6);
        }
        return (Structure.IStartFactory)object;
    }

    @NotNull
    public String func_143025_a() {
        return "Nether_Fossil";
    }

    protected int func_204030_a(@NotNull ChunkGenerator<?> chunkGenerator) {
        Intrinsics.checkNotNullParameter(chunkGenerator, (String)"chunkGenerator");
        return 2;
    }

    protected int func_211745_b(@NotNull ChunkGenerator<?> chunkGenerator) {
        Intrinsics.checkNotNullParameter(chunkGenerator, (String)"chunkGenerator");
        return 1;
    }

    public int func_202367_b() {
        return 3;
    }

    public NetherFossilStructure(@NotNull Function1<? super Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        Intrinsics.checkNotNullParameter(configFactory, (String)"configFactory");
        Function1<? super Dynamic<?>, ? extends NoFeatureConfig> function1 = configFactory;
        super((Function)new NetherFossilStructure$sam$java_util_function_Function$0(function1));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ4\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J3\u0010\u0017\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\u001f"}, d2={"Lnet/minecraft/world/gen/NetherFossilStructure$Start;", "Lnet/minecraft/world/gen/feature/structure/StructureStart;", "structure", "Lnet/minecraft/world/gen/feature/structure/Structure;", "x", "", "z", "bounds", "Lnet/minecraft/util/math/MutableBoundingBox;", "refs", "seed", "", "(Lnet/minecraft/world/gen/feature/structure/Structure;IILnet/minecraft/util/math/MutableBoundingBox;IJ)V", "init", "", "generator", "Lnet/minecraft/world/gen/ChunkGenerator;", "manager", "Lnet/minecraft/world/gen/feature/template/TemplateManager;", "chunkX", "chunkZ", "biomeIn", "Lnet/minecraft/world/biome/Biome;", "fillSample", "Lnet/minecraft/world/gen/NoiseChunkGenerator;", "states", "", "Lnet/minecraft/block/BlockState;", "(Lnet/minecraft/world/gen/NoiseChunkGenerator;II[Lnet/minecraft/block/BlockState;)V", "sample", "Lnet/minecraft/world/IBlockReader;", "futuremc"})
    public static final class Start
    extends StructureStart {
        /*
         * WARNING - void declaration
         */
        public void func_214625_a(@NotNull ChunkGenerator<?> generator, @NotNull TemplateManager manager, int chunkX, int chunkZ, @NotNull Biome biomeIn) {
            Intrinsics.checkNotNullParameter(generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Intrinsics.checkNotNullParameter((Object)biomeIn, (String)"biomeIn");
            if (!(generator instanceof NoiseChunkGenerator)) {
                return;
            }
            ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
            int x = chunkPos.func_180334_c() + this.field_214631_d.nextInt(16);
            int z = chunkPos.func_180333_d() + this.field_214631_d.nextInt(16);
            int seaLevel = ((NoiseChunkGenerator)generator).func_222530_f();
            int i = seaLevel + this.field_214631_d.nextInt(((NoiseChunkGenerator)generator).func_207511_e() - 2 - seaLevel);
            IBlockReader sample = this.sample((NoiseChunkGenerator)generator, x, z);
            BlockPos.Mutable pos = new BlockPos.Mutable(x, i, z);
            int n = i;
            int n2 = seaLevel;
            if (n >= n2) {
                while (true) {
                    void j;
                    BlockState state = sample.func_180495_p((BlockPos)pos);
                    boolean hasAir = state.isAir(sample, (BlockPos)pos);
                    pos.func_196234_d(0, -1, 0);
                    BlockState state1 = sample.func_180495_p((BlockPos)pos);
                    if (hasAir) {
                        BlockState blockState = state1;
                        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"state1");
                        if (Intrinsics.areEqual((Object)blockState.func_177230_c(), (Object)Blocks.field_150425_aM) || state1.func_224755_d(sample, (BlockPos)pos, Direction.UP)) break;
                    }
                    if (j == n2) break;
                    --j;
                }
            }
            if (i > seaLevel) {
                List list = this.field_75075_a;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"components");
                SharedSeedRandom sharedSeedRandom = this.field_214631_d;
                Intrinsics.checkNotNullExpressionValue((Object)sharedSeedRandom, (String)"rand");
                NetherFossilPieces.INSTANCE.start(manager, list, sharedSeedRandom, (BlockPos)pos);
                this.func_202500_a();
            }
        }

        private final IBlockReader sample(NoiseChunkGenerator<?> $this$sample, int x, int z) {
            int n = $this$sample.field_222566_m * $this$sample.field_222563_j;
            BlockState[] blockStateArray = new BlockState[n];
            int n2 = 0;
            while (n2 < n) {
                BlockState blockState;
                int n3 = n2;
                int n4 = n2++;
                BlockState[] blockStateArray2 = blockStateArray;
                boolean bl = false;
                Block block = Blocks.field_150350_a;
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"Blocks.AIR");
                Intrinsics.checkNotNullExpressionValue((Object)block.func_176223_P(), (String)"Blocks.AIR.defaultState");
                blockStateArray2[n4] = blockState;
            }
            BlockState[] states = blockStateArray;
            this.fillSample($this$sample, x, z, states);
            return new BlockStateSample(states);
        }

        /*
         * WARNING - void declaration
         */
        private final void fillSample(NoiseChunkGenerator<?> $this$fillSample, int x, int z, BlockState[] states) {
            int i = Math.floorDiv(x, $this$fillSample.field_222564_k);
            int j = Math.floorDiv(z, $this$fillSample.field_222564_k);
            int k = Math.floorMod(x, $this$fillSample.field_222564_k);
            int l = Math.floorMod(z, $this$fillSample.field_222564_k);
            double d0 = (double)k / (double)$this$fillSample.field_222564_k;
            double d1 = (double)l / (double)$this$fillSample.field_222564_k;
            double[][] adouble = new double[][]{$this$fillSample.func_222547_b(i, j), $this$fillSample.func_222547_b(i, j + 1), $this$fillSample.func_222547_b(i + 1, j), $this$fillSample.func_222547_b(i + 1, j + 1)};
            int i1 = $this$fillSample.func_222530_f();
            int n = $this$fillSample.field_222566_m - 1;
            boolean bl = false;
            while (n >= 0) {
                void j1;
                double d2 = adouble[0][j1];
                double d3 = adouble[1][j1];
                double d4 = adouble[2][j1];
                double d5 = adouble[3][j1];
                double d6 = adouble[0][j1 + true];
                double d7 = adouble[1][j1 + true];
                double d8 = adouble[2][j1 + true];
                double d9 = adouble[3][j1 + true];
                int n2 = $this$fillSample.field_222563_j - 1;
                boolean bl2 = false;
                while (n2 >= 0) {
                    void k1;
                    block5: {
                        void l1;
                        double d11;
                        block4: {
                            double d10 = (double)k1 / (double)$this$fillSample.field_222563_j;
                            d11 = MathHelper.func_219807_a((double)d10, (double)d0, (double)d1, (double)d2, (double)d6, (double)d4, (double)d8, (double)d3, (double)d7, (double)d5, (double)d9);
                            l1 = j1 * $this$fillSample.field_222563_j + k1;
                            if (d11 > 0.0) break block4;
                            if (l1 >= i1) break block5;
                        }
                        BlockState blockState = d11 > 0.0 ? $this$fillSample.field_222559_f : (l1 < $this$fillSample.func_222530_f() ? $this$fillSample.field_222560_g : SurfaceBuilder.field_215409_f);
                        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"blockState");
                    }
                    --k1;
                }
                --j1;
            }
        }

        public Start(@NotNull Structure<?> structure, int x, int z, @NotNull MutableBoundingBox bounds, int refs, long seed) {
            Intrinsics.checkNotNullParameter(structure, (String)"structure");
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            super(structure, x, z, bounds, refs, seed);
        }
    }
}

