/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.futuremc.registry.FSounds;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Lthedarkcolour/futuremc/block/RespawnAnchorBlock;", "Lnet/minecraft/block/Block;", "properties", "Lnet/minecraft/block/Block$Properties;", "(Lnet/minecraft/block/Block$Properties;)V", "getComparatorInputOverride", "", "state", "Lnet/minecraft/block/BlockState;", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getLightValue", "world", "Lnet/minecraft/world/IBlockReader;", "hasComparatorInputOverride", "", "onUse", "Lnet/minecraft/util/ActionResultType;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "hit", "Lnet/minecraft/util/math/BlockRayTraceResult;", "Companion", "futuremc"})
public final class RespawnAnchorBlock
extends Block {
    private static final IntegerProperty CHARGES;
    public static final Companion Companion;

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull PlayerEntity player, @NotNull Hand hand, @NotNull BlockRayTraceResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        ItemStack stack = player.func_184586_b(hand);
        if (hand == Hand.MAIN_HAND) {
            ItemStack itemStack = stack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"stack");
            if (!Companion.isChargeItem(itemStack)) {
                ItemStack itemStack2 = player.func_184586_b(Hand.OFF_HAND);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"player.getHeldItem(Hand.OFF_HAND)");
                if (Companion.isChargeItem(itemStack2)) {
                    return ActionResultType.PASS;
                }
            }
        }
        ItemStack itemStack = stack;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"stack");
        if (Companion.isChargeItem(itemStack)) {
            RespawnAnchorBlock.Companion.charge(worldIn, pos, state);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        Integer n = (Integer)state.func_177229_b((IProperty)CHARGES);
        if (n != null && n == 0) {
            return ActionResultType.PASS;
        }
        if (!RespawnAnchorBlock.Companion.isNether(worldIn)) {
            if (!worldIn.field_72995_K) {
                Companion.explode(state, worldIn, pos);
            }
            return ActionResultType.SUCCESS;
        }
        if (player instanceof ServerPlayerEntity) {
            Dimension dimension = worldIn.field_73011_w;
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"worldIn.dimension");
            DimensionType type = dimension.func_186058_p();
            if (Intrinsics.areEqual((Object)((ServerPlayerEntity)player).getSpawnDimension(), (Object)type) ^ true || Intrinsics.areEqual((Object)player.getBedLocation(type), (Object)pos) ^ true) {
                player.setSpawnPoint(pos, false, true, type);
                worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, FSounds.INSTANCE.getBLOCK_RESPAWN_ANCHOR_SET_SPAWN(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
        }
        return Companion.canCharge(state) ? ActionResultType.PASS : ActionResultType.CONSUME;
    }

    public int getLightValue(@NotNull BlockState state, @NotNull IBlockReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        float f = (float)((Number)((Object)state.func_177229_b((IProperty)CHARGES))).intValue() / 4.0f * 15.0f;
        boolean bl = false;
        return (int)Math.floor(f);
    }

    public boolean func_149740_M(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    public int func_180641_l(@NotNull BlockState state, @NotNull World worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return state.getLightValue((IBlockReader)worldIn, pos);
    }

    public RespawnAnchorBlock(@NotNull Block.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    static {
        Companion = new Companion(null);
        CHARGES = IntegerProperty.func_177719_a((String)"charges", (int)0, (int)4);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lthedarkcolour/futuremc/block/RespawnAnchorBlock$Companion;", "", "()V", "CHARGES", "Lnet/minecraft/state/IntegerProperty;", "kotlin.jvm.PlatformType", "getCHARGES", "()Lnet/minecraft/state/IntegerProperty;", "canCharge", "", "state", "Lnet/minecraft/block/BlockState;", "charge", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "explode", "hasWaterSource", "isChargeItem", "stack", "Lnet/minecraft/item/ItemStack;", "isNether", "futuremc"})
    public static final class Companion {
        public final IntegerProperty getCHARGES() {
            return CHARGES;
        }

        public final boolean isChargeItem(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)Items.field_221695_cJ);
        }

        public final boolean canCharge(@NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return ((Number)((Object)state.func_177229_b((IProperty)this.getCHARGES()))).intValue() < 4;
        }

        /*
         * WARNING - void declaration
         */
        public final void explode(@NotNull BlockState state, @NotNull World worldIn, @NotNull BlockPos pos) {
            boolean bl;
            block4: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                worldIn.func_217377_a(pos, false);
                Iterable $this$map$iv = (Iterable)Direction.Plane.HORIZONTAL;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p1;
                    Direction direction = (Direction)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    BlockPos blockPos = pos.func_177972_a((Direction)p1);
                    collection.add(blockPos);
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BlockPos it = (BlockPos)element$iv;
                        boolean bl3 = false;
                        BlockPos blockPos = it;
                        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"it");
                        if (!Companion.hasWaterSource(blockPos, worldIn)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean bool = bl;
        }

        private final boolean hasWaterSource(BlockPos pos, World worldIn) {
            boolean bl;
            IFluidState state = worldIn.func_204610_c(pos);
            if (!state.func_206884_a(FluidTags.field_206959_a)) {
                bl = false;
            } else {
                IFluidState state2;
                int f;
                IFluidState iFluidState = state;
                Intrinsics.checkNotNullExpressionValue((Object)iFluidState, (String)"state");
                bl = iFluidState.func_206889_d() ? true : ((float)(f = state.func_206882_g()) < 2.0f ? false : !(state2 = worldIn.func_204610_c(pos.func_177977_b())).func_206884_a(FluidTags.field_206959_a));
            }
            return bl;
        }

        private final boolean isNether(World worldIn) {
            Dimension dimension = worldIn.field_73011_w;
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"worldIn.dimension");
            return dimension.func_177495_o();
        }

        private final void charge(World worldIn, BlockPos pos, BlockState state) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)this.getCHARGES(), (Comparable)Integer.valueOf(((Number)((Object)state.func_177229_b((IProperty)this.getCHARGES()))).intValue() + 1)));
            worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, FSounds.INSTANCE.getBLOCK_RESPAWN_ANCHOR_CHARGE(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

