/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block.vine;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.futuremc.block.vine.AbstractPlantPartBlock;
import thedarkcolour.futuremc.block.vine.AbstractPlantStemBlock;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0016J(\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010#\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010&\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010'2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0018\u0010*\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0016J(\u0010-\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J8\u0010.\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u0002002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0013H\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u00062"}, d2={"Lthedarkcolour/futuremc/block/vine/AbstractPlantBlock;", "Lthedarkcolour/futuremc/block/vine/AbstractPlantPartBlock;", "properties", "Lnet/minecraft/block/Block$Properties;", "direction", "Lnet/minecraft/util/Direction;", "outlineShape", "Lnet/minecraft/util/math/shapes/VoxelShape;", "tickWater", "", "(Lnet/minecraft/block/Block$Properties;Lnet/minecraft/util/Direction;Lnet/minecraft/util/math/shapes/VoxelShape;Z)V", "plant", "Lnet/minecraft/block/Block;", "getPlant", "()Lnet/minecraft/block/Block;", "canGrow", "worldIn", "Lnet/minecraft/world/IBlockReader;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/BlockState;", "isClient", "canUseBonemeal", "Lnet/minecraft/world/World;", "rand", "Ljava/util/Random;", "getPickBlock", "Lnet/minecraft/item/ItemStack;", "target", "Lnet/minecraft/util/math/RayTraceResult;", "world", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "getStemPos", "grow", "", "Lnet/minecraft/world/server/ServerWorld;", "isLadder", "Lnet/minecraft/world/IWorldReader;", "entity", "Lnet/minecraft/entity/LivingEntity;", "isReplaceable", "context", "Lnet/minecraft/item/BlockItemUseContext;", "scheduledTick", "updatePostPlacement", "newState", "Lnet/minecraft/world/IWorld;", "posFrom", "futuremc"})
public abstract class AbstractPlantBlock
extends AbstractPlantPartBlock {
    @Override
    @NotNull
    public Block getPlant() {
        return this;
    }

    public void func_225534_a_(@NotNull BlockState state, @NotNull ServerWorld worldIn, @NotNull BlockPos pos, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_225521_a_(pos, true, null);
        }
    }

    @NotNull
    public BlockState func_196271_a(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState newState, @NotNull IWorld worldIn, @NotNull BlockPos pos, @NotNull BlockPos posFrom) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)posFrom, (String)"posFrom");
        if (direction == this.getGrowthDirection().func_176734_d() && !state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
        if (direction == this.getGrowthDirection()) {
            Block block = newState.func_177230_c();
            AbstractPlantStemBlock stem = this.getStem();
            if (Intrinsics.areEqual((Object)block, (Object)((Object)this)) ^ true && Intrinsics.areEqual((Object)block, (Object)((Object)stem)) ^ true) {
                return stem.getRandomGrowthState(worldIn);
            }
        }
        if (this.getTickWater()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        BlockState blockState = super.func_196271_a(state, direction, newState, worldIn, pos, posFrom);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"super.updatePostPlacemen\u2026e, worldIn, pos, posFrom)");
        return blockState;
    }

    @NotNull
    public ItemStack getPickBlock(@NotNull BlockState state, @NotNull RayTraceResult target, @NotNull IBlockReader world, @NotNull BlockPos pos, @NotNull PlayerEntity player) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new ItemStack((IItemProvider)this.getStem());
    }

    public boolean func_176473_a(@NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull BlockState state, boolean isClient) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BlockPos blockPos = this.getStemPos(worldIn, pos, state);
        BlockPos stemPos = blockPos != null ? blockPos.func_177972_a(this.getStem().getGrowthDirection()) : null;
        return stemPos != null && worldIn.func_180495_p(stemPos).isAir(worldIn, stemPos);
    }

    public boolean func_180670_a(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    public void func_225535_a_(@NotNull ServerWorld worldIn, @NotNull Random rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BlockPos a = this.getStemPos((IBlockReader)worldIn, pos, state);
        if (a != null) {
            BlockState state1;
            BlockState blockState = state1 = worldIn.func_180495_p(a);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"state1");
            Block block = blockState.func_177230_c();
            if (block == null) {
                throw new NullPointerException("null cannot be cast to non-null type thedarkcolour.futuremc.block.vine.AbstractPlantStemBlock");
            }
            ((AbstractPlantStemBlock)block).func_225535_a_(worldIn, rand, a, state1);
        }
    }

    private final BlockPos getStemPos(IBlockReader worldIn, BlockPos pos, BlockState state) {
        BlockPos.Mutable pos1 = new BlockPos.Mutable(pos);
        BlockState block = null;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)pos1.func_189536_c(this.getGrowthDirection()), (String)"pos1.move(growthDirection)");
            Intrinsics.checkNotNullExpressionValue((Object)worldIn.func_180495_p((BlockPos)pos1), (String)"worldIn.getBlockState(pos1)");
        } while (Intrinsics.areEqual((Object)block, (Object)state));
        return Intrinsics.areEqual((Object)block.func_177230_c(), (Object)((Object)this.getStem())) ? (BlockPos)pos1 : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_196253_a(@NotNull BlockState state, @NotNull BlockItemUseContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean bl = super.func_196253_a(state, context);
        if (bl) {
            ItemStack itemStack = context.func_195996_i();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"context.item");
            if (Intrinsics.areEqual((Object)itemStack.func_77973_b(), (Object)this.getStem().func_199767_j())) {
                return false;
            }
        }
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isLadder(@Nullable BlockState state, @Nullable IWorldReader world, @Nullable BlockPos pos, @Nullable LivingEntity entity) {
        return true;
    }

    public AbstractPlantBlock(@NotNull Block.Properties properties, @NotNull Direction direction, @NotNull VoxelShape outlineShape, boolean tickWater) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)outlineShape, (String)"outlineShape");
        super(properties, direction, outlineShape, tickWater);
    }
}

