/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;
import thedarkcolour.futuremc.compat.crafttweaker.SmithingTable;
import thedarkcolour.futuremc.recipe.DarkRecipeType;
import thedarkcolour.futuremc.recipe.SmithingRecipe;
import thedarkcolour.futuremc.registry.FRecipes;

@ZenRegister
@ZenCodeType.Name(value="futuremc.crafttweaker.SmithingTable")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lthedarkcolour/futuremc/compat/crafttweaker/SmithingTable;", "Lcom/blamejared/crafttweaker/api/managers/IRecipeManager;", "()V", "addRecipe", "", "recipeName", "", "result", "Lcom/blamejared/crafttweaker/api/item/IItemStack;", "input", "Lcom/blamejared/crafttweaker/api/item/IIngredient;", "material", "materialCost", "", "checkRecipeName", "name", "fixName", "getRecipeType", "Lthedarkcolour/futuremc/recipe/DarkRecipeType;", "Lthedarkcolour/futuremc/recipe/SmithingRecipe;", "futuremc"})
public final class SmithingTable
implements IRecipeManager {
    public static final SmithingTable INSTANCE;

    @NotNull
    public DarkRecipeType<SmithingRecipe> getRecipeType() {
        return FRecipes.INSTANCE.getSMITHING();
    }

    @ZenCodeType.Method
    @JvmStatic
    public static final void addRecipe(@NotNull String recipeName, @NotNull IItemStack result, @NotNull IIngredient input2, @NotNull IIngredient material, int materialCost) {
        Intrinsics.checkNotNullParameter((Object)recipeName, (String)"recipeName");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        INSTANCE.checkRecipeName(recipeName);
        IRecipeManager iRecipeManager = INSTANCE;
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipeName);
        Ingredient ingredient = input2.asVanillaIngredient();
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"input.asVanillaIngredient()");
        Ingredient ingredient2 = material.asVanillaIngredient();
        Intrinsics.checkNotNullExpressionValue((Object)ingredient2, (String)"material.asVanillaIngredient()");
        ItemStack itemStack = result.getInternal();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"result.internal");
        CraftTweakerAPI.apply((IAction)((IAction)new ActionAddRecipe(iRecipeManager, (IRecipe)new SmithingRecipe(resourceLocation, ingredient, ingredient2, materialCost, itemStack), "")));
    }

    private final String checkRecipeName(String name) {
        String fixedName = this.fixName(name);
        boolean bl = fixedName.chars().allMatch(checkRecipeName.1.INSTANCE);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Given name does not fit the \"[a-z0-9/._-]\" regex! Name: \"" + fixedName + '\"';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return fixedName;
    }

    private final String fixName(String name) {
        String temp;
        boolean bl;
        String string;
        CharSequence charSequence;
        String fixed = name;
        if (StringsKt.indexOf$default((CharSequence)fixed, (char)':', (int)0, (boolean)false, (int)6, null) >= 0) {
            charSequence = fixed;
            string = ":";
            boolean bl2 = false;
            string = new Regex(string);
            String string2 = ".";
            bl = false;
            temp = string.replace(charSequence, string2);
            CraftTweakerAPI.logWarning((String)("Invalid recipe name \"" + fixed + "\", recipe names cannot have a \":\"! New recipe name: \"" + temp + '\"'), (Object[])new Object[0]);
            fixed = temp;
        }
        if (StringsKt.indexOf$default((CharSequence)fixed, (char)' ', (int)0, (boolean)false, (int)6, null) >= 0) {
            charSequence = fixed;
            string = " ";
            boolean bl3 = false;
            string = new Regex(string);
            String string3 = ".";
            bl = false;
            temp = string.replace(charSequence, string3);
            CraftTweakerAPI.logWarning((String)("Invalid recipe name \"" + fixed + "\", recipe names cannot have a \" \"! New recipe name: \"" + temp + '\"'), (Object[])new Object[0]);
            fixed = temp;
        }
        temp = fixed;
        boolean bl4 = false;
        String string4 = temp;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        if (Intrinsics.areEqual((Object)string5, (Object)fixed) ^ true) {
            String string6 = fixed;
            boolean bl5 = false;
            String string7 = string6;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
            temp = string8;
            CraftTweakerAPI.logWarning((String)("Invalid recipe name \"" + fixed + "\", recipe names have to be lowercase! New recipe name: \"" + temp + '\"'), (Object[])new Object[0]);
            fixed = temp;
        }
        return fixed;
    }

    private SmithingTable() {
    }

    static {
        SmithingTable smithingTable;
        INSTANCE = smithingTable = new SmithingTable();
    }
}

