/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.futuremc.feature.BasaltColumnsConfig;
import thedarkcolour.futuremc.feature.BlockPosUtil;
import thedarkcolour.futuremc.registry.FBlocks;
import thedarkcolour.futuremc.util.UtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\b\u0001\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a8\u0006\u0014"}, d2={"Lthedarkcolour/futuremc/feature/BasaltColumnsFeature;", "Lnet/minecraft/world/gen/feature/Feature;", "Lthedarkcolour/futuremc/feature/BasaltColumnsConfig;", "codec", "Ljava/util/function/Function;", "Lcom/mojang/datafixers/Dynamic;", "(Ljava/util/function/Function;)V", "place", "", "worldIn", "Lnet/minecraft/world/IWorld;", "generator", "Lnet/minecraft/world/gen/ChunkGenerator;", "Lnet/minecraft/world/gen/GenerationSettings;", "rand", "Ljava/util/Random;", "pos", "Lnet/minecraft/util/math/BlockPos;", "config", "Companion", "futuremc"})
public final class BasaltColumnsFeature
extends Feature<BasaltColumnsConfig> {
    private static final ImmutableList<Block> NETHER_BLOCKS;
    public static final Companion Companion;

    /*
     * Unable to fully structure code
     */
    public boolean place(@NotNull IWorld worldIn, @NotNull ChunkGenerator<? extends GenerationSettings> generator, @NotNull Random rand, @NotNull BlockPos pos, @NotNull BasaltColumnsConfig config) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter(generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        seaLevel = generator.func_222530_f();
        position = thedarkcolour.futuremc.feature.BasaltColumnsFeature$Companion.access$getPlacementPos(BasaltColumnsFeature.Companion, worldIn, seaLevel, UtilKt.clampAxis(new BlockPos.Mutable(pos), Direction.Axis.Y, 1, generator.func_207511_e() - 1), 0x7FFFFFFF);
        if (position == null) {
            return false;
        }
        height = thedarkcolour.futuremc.feature.BasaltColumnsFeature$Companion.access$getHeight(BasaltColumnsFeature.Companion, rand, config);
        large = rand.nextFloat() < 0.9f;
        var11_10 = large != false ? 5 : 8;
        var12_11 = false;
        k = Math.min(height, var11_10);
        l = large != false ? 50 : 15;
        b1 = false;
        for (BlockPos p : BlockPosUtil.getColumnHeightmap(rand, l, position.func_177958_n() - k, position.func_177956_o(), position.func_177952_p() - k, position.func_177958_n() + k, position.func_177956_o(), position.func_177952_p() + k)) {
            strength = height - p.func_218139_n((Vec3i)position);
            if (strength < 0) continue;
            if (b1) ** GOTO lbl-1000
            v0 = p;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"p");
            if (thedarkcolour.futuremc.feature.BasaltColumnsFeature$Companion.access$placeBasalt(BasaltColumnsFeature.Companion, worldIn, seaLevel, v0, strength, thedarkcolour.futuremc.feature.BasaltColumnsFeature$Companion.access$getReach(BasaltColumnsFeature.Companion, rand, config))) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            b1 = v1;
        }
        return b1;
    }

    public BasaltColumnsFeature(@NotNull Function<Dynamic<?>, ? extends BasaltColumnsConfig> codec) {
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        super(codec);
    }

    static {
        Companion = new Companion(null);
        NETHER_BLOCKS = ImmutableList.of((Object)Blocks.field_150353_l, (Object)Blocks.field_150357_h, (Object)Blocks.field_196814_hQ, (Object)Blocks.field_150425_aM, (Object)Blocks.field_196653_dH, (Object)Blocks.field_150386_bk, (Object)Blocks.field_150387_bl, (Object)Blocks.field_150388_bm, (Object)Blocks.field_150486_ae, (Object)Blocks.field_150474_ac);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J*\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\bH\u0002J0\u0010\u001b\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lthedarkcolour/futuremc/feature/BasaltColumnsFeature$Companion;", "", "()V", "NETHER_BLOCKS", "Lcom/google/common/collect/ImmutableList;", "Lnet/minecraft/block/Block;", "kotlin.jvm.PlatformType", "adjustHeight", "Lnet/minecraft/util/math/BlockPos;", "worldIn", "Lnet/minecraft/world/IWorld;", "mutable", "Lnet/minecraft/util/math/BlockPos$Mutable;", "distance", "", "getHeight", "rand", "Ljava/util/Random;", "config", "Lthedarkcolour/futuremc/feature/BasaltColumnsConfig;", "getPlacementPos", "seaLevel", "attempts", "getReach", "isReplaceableSpace", "", "pos", "placeBasalt", "strength", "reach", "futuremc"})
    public static final class Companion {
        private final BlockPos getPlacementPos(IWorld worldIn, int seaLevel, BlockPos.Mutable mutable, int attempts) {
            int attemptsRemaining = attempts;
            while (mutable.func_177956_o() > 1 && attemptsRemaining > 0) {
                --attemptsRemaining;
                if (this.isReplaceableSpace(worldIn, seaLevel, (BlockPos)mutable)) {
                    BlockState state = worldIn.func_180495_p((BlockPos)mutable.func_189536_c(Direction.DOWN));
                    mutable.func_189536_c(Direction.UP);
                    if (!state.isAir((IBlockReader)worldIn, mutable.func_185334_h())) {
                        ImmutableList immutableList = NETHER_BLOCKS;
                        BlockState blockState = state;
                        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"state");
                        if (!immutableList.contains((Object)blockState.func_177230_c())) {
                            return (BlockPos)mutable;
                        }
                    }
                }
                mutable.func_189536_c(Direction.DOWN);
            }
            return null;
        }

        private final int getHeight(Random rand, BasaltColumnsConfig config) {
            return config.getMinimumHeight() + rand.nextInt(config.getMaximumHeight() - config.getMinimumHeight() + 1);
        }

        private final boolean placeBasalt(IWorld worldIn, int seaLevel, BlockPos pos, int strength, int reach) {
            boolean flag = false;
            block0: for (BlockPos p : BlockPos.func_191531_b((int)(pos.func_177958_n() - reach), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - reach), (int)(pos.func_177958_n() + reach), (int)pos.func_177956_o(), (int)(pos.func_177952_p() + reach))) {
                int distance = p.func_218139_n((Vec3i)pos);
                BlockPos blockPos = p;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"p");
                BlockPos placementPos = this.isReplaceableSpace(worldIn, seaLevel, blockPos) ? this.getPlacementPos(worldIn, seaLevel, new BlockPos.Mutable(p), distance) : this.adjustHeight(worldIn, new BlockPos.Mutable(p), distance);
                if (placementPos == null) continue;
                BlockPos.Mutable mutable = new BlockPos.Mutable(placementPos);
                for (int j = strength - distance / 2; j >= 0; --j) {
                    if (this.isReplaceableSpace(worldIn, seaLevel, (BlockPos)mutable)) {
                        worldIn.func_180501_a((BlockPos)mutable, FBlocks.INSTANCE.getBASALT().func_176223_P(), 3);
                        mutable.func_189536_c(Direction.UP);
                        flag = true;
                        continue;
                    }
                    BlockState blockState = worldIn.func_180495_p((BlockPos)mutable);
                    Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"worldIn.getBlockState(mutable)");
                    if (Intrinsics.areEqual((Object)blockState.func_177230_c(), (Object)FBlocks.INSTANCE.getBASALT()) ^ true) continue block0;
                    mutable.func_189536_c(Direction.UP);
                }
            }
            return flag;
        }

        private final BlockPos adjustHeight(IWorld worldIn, BlockPos.Mutable mutable, int distance) {
            for (int i = distance; mutable.func_177956_o() < worldIn.func_217301_I() && i > 0; --i) {
                BlockState state = worldIn.func_180495_p((BlockPos)mutable);
                ImmutableList immutableList = NETHER_BLOCKS;
                BlockState blockState = state;
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"state");
                if (immutableList.contains((Object)blockState.func_177230_c())) {
                    return null;
                }
                if (state.isAir((IBlockReader)worldIn, mutable.func_185334_h())) {
                    return (BlockPos)mutable;
                }
                mutable.func_189536_c(Direction.UP);
            }
            return null;
        }

        private final int getReach(Random rand, BasaltColumnsConfig config) {
            return config.getMinimumReach() + rand.nextInt(config.getMaximumReach() - config.getMinimumReach() + 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isReplaceableSpace(IWorld worldIn, int seaLevel, BlockPos pos) {
            BlockState state = worldIn.func_180495_p(pos);
            if (state.isAir((IBlockReader)worldIn, pos)) return true;
            BlockState blockState = state;
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"state");
            IFluidState iFluidState = blockState.func_204520_s();
            Intrinsics.checkNotNullExpressionValue((Object)iFluidState, (String)"state.fluidState");
            if (!iFluidState.func_206886_c().func_207185_a(FluidTags.field_206960_b)) return false;
            if (pos.func_177956_o() > seaLevel) return false;
            return true;
        }

        private Companion() {
        }

        public static final /* synthetic */ BlockPos access$getPlacementPos(Companion $this, IWorld worldIn, int seaLevel, BlockPos.Mutable mutable, int attempts) {
            return $this.getPlacementPos(worldIn, seaLevel, mutable, attempts);
        }

        public static final /* synthetic */ int access$getHeight(Companion $this, Random rand, BasaltColumnsConfig config) {
            return $this.getHeight(rand, config);
        }

        public static final /* synthetic */ boolean access$placeBasalt(Companion $this, IWorld worldIn, int seaLevel, BlockPos pos, int strength, int reach) {
            return $this.placeBasalt(worldIn, seaLevel, pos, strength, reach);
        }

        public static final /* synthetic */ int access$getReach(Companion $this, Random rand, BasaltColumnsConfig config) {
            return $this.getReach(rand, config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

