/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.futuremc.feature.BlockPosUtil;
import thedarkcolour.futuremc.feature.DeltaFeature$sam$java_util_function_Function$0;
import thedarkcolour.futuremc.feature.DeltaFeatureConfig;
import thedarkcolour.futuremc.util.UtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u001d\u0012\u0016\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J8\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\n2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a8\u0006\u001e"}, d2={"Lthedarkcolour/futuremc/feature/DeltaFeature;", "Lnet/minecraft/world/gen/feature/Feature;", "Lthedarkcolour/futuremc/feature/DeltaFeatureConfig;", "configFactoryIn", "Lkotlin/Function1;", "Lcom/mojang/datafixers/Dynamic;", "(Lkotlin/jvm/functions/Function1;)V", "canPlace", "", "worldAccess", "Lnet/minecraft/world/IWorld;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "deltaFeatureConfig", "getRadius", "", "rand", "Ljava/util/Random;", "config", "getRimSize", "getStartingPosition", "worldIn", "mutable", "Lnet/minecraft/util/math/BlockPos$Mutable;", "place", "generator", "Lnet/minecraft/world/gen/ChunkGenerator;", "Lnet/minecraft/world/gen/GenerationSettings;", "pos", "Companion", "futuremc"})
public final class DeltaFeature
extends Feature<DeltaFeatureConfig> {
    @NotNull
    private static final Set<Block> INVALID_BLOCKS;
    @NotNull
    private static final Direction[] DIRECTIONS;
    public static final Companion Companion;

    public boolean place(@NotNull IWorld worldIn, @NotNull ChunkGenerator<? extends GenerationSettings> generator, @NotNull Random rand, @NotNull BlockPos pos, @NotNull DeltaFeatureConfig config) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter(generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        BlockPos pos1 = this.getStartingPosition(worldIn, UtilKt.clampAxis(new BlockPos.Mutable(pos), Direction.Axis.Y, 1, worldIn.func_217301_I() - 1));
        if (pos1 == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = rand.nextDouble() < 0.9;
        int i = bl2 ? this.getRimSize(rand, config) : 0;
        int j = bl2 ? this.getRimSize(rand, config) : 0;
        boolean bl3 = bl2 && i != 0 && j != 0;
        int k = this.getRadius(rand, config);
        int l = this.getRadius(rand, config);
        int m = RangesKt.coerceAtLeast((int)k, (int)l);
        for (BlockPos blockPos3 : BlockPosUtil.iterateOutwards(pos, k, 0, l)) {
            BlockPos blockPos4;
            if (blockPos3.func_218139_n((Vec3i)pos1) > m) break;
            BlockPos blockPos = blockPos3;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPos3");
            if (!this.canPlace(worldIn, blockPos, config)) continue;
            if (bl3) {
                bl = true;
                this.func_202278_a((IWorldWriter)worldIn, blockPos3, config.getRim());
            }
            BlockPos blockPos2 = blockPos4 = blockPos3.func_177982_a(i, 0, j);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"blockPos4");
            if (!this.canPlace(worldIn, blockPos2, config)) continue;
            bl = true;
            this.func_202278_a((IWorldWriter)worldIn, blockPos4, config.getContents());
        }
        return bl;
    }

    private final BlockPos getStartingPosition(IWorld worldIn, BlockPos.Mutable mutable) {
        while (mutable.func_177956_o() > 1) {
            if (worldIn.func_175623_d((BlockPos)mutable)) {
                BlockState state = worldIn.func_180495_p((BlockPos)mutable.func_189536_c(Direction.DOWN));
                mutable.func_189536_c(Direction.UP);
                BlockState blockState = state;
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"state");
                if (Intrinsics.areEqual((Object)blockState.func_177230_c(), (Object)Blocks.field_150353_l) ^ true) {
                    return (BlockPos)mutable;
                }
            }
            mutable.func_189536_c(Direction.DOWN);
        }
        return null;
    }

    private final int getRimSize(Random rand, DeltaFeatureConfig config) {
        return rand.nextInt(config.getMaxRim() + 1);
    }

    private final int getRadius(Random rand, DeltaFeatureConfig config) {
        return config.getMinRadius() + rand.nextInt(config.getMaxRadius() - config.getMinRadius() + 1);
    }

    private final boolean canPlace(IWorld worldAccess, BlockPos blockPos, DeltaFeatureConfig deltaFeatureConfig) {
        boolean bl;
        BlockState state = worldAccess.func_180495_p(blockPos);
        BlockState blockState = state;
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"state");
        if (Intrinsics.areEqual((Object)blockState.func_177230_c(), (Object)deltaFeatureConfig.getContents().func_177230_c())) {
            bl = false;
        } else if (INVALID_BLOCKS.contains(state.func_177230_c())) {
            bl = false;
        } else {
            for (Direction direction : DIRECTIONS) {
                boolean bl2 = worldAccess.func_175623_d(blockPos.func_177972_a(direction));
                if ((!bl2 || direction == Direction.UP) && (bl2 || direction != Direction.UP)) continue;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public DeltaFeature(@NotNull Function1<? super Dynamic<?>, DeltaFeatureConfig> configFactoryIn) {
        Intrinsics.checkNotNullParameter(configFactoryIn, (String)"configFactoryIn");
        Function1<? super Dynamic<?>, DeltaFeatureConfig> function1 = configFactoryIn;
        super((Function)new DeltaFeature$sam$java_util_function_Function$0(function1));
    }

    static {
        Companion = new Companion(null);
        INVALID_BLOCKS = SetsKt.setOf((Object[])new Block[]{Blocks.field_150357_h, Blocks.field_196653_dH, Blocks.field_150386_bk, Blocks.field_150387_bl, Blocks.field_150388_bm, Blocks.field_150486_ae, Blocks.field_150474_ac});
        DIRECTIONS = Direction.values();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lthedarkcolour/futuremc/feature/DeltaFeature$Companion;", "", "()V", "DIRECTIONS", "", "Lnet/minecraft/util/Direction;", "getDIRECTIONS", "()[Lnet/minecraft/util/Direction;", "[Lnet/minecraft/util/Direction;", "INVALID_BLOCKS", "", "Lnet/minecraft/block/Block;", "kotlin.jvm.PlatformType", "getINVALID_BLOCKS", "()Ljava/util/Set;", "futuremc"})
    public static final class Companion {
        @NotNull
        public final Set<Block> getINVALID_BLOCKS() {
            return INVALID_BLOCKS;
        }

        @NotNull
        public final Direction[] getDIRECTIONS() {
            return DIRECTIONS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

