/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.futuremc.feature.HugeFungusFeature;
import thedarkcolour.futuremc.feature.HugeFungusFeature$sam$java_util_function_Function$0;
import thedarkcolour.futuremc.feature.HugeFungusFeatureConfig;
import thedarkcolour.futuremc.feature.WeepingVinesFeature;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0016\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J@\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J8\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J \u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\"\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J:\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010%\u001a\f\u0012\u0006\b\u0001\u0012\u00020'\u0018\u00010&2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J0\u0010(\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\bH\u0002\u00a8\u0006,"}, d2={"Lthedarkcolour/futuremc/feature/HugeFungusFeature;", "Lnet/minecraft/world/gen/feature/Feature;", "Lthedarkcolour/futuremc/feature/HugeFungusFeatureConfig;", "configFactory", "Lkotlin/Function1;", "Lcom/mojang/datafixers/Dynamic;", "(Lkotlin/jvm/functions/Function1;)V", "canReplace", "", "worldIn", "Lnet/minecraft/world/IWorld;", "pos", "Lnet/minecraft/util/math/BlockPos;", "generateHat", "", "world", "random", "Ljava/util/Random;", "config", "hatHeight", "", "thickStem", "generateHatBlock", "rand", "mutable", "decorationChance", "", "generationChance", "vineChance", "generateStem", "stemHeight", "generateVines", "getStartPos", "block", "Lnet/minecraft/block/Block;", "isReplaceable", "place", "generator", "Lnet/minecraft/world/gen/ChunkGenerator;", "Lnet/minecraft/world/gen/GenerationSettings;", "tryGenerateVines", "state", "Lnet/minecraft/block/BlockState;", "isCrimson", "futuremc"})
public final class HugeFungusFeature
extends Feature<HugeFungusFeatureConfig> {
    public boolean place(@NotNull IWorld worldIn, @Nullable ChunkGenerator<? extends GenerationSettings> generator, @NotNull Random rand, @NotNull BlockPos pos, @NotNull HugeFungusFeatureConfig config) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Block block = config.getBase().func_177230_c();
        BlockPos pos2 = null;
        if (config.getPlanted()) {
            BlockState blockState = worldIn.func_180495_p(pos.func_177977_b());
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"worldIn.getBlockState(pos.down())");
            Block block2 = blockState.func_177230_c();
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"worldIn.getBlockState(pos.down()).block");
            Block block22 = block2;
            if (Intrinsics.areEqual((Object)block22, (Object)block)) {
                pos2 = pos;
            }
        } else {
            Block block3 = block;
            Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"block");
            pos2 = this.getStartPos(worldIn, pos, block3);
        }
        if (pos2 == null) {
            bl = false;
        } else {
            int i = MathHelper.func_76136_a((Random)rand, (int)4, (int)13);
            if (rand.nextInt(12) == 0) {
                i *= 2;
            }
            if (!config.getPlanted()) {
                int j;
                Dimension dimension = worldIn.func_201675_m();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"worldIn.dimension");
                int n = j = dimension.func_177495_o() ? 128 : 256;
                if (pos2.func_177956_o() + i + 1 >= j) {
                    return false;
                }
            }
            Block block4 = Blocks.field_150350_a;
            Intrinsics.checkNotNullExpressionValue((Object)block4, (String)"Blocks.AIR");
            worldIn.func_180501_a(pos, block4.func_176223_P(), 4);
            boolean bl2 = !config.getPlanted() && rand.nextFloat() < 0.06f;
            this.generateHat(worldIn, rand, config, pos2, i, bl2);
            this.generateStem(worldIn, rand, config, pos2, i, bl2);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final BlockPos getStartPos(IWorld worldIn, BlockPos pos, Block block) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(pos);
        int n = pos.func_177956_o();
        int n2 = 1;
        while (n >= n2) {
            void i;
            mutable.func_185336_p((int)i);
            BlockState blockState = worldIn.func_180495_p(mutable.func_177977_b());
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"worldIn.getBlockState(mutable.down())");
            Block block2 = blockState.func_177230_c();
            if (Intrinsics.areEqual((Object)block2, (Object)block)) {
                return (BlockPos)mutable;
            }
            --i;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateHat(IWorld world, Random random, HugeFungusFeatureConfig config, BlockPos pos, int hatHeight, boolean thickStem) {
        int n;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        boolean isCrimson = Intrinsics.areEqual((Object)config.getHat().func_177230_c(), (Object)Blocks.field_189878_dg);
        int n2 = random.nextInt(1 + hatHeight / 3) + 5;
        int n3 = 0;
        int i = Math.min(n2, hatHeight);
        int hatBottom = hatHeight - i;
        n3 = hatBottom;
        if (n3 <= (n = hatHeight)) {
            while (true) {
                int n4;
                int n5;
                void y;
                int l;
                int n6 = l = y < hatHeight - random.nextInt(3) ? 2 : 1;
                if (i > 8 && y < hatBottom + 4) {
                    l = 3;
                }
                if (thickStem) {
                    ++l;
                }
                if ((n5 = -l) <= (n4 = l)) {
                    while (true) {
                        void x;
                        int n7;
                        int n8;
                        if ((n8 = -l) <= (n7 = l)) {
                            while (true) {
                                void z;
                                boolean bl2 = x == -l || x == l;
                                boolean bl3 = z == -l || z == l;
                                boolean bl4 = !bl2 && !bl3 && y != hatHeight;
                                boolean bl5 = bl2 && bl3;
                                boolean bl6 = y < hatBottom + 3;
                                mutable.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                                if (this.canReplace(world, (BlockPos)mutable)) {
                                    if (config.getPlanted()) {
                                        BlockState blockState = world.func_180495_p(mutable.func_177977_b());
                                        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"world.getBlockState(mutable.down())");
                                        if (!blockState.func_196958_f()) {
                                            world.func_225521_a_((BlockPos)mutable, true, null);
                                        }
                                    }
                                    if (bl6) {
                                        if (!bl4) {
                                            this.tryGenerateVines(world, random, (BlockPos)mutable, config.getHat(), isCrimson);
                                        }
                                    } else if (bl4) {
                                        this.generateHatBlock(world, random, config, (BlockPos)mutable, 0.1f, 0.2f, isCrimson ? 0.1f : 0.0f);
                                    } else if (bl5) {
                                        this.generateHatBlock(world, random, config, (BlockPos)mutable, 0.01f, 0.7f, isCrimson ? 0.083f : 0.0f);
                                    } else {
                                        this.generateHatBlock(world, random, config, (BlockPos)mutable, 5.0E-4f, 0.98f, isCrimson ? 0.07f : 0.0f);
                                    }
                                }
                                if (z == n7) break;
                                ++z;
                            }
                        }
                        if (x == n4) break;
                        ++x;
                    }
                }
                if (y == n) break;
                ++y;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canReplace(IWorld worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).isAir((IBlockReader)worldIn, pos)) return true;
        IFluidState iFluidState = worldIn.func_204610_c(pos);
        Intrinsics.checkNotNullExpressionValue((Object)iFluidState, (String)"worldIn.getFluidState(pos)");
        if (!iFluidState.func_206888_e()) return true;
        if (!this.isReplaceable(worldIn, pos)) return false;
        return true;
    }

    private final boolean isReplaceable(IWorld worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, (Predicate)isReplaceable.1.INSTANCE);
    }

    private final void tryGenerateVines(IWorld worldIn, Random rand, BlockPos pos, BlockState state, boolean isCrimson) {
        BlockState blockState = worldIn.func_180495_p(pos.func_177977_b());
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"worldIn.getBlockState(pos.down())");
        if (Intrinsics.areEqual((Object)blockState.func_177230_c(), (Object)state.func_177230_c())) {
            this.func_202278_a((IWorldWriter)worldIn, pos, state);
        } else if ((double)rand.nextFloat() < 0.15) {
            this.func_202278_a((IWorldWriter)worldIn, pos, state);
            if (isCrimson && rand.nextInt(11) == 0) {
                this.generateVines(pos, worldIn, rand);
            }
        }
    }

    private final void generateVines(BlockPos pos, IWorld worldIn, Random rand) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(pos).func_189536_c(Direction.DOWN);
        if (worldIn.func_175623_d((BlockPos)mutable)) {
            int length = MathHelper.func_76136_a((Random)rand, (int)1, (int)5);
            if (rand.nextInt(7) == 0) {
                length *= 2;
            }
            BlockPos.Mutable mutable2 = mutable;
            Intrinsics.checkNotNullExpressionValue((Object)mutable2, (String)"mutable");
            WeepingVinesFeature.Companion.placeVine(worldIn, rand, mutable2, length, 23, 25);
        }
    }

    private final void generateHatBlock(IWorld worldIn, Random rand, HugeFungusFeatureConfig config, BlockPos mutable, float decorationChance, float generationChance, float vineChance) {
        if (rand.nextFloat() < decorationChance) {
            this.func_202278_a((IWorldWriter)worldIn, mutable, config.getDecoration());
        } else if (rand.nextFloat() < generationChance) {
            this.func_202278_a((IWorldWriter)worldIn, mutable, config.getHat());
            if (rand.nextFloat() < vineChance) {
                this.generateVines(mutable, worldIn, rand);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateStem(IWorld world, Random random, HugeFungusFeatureConfig config, BlockPos pos, int stemHeight, boolean thickStem) {
        int n;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        BlockState stem = config.getStem();
        int i = Boolean.compare(thickStem, false);
        int n2 = -i;
        if (n2 <= (n = i)) {
            while (true) {
                void j;
                int n3;
                int n4;
                if ((n4 = -i) <= (n3 = i)) {
                    while (true) {
                        void k;
                        boolean bl = thickStem && MathHelper.func_76130_a((int)j) == i && MathHelper.func_76130_a((int)k) == i;
                        int n5 = 0;
                        int n6 = stemHeight;
                        while (n5 < n6) {
                            void l;
                            mutable.func_181079_c(pos.func_177958_n() + j, pos.func_177956_o() + l, pos.func_177952_p() + k);
                            if (this.canReplace(world, (BlockPos)mutable)) {
                                if (config.getPlanted()) {
                                    BlockState blockState = world.func_180495_p(mutable.func_177977_b());
                                    Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"world.getBlockState(mutable.down())");
                                    if (!blockState.func_196958_f()) {
                                        world.func_225521_a_((BlockPos)mutable, true, null);
                                    }
                                    world.func_180501_a((BlockPos)mutable, stem, 3);
                                } else if (bl) {
                                    if (random.nextFloat() < 0.1f) {
                                        this.func_202278_a((IWorldWriter)world, (BlockPos)mutable, stem);
                                    }
                                } else {
                                    this.func_202278_a((IWorldWriter)world, (BlockPos)mutable, stem);
                                }
                            }
                            ++l;
                        }
                        if (k == n3) break;
                        ++k;
                    }
                }
                if (j == n) break;
                ++j;
            }
        }
    }

    public HugeFungusFeature(@NotNull Function1<? super Dynamic<?>, HugeFungusFeatureConfig> configFactory) {
        Intrinsics.checkNotNullParameter(configFactory, (String)"configFactory");
        Function1<? super Dynamic<?>, HugeFungusFeatureConfig> function1 = configFactory;
        super((Function)new HugeFungusFeature$sam$java_util_function_Function$0(function1));
    }
}

