/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.futuremc.feature.BlockPosUtil;
import thedarkcolour.futuremc.feature.NetherrackBlobReplacementConfig;
import thedarkcolour.futuremc.util.UtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\b\u0001\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0002H\u0016\u00a8\u0006\u0018"}, d2={"Lthedarkcolour/futuremc/feature/NetherrackBlobReplacementFeature;", "Lnet/minecraft/world/gen/feature/Feature;", "Lthedarkcolour/futuremc/feature/NetherrackBlobReplacementConfig;", "configFactory", "Ljava/util/function/Function;", "Lcom/mojang/datafixers/Dynamic;", "(Ljava/util/function/Function;)V", "findTargetBlock", "Lnet/minecraft/util/math/BlockPos;", "worldIn", "Lnet/minecraft/world/IWorld;", "mutable", "Lnet/minecraft/util/math/BlockPos$Mutable;", "block", "Lnet/minecraft/block/Block;", "place", "", "generator", "Lnet/minecraft/world/gen/ChunkGenerator;", "Lnet/minecraft/world/gen/GenerationSettings;", "rand", "Ljava/util/Random;", "pos", "config", "futuremc"})
public final class NetherrackBlobReplacementFeature
extends Feature<NetherrackBlobReplacementConfig> {
    public boolean place(@NotNull IWorld worldIn, @NotNull ChunkGenerator<? extends GenerationSettings> generator, @NotNull Random rand, @NotNull BlockPos pos, @NotNull NetherrackBlobReplacementConfig config) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter(generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Block block = config.getTarget().func_177230_c();
        BlockPos.Mutable mutable = UtilKt.clampAxis(new BlockPos.Mutable(pos), Direction.Axis.Y, 1, generator.func_207511_e() - 1);
        Block block2 = block;
        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"block");
        BlockPos pos1 = this.findTargetBlock(worldIn, mutable, block2);
        if (pos1 == null) {
            return false;
        }
        int i = config.getRandomSpread(rand);
        boolean f = false;
        for (BlockPos p : BlockPosUtil.iterateOutwards(pos1, i, i, i)) {
            BlockState state;
            if (p.func_218139_n((Vec3i)pos1) > i) break;
            BlockState blockState = state = worldIn.func_180495_p(p);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"state");
            if (!Intrinsics.areEqual((Object)blockState.func_177230_c(), (Object)block)) continue;
            this.func_202278_a((IWorldWriter)worldIn, p, config.getState());
            f = true;
        }
        return f;
    }

    private final BlockPos findTargetBlock(IWorld worldIn, BlockPos.Mutable mutable, Block block) {
        while (mutable.func_177956_o() > 1) {
            BlockState state;
            BlockState blockState = state = worldIn.func_180495_p((BlockPos)mutable);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"state");
            if (Intrinsics.areEqual((Object)blockState.func_177230_c(), (Object)block)) {
                return (BlockPos)mutable;
            }
            mutable.func_189536_c(Direction.DOWN);
        }
        return null;
    }

    public NetherrackBlobReplacementFeature(@NotNull Function<Dynamic<?>, ? extends NetherrackBlobReplacementConfig> configFactory) {
        Intrinsics.checkNotNullParameter(configFactory, (String)"configFactory");
        super(configFactory);
    }
}

