/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.futuremc.recipe.DarkRecipe;
import thedarkcolour.futuremc.recipe.DarkRecipeType;
import thedarkcolour.futuremc.registry.FRecipes;
import thedarkcolour.futuremc.util.DarkInventory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\f\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\f\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020#2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lthedarkcolour/futuremc/recipe/SmithingRecipe;", "Lthedarkcolour/futuremc/recipe/DarkRecipe;", "id", "Lnet/minecraft/util/ResourceLocation;", "ingredient", "Lnet/minecraft/item/crafting/Ingredient;", "material", "materialCost", "", "result", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/crafting/Ingredient;Lnet/minecraft/item/crafting/Ingredient;ILnet/minecraft/item/ItemStack;)V", "getIngredient", "()Lnet/minecraft/item/crafting/Ingredient;", "getMaterial", "getMaterialCost", "()I", "getResult", "()Lnet/minecraft/item/ItemStack;", "canFit", "", "width", "height", "getCraftingResult", "inv", "Lnet/minecraft/inventory/IInventory;", "getId", "getRecipeOutput", "getSerializer", "Lnet/minecraft/item/crafting/IRecipeSerializer;", "getType", "Lthedarkcolour/futuremc/recipe/DarkRecipeType;", "matches", "worldIn", "Lnet/minecraft/world/World;", "Lthedarkcolour/futuremc/util/DarkInventory;", "Serializer", "futuremc"})
public final class SmithingRecipe
implements DarkRecipe {
    private final ResourceLocation id;
    @NotNull
    private final Ingredient ingredient;
    @NotNull
    private final Ingredient material;
    private final int materialCost;
    @NotNull
    private final ItemStack result;

    @Override
    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @NotNull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    @NotNull
    public DarkRecipeType<?> getType() {
        return FRecipes.INSTANCE.getSMITHING();
    }

    @NotNull
    public ItemStack func_77571_b() {
        return this.result;
    }

    @NotNull
    public IRecipeSerializer<?> func_199559_b() {
        return FRecipes.INSTANCE.getSMITHING_SERIALIZER();
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull IInventory inv) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        ItemStack itemStack = this.result.func_77946_l();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"result.copy()");
        return itemStack;
    }

    public boolean func_77569_a(@NotNull IInventory inv, @NotNull World worldIn) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        boolean a = this.ingredient.test(inv.func_70301_a(0));
        boolean b = this.material.test(inv.func_70301_a(1));
        ItemStack itemStack = inv.func_70301_a(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"inv.getStackFrom(1)");
        boolean c = itemStack.func_190916_E() >= this.materialCost;
        return a && b && c;
    }

    @Override
    public boolean matches(@NotNull DarkInventory inv, @NotNull World worldIn) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        boolean a = this.ingredient.test(inv.get(0));
        boolean b = this.material.test(inv.get(1));
        boolean c = inv.get(1).func_190916_E() >= this.materialCost;
        return a && b && c;
    }

    @NotNull
    public final Ingredient getIngredient() {
        return this.ingredient;
    }

    @NotNull
    public final Ingredient getMaterial() {
        return this.material;
    }

    public final int getMaterialCost() {
        return this.materialCost;
    }

    @NotNull
    public final ItemStack getResult() {
        return this.result;
    }

    public SmithingRecipe(@NotNull ResourceLocation id, @NotNull Ingredient ingredient, @NotNull Ingredient material, int materialCost, @NotNull ItemStack result) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.id = id;
        this.ingredient = ingredient;
        this.material = material;
        this.materialCost = materialCost;
        this.result = result;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lthedarkcolour/futuremc/recipe/SmithingRecipe$Serializer;", "Lnet/minecraftforge/registries/ForgeRegistryEntry;", "Lnet/minecraft/item/crafting/IRecipeSerializer;", "Lthedarkcolour/futuremc/recipe/SmithingRecipe;", "()V", "read", "recipeId", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "futuremc"})
    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SmithingRecipe> {
        @NotNull
        public SmithingRecipe read(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            ItemStack itemStack;
            Intrinsics.checkNotNullParameter((Object)recipeId, (String)"recipeId");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JsonElement jsonElement = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? (JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"input") : (JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input");
            if (jsonElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.google.gson.JsonElement");
            }
            JsonElement element = jsonElement;
            Ingredient input2 = Ingredient.func_199802_a((JsonElement)element);
            JsonElement jsonElement2 = JSONUtils.func_151202_d((JsonObject)json, (String)"material") ? (JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"material") : (JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"material");
            if (jsonElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.google.gson.JsonElement");
            }
            JsonElement element1 = jsonElement2;
            Ingredient material = Ingredient.func_199802_a((JsonElement)element1);
            int materialCost = JSONUtils.func_151208_a((JsonObject)json, (String)"material_cost", (int)1);
            if (!json.has("result")) {
                throw (Throwable)new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            JsonElement jsonElement3 = json.get("result");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"json.get(\"result\")");
            if (jsonElement3.isJsonObject()) {
                itemStack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            } else {
                String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
                ResourceLocation location = new ResourceLocation(s1);
                IForgeRegistryEntry iForgeRegistryEntry = ForgeRegistries.ITEMS.getValue(location);
                Intrinsics.checkNotNull((Object)iForgeRegistryEntry);
                itemStack = new ItemStack((IItemProvider)iForgeRegistryEntry);
            }
            ItemStack result = itemStack;
            Ingredient ingredient = input2;
            Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"input");
            Ingredient ingredient2 = material;
            Intrinsics.checkNotNullExpressionValue((Object)ingredient2, (String)"material");
            ItemStack itemStack2 = result;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"result");
            return new SmithingRecipe(recipeId, ingredient, ingredient2, materialCost, itemStack2);
        }

        @Nullable
        public SmithingRecipe read(@NotNull ResourceLocation recipeId, @NotNull PacketBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)recipeId, (String)"recipeId");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Ingredient input2 = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient material = Ingredient.func_199566_b((PacketBuffer)buffer);
            int materialCost = buffer.readInt();
            ItemStack result = buffer.func_150791_c();
            Ingredient ingredient = input2;
            Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"input");
            Ingredient ingredient2 = material;
            Intrinsics.checkNotNullExpressionValue((Object)ingredient2, (String)"material");
            ItemStack itemStack = result;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"result");
            return new SmithingRecipe(recipeId, ingredient, ingredient2, materialCost, itemStack);
        }

        public void write(@NotNull PacketBuffer buffer, @NotNull SmithingRecipe recipe) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            recipe.getIngredient().func_199564_a(buffer);
            recipe.getMaterial().func_199564_a(buffer);
            buffer.writeInt(recipe.getMaterialCost());
            buffer.func_150788_a(recipe.getResult());
        }
    }
}

