/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.biome.BasaltDeltasBiome;
import thedarkcolour.futuremc.biome.BiomeEffects;
import thedarkcolour.futuremc.biome.CrimsonForestBiome;
import thedarkcolour.futuremc.biome.SoulSandValleyBiome;
import thedarkcolour.futuremc.biome.WarpedForestBiome;
import thedarkcolour.futuremc.biome.provider.NoisePoint;
import thedarkcolour.futuremc.compat.CompatKt;
import thedarkcolour.futuremc.compat.biomesoplenty.BiomesOPlentyCompat;
import thedarkcolour.futuremc.config.Config;
import thedarkcolour.futuremc.registry.ExtensionsKt;
import thedarkcolour.futuremc.registry.FBiomes;
import thedarkcolour.futuremc.registry.FBlocks;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0016H\u0007J)\u0010!\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0#\"\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001f\u001a\u00020\u0015H\u0007J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0'2\u0006\u0010\u001f\u001a\u00020\u0015H\u0007J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u0015H\u0007J\u0014\u0010*\u001a\u00020\u001c2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150,J\u0016\u0010-\u001a\u00020\u001c2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150,H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0018\u001a*\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0014j\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lthedarkcolour/futuremc/registry/FBiomes;", "", "()V", "BASALT_DELTAS", "Lthedarkcolour/futuremc/biome/BasaltDeltasBiome;", "getBASALT_DELTAS", "()Lthedarkcolour/futuremc/biome/BasaltDeltasBiome;", "CRIMSON_FOREST", "Lthedarkcolour/futuremc/biome/CrimsonForestBiome;", "getCRIMSON_FOREST", "()Lthedarkcolour/futuremc/biome/CrimsonForestBiome;", "SOUL_SAND_VALLEY", "Lthedarkcolour/futuremc/biome/SoulSandValleyBiome;", "getSOUL_SAND_VALLEY", "()Lthedarkcolour/futuremc/biome/SoulSandValleyBiome;", "WARPED_FOREST", "Lthedarkcolour/futuremc/biome/WarpedForestBiome;", "getWARPED_FOREST", "()Lthedarkcolour/futuremc/biome/WarpedForestBiome;", "biomeParticles", "Ljava/util/HashMap;", "Lnet/minecraft/world/biome/Biome;", "Lthedarkcolour/futuremc/biome/BiomeEffects;", "Lkotlin/collections/HashMap;", "noisePoints", "Ljava/util/ArrayList;", "Lthedarkcolour/futuremc/biome/provider/NoisePoint;", "addBiomeNoise", "", "addBiomeParticles", "addEffects", "biome", "effects", "addNoisePoints", "points", "", "(Lnet/minecraft/world/biome/Biome;[Lthedarkcolour/futuremc/biome/provider/NoisePoint;)Lnet/minecraft/world/biome/Biome;", "getBiomeEffects", "getNoisePoints", "", "hasBiomeEffects", "", "onBiomeRegistry", "biomes", "Lnet/minecraftforge/registries/IForgeRegistry;", "registerBiomes", "futuremc"})
public final class FBiomes {
    @NotNull
    private static final WarpedForestBiome WARPED_FOREST;
    @NotNull
    private static final CrimsonForestBiome CRIMSON_FOREST;
    @NotNull
    private static final SoulSandValleyBiome SOUL_SAND_VALLEY;
    @NotNull
    private static final BasaltDeltasBiome BASALT_DELTAS;
    private static final HashMap<Biome, BiomeEffects> biomeParticles;
    private static final HashMap<Biome, ArrayList<NoisePoint>> noisePoints;
    public static final FBiomes INSTANCE;

    @NotNull
    public final WarpedForestBiome getWARPED_FOREST() {
        return WARPED_FOREST;
    }

    @NotNull
    public final CrimsonForestBiome getCRIMSON_FOREST() {
        return CRIMSON_FOREST;
    }

    @NotNull
    public final SoulSandValleyBiome getSOUL_SAND_VALLEY() {
        return SOUL_SAND_VALLEY;
    }

    @NotNull
    public final BasaltDeltasBiome getBASALT_DELTAS() {
        return BASALT_DELTAS;
    }

    public final void onBiomeRegistry(@NotNull IForgeRegistry<Biome> biomes) {
        Intrinsics.checkNotNullParameter(biomes, (String)"biomes");
        if (Config.INSTANCE.getAncientDebrisGenerates().getValue().booleanValue()) {
            Biomes.field_76778_j.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, FBlocks.INSTANCE.getANCIENT_DEBRIS().func_176223_P(), 3)).func_227228_a_(Placement.field_215035_u.func_227446_a_((IPlacementConfig)new DepthAverageConfig(1, 16, 8))));
            Biomes.field_76778_j.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, FBlocks.INSTANCE.getANCIENT_DEBRIS().func_176223_P(), 2)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 8, 16, 128))));
        }
        if (FutureMC.INSTANCE.getDEBUG()) {
            this.registerBiomes(biomes);
            this.addBiomeNoise();
            this.addBiomeParticles();
        }
    }

    private final void registerBiomes(IForgeRegistry<Biome> biomes) {
        block7: {
            if (Config.INSTANCE.getWarpedForest().getValue().booleanValue()) {
                biomes.register((IForgeRegistryEntry)WARPED_FOREST);
                BiomesOPlentyCompat biomesOPlentyCompat = CompatKt.checkBiomesOPlenty();
                if (biomesOPlentyCompat != null) {
                    biomesOPlentyCompat.addNetherBiome(WARPED_FOREST);
                }
            }
            if (Config.INSTANCE.getCrimsonForest().getValue().booleanValue()) {
                biomes.register((IForgeRegistryEntry)CRIMSON_FOREST);
                BiomesOPlentyCompat biomesOPlentyCompat = CompatKt.checkBiomesOPlenty();
                if (biomesOPlentyCompat != null) {
                    biomesOPlentyCompat.addNetherBiome(CRIMSON_FOREST);
                }
            }
            if (Config.INSTANCE.getSoulSandValley().getValue().booleanValue()) {
                biomes.register((IForgeRegistryEntry)SOUL_SAND_VALLEY);
                BiomesOPlentyCompat biomesOPlentyCompat = CompatKt.checkBiomesOPlenty();
                if (biomesOPlentyCompat != null) {
                    biomesOPlentyCompat.addNetherBiome(SOUL_SAND_VALLEY);
                }
            }
            if (!FutureMC.INSTANCE.getDEBUG()) break block7;
            biomes.register((IForgeRegistryEntry)BASALT_DELTAS);
            BiomesOPlentyCompat biomesOPlentyCompat = CompatKt.checkBiomesOPlenty();
            if (biomesOPlentyCompat != null) {
                biomesOPlentyCompat.addNetherBiome(BASALT_DELTAS);
            }
        }
    }

    private final void addBiomeNoise() {
        FBiomes.addNoisePoints(WARPED_FOREST, new NoisePoint(0.0f, 0.5f, 0.0f, 0.0f, 1.0f));
        FBiomes.addNoisePoints(CRIMSON_FOREST, new NoisePoint(0.0f, -0.5f, 0.0f, 0.0f, 1.0f));
        FBiomes.addNoisePoints(SOUL_SAND_VALLEY, new NoisePoint(0.0f, 0.0f, 0.0f, 0.5f, 1.0f));
        FBiomes.addNoisePoints(BASALT_DELTAS, new NoisePoint(-0.7f, 0.0f, 0.0f, 0.0f, 0.3f));
        Biome biome = Biomes.field_76778_j;
        Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"Biomes.NETHER");
        FBiomes.addNoisePoints(biome, new NoisePoint(0.0f, 0.0f, 0.0f, -0.5f, 1.0f));
    }

    private final void addBiomeParticles() {
        FBiomes.addEffects(WARPED_FOREST, BiomeEffects.Companion.make((Function1<? super BiomeEffects.Builder, Unit>)((Function1)addBiomeParticles.1.INSTANCE)));
        FBiomes.addEffects(CRIMSON_FOREST, BiomeEffects.Companion.make((Function1<? super BiomeEffects.Builder, Unit>)((Function1)addBiomeParticles.2.INSTANCE)));
        FBiomes.addEffects(SOUL_SAND_VALLEY, BiomeEffects.Companion.make((Function1<? super BiomeEffects.Builder, Unit>)((Function1)addBiomeParticles.3.INSTANCE)));
        FBiomes.addEffects(BASALT_DELTAS, BiomeEffects.Companion.make((Function1<? super BiomeEffects.Builder, Unit>)((Function1)addBiomeParticles.4.INSTANCE)));
        Biome biome = Biomes.field_76778_j;
        Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"Biomes.NETHER");
        FBiomes.addEffects(biome, BiomeEffects.Companion.getNETHER());
    }

    @JvmStatic
    @Nullable
    public static final BiomeEffects getBiomeEffects(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        return biomeParticles.get(biome);
    }

    @JvmStatic
    public static final boolean hasBiomeEffects(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        Map map = biomeParticles;
        boolean bl = false;
        Map map2 = map;
        boolean bl2 = false;
        return map2.containsKey(biome);
    }

    @JvmStatic
    @NotNull
    public static final List<NoisePoint> getNoisePoints(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        ArrayList<NoisePoint> arrayList = noisePoints.get(biome);
        return arrayList != null ? (List)arrayList : CollectionsKt.emptyList();
    }

    @JvmStatic
    @NotNull
    public static final Biome addNoisePoints(@NotNull Biome biome, NoisePoint ... points) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Map $this$getOrPut$iv = noisePoints;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(biome);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            ArrayList answer$iv = new ArrayList();
            $this$getOrPut$iv.put(biome, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        CollectionsKt.addAll((Collection)((Collection)object), (Object[])points);
        return biome;
    }

    @JvmStatic
    public static final void addEffects(@NotNull Biome biome, @NotNull BiomeEffects effects) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        Intrinsics.checkNotNullParameter((Object)effects, (String)"effects");
        ((Map)biomeParticles).put(biome, effects);
    }

    private FBiomes() {
    }

    static {
        FBiomes fBiomes;
        INSTANCE = fBiomes = new FBiomes();
        WARPED_FOREST = (WarpedForestBiome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)new WarpedForestBiome(), "warped_forest");
        CRIMSON_FOREST = (CrimsonForestBiome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)new CrimsonForestBiome(), "crimson_forest");
        SOUL_SAND_VALLEY = (SoulSandValleyBiome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)new SoulSandValleyBiome(), "soul_sand_valley");
        BASALT_DELTAS = (BasaltDeltasBiome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)new BasaltDeltasBiome(), "basalt_deltas");
        boolean bl = false;
        biomeParticles = new HashMap();
        bl = false;
        noisePoints = new HashMap();
    }
}

