/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.util;

import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.futuremc.util.StringTextComponentMutable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010(\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u00020\u00050\u0004B\u0019\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J \u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0016H\u0016J\u0011\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0007H\u0086\u0002J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010#\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J \u0010%\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0016H\u0016J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0005H\u0016J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050)H\u0096\u0002J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J \u0010+\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0005H\u0016J\b\u0010,\u001a\u00020\u0003H\u0016J\u0019\u0010-\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010.\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010/\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0005H\u0016R\u000e\u0010\b\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00060"}, d2={"Lthedarkcolour/futuremc/util/DarkInventory;", "Lnet/minecraftforge/items/IItemHandlerModifiable;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/CompoundNBT;", "", "Lnet/minecraft/item/ItemStack;", "size", "", "defaultName", "", "(ILjava/lang/String;)V", "Lnet/minecraft/util/text/TranslationTextComponent;", "displayName", "Lthedarkcolour/futuremc/util/StringTextComponentMutable;", "stacks", "", "[Lnet/minecraft/item/ItemStack;", "vanillaInventory", "Lnet/minecraft/inventory/Inventory;", "getVanillaInventory", "()Lnet/minecraft/inventory/Inventory;", "canTakeStack", "", "slot", "playerIn", "Lnet/minecraft/entity/player/PlayerEntity;", "deserializeNBT", "", "tag", "extractItem", "amount", "simulate", "get", "index", "getSlotLimit", "getSlots", "getStackInSlot", "insertItem", "stack", "isItemValid", "iterator", "", "onContentsChanged", "onTake", "serializeNBT", "set", "setSize", "setStackInSlot", "futuremc"})
public class DarkInventory
implements IItemHandlerModifiable,
INBTSerializable<CompoundNBT>,
Iterable<ItemStack>,
KMappedMarker {
    private ItemStack[] stacks;
    private final TranslationTextComponent defaultName;
    private final StringTextComponentMutable displayName;

    private final void setSize(int size) {
        if (size == this.stacks.length) {
            Arrays.fill(this.stacks, ItemStack.field_190927_a);
        } else {
            ItemStack[] itemStackArray;
            DarkInventory darkInventory = this;
            ItemStack[] itemStackArray2 = new ItemStack[size];
            int n = 0;
            while (n < size) {
                ItemStack itemStack;
                int n2 = n;
                int n3 = n++;
                itemStackArray = itemStackArray2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)ItemStack.field_190927_a, (String)"ItemStack.EMPTY");
                itemStackArray[n3] = itemStack;
            }
            itemStackArray = itemStackArray2;
            darkInventory.stacks = itemStackArray;
        }
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.stacks[slot] = stack;
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.stacks.length;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.stacks[slot];
    }

    @NotNull
    public final ItemStack get(int index) {
        return this.stacks[index];
    }

    public final void set(int index, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.stacks[index] = stack;
        this.onContentsChanged(index);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack itemStack;
        boolean reachedLimit;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.func_190926_b() || !this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack existing = this.stacks[slot];
        int limit = this.getSlotLimit(slot);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                Intrinsics.checkNotNullExpressionValue((Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack), (String)"if (reachedLimit) ItemHa\u2026(stack, limit) else stack");
                this.stacks[slot] = this.stacks[slot];
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        if (reachedLimit) {
            ItemStack itemStack2 = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit));
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"ItemHandlerHelper.copySt\u2026ack, stack.count - limit)");
        } else {
            ItemStack itemStack3 = ItemStack.field_190927_a;
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"ItemStack.EMPTY");
        }
        return itemStack;
    }

    public boolean canTakeStack(int slot, @NotNull PlayerEntity playerIn) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        return true;
    }

    @NotNull
    public ItemStack onTake(int slot, @NotNull PlayerEntity playerIn, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack itemStack;
        if (amount == 0) {
            ItemStack itemStack2 = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"ItemStack.EMPTY");
            return itemStack2;
        }
        ItemStack existing = this.stacks[slot];
        if (existing.func_190926_b()) {
            ItemStack itemStack3 = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"ItemStack.EMPTY");
            return itemStack3;
        }
        int toExtract = RangesKt.coerceAtMost((int)amount, (int)existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                Intrinsics.checkNotNullExpressionValue((Object)ItemStack.field_190927_a, (String)"ItemStack.EMPTY");
                this.onContentsChanged(slot);
            }
            itemStack = existing;
        } else {
            if (!simulate) {
                Intrinsics.checkNotNullExpressionValue((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)), (String)"ItemHandlerHelper.copySt\u2026isting.count - toExtract)");
                this.onContentsChanged(slot);
            }
            ItemStack itemStack4 = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
            itemStack = itemStack4;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"ItemHandlerHelper.copySt\u2026Size(existing, toExtract)");
        }
        return itemStack;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        int n = 0;
        int n2 = this.stacks.length;
        while (n < n2) {
            void i;
            if (!this.stacks[i].func_190926_b()) {
                CompoundNBT itemTag = new CompoundNBT();
                itemTag.func_74768_a("Slot", (int)i);
                this.stacks[i].func_77955_b(itemTag);
                nbtTagList.add((Object)itemTag);
            }
            ++i;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.length);
        return nbt;
    }

    /*
     * WARNING - void declaration
     */
    public void deserializeNBT(@NotNull CompoundNBT tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.setSize(tag.func_150297_b("Size", 3) ? tag.func_74762_e("Size") : this.stacks.length);
        ListNBT tagList = tag.func_150295_c("Items", 10);
        int n = 0;
        int n2 = tagList.size();
        while (n < n2) {
            void i;
            CompoundNBT itemTags = tagList.func_150305_b((int)i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot >= 0 && slot < this.stacks.length) {
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)itemTags);
                Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            }
            ++i;
        }
    }

    @Override
    @NotNull
    public Iterator<ItemStack> iterator() {
        return ArrayIteratorKt.iterator((Object[])this.stacks);
    }

    public void onContentsChanged(int slot) {
    }

    @NotNull
    public final Inventory getVanillaInventory() {
        return new Inventory(Arrays.copyOf(this.stacks, this.stacks.length));
    }

    public DarkInventory(int size, @Nullable String defaultName) {
        ItemStack[] itemStackArray;
        DarkInventory darkInventory = this;
        ItemStack[] itemStackArray2 = new ItemStack[size];
        int n = 0;
        while (n < size) {
            ItemStack itemStack;
            int n2 = n;
            int n3 = n++;
            itemStackArray = itemStackArray2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)ItemStack.field_190927_a, (String)"ItemStack.EMPTY");
            itemStackArray[n3] = itemStack;
        }
        itemStackArray = itemStackArray2;
        darkInventory.stacks = itemStackArray;
        String string = defaultName;
        if (string == null) {
            string = "";
        }
        this.defaultName = new TranslationTextComponent(string, new Object[0]);
    }

    public /* synthetic */ DarkInventory(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        this(n, string);
    }
}

