/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.sync;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CancelHandlerBase;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CancellableContinuationKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.internal.ConcurrentLinkedListKt;
import kotlinx.coroutines.internal.ConcurrentLinkedListNode;
import kotlinx.coroutines.internal.Segment;
import kotlinx.coroutines.internal.SegmentOrClosed;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.sync.CancelSemaphoreAcquisitionHandler;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import kotlinx.coroutines.sync.SemaphoreSegment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\b\u0002\u0018\u00002\u00020\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0007\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\t\u001a\u00020\u0006H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\t\u0010\bJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012R\u0016\u0010\u0016\u001a\u00020\u00018V@\u0016X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0002\u001a\u00020\u00018\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u0017\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lkotlinx/coroutines/sync/SemaphoreImpl;", "", "permits", "acquiredPermits", "<init>", "(II)V", "", "acquire", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "acquireSlowPath", "Lkotlinx/coroutines/CancellableContinuation;", "cont", "", "addAcquireToQueue", "(Lkotlinx/coroutines/CancellableContinuation;)Z", "release", "()V", "tryAcquire", "()Z", "tryResumeNextFromQueue", "getAvailablePermits", "()I", "availablePermits", "I", "kotlinx-coroutines-core", "Lkotlinx/coroutines/sync/Semaphore;"})
final class SemaphoreImpl
implements Semaphore {
    private volatile Object head;
    private static final AtomicReferenceFieldUpdater head$FU = AtomicReferenceFieldUpdater.newUpdater(SemaphoreImpl.class, Object.class, "head");
    private volatile long deqIdx;
    private static final AtomicLongFieldUpdater deqIdx$FU = AtomicLongFieldUpdater.newUpdater(SemaphoreImpl.class, "deqIdx");
    private volatile Object tail;
    private static final AtomicReferenceFieldUpdater tail$FU = AtomicReferenceFieldUpdater.newUpdater(SemaphoreImpl.class, Object.class, "tail");
    private volatile long enqIdx;
    private static final AtomicLongFieldUpdater enqIdx$FU = AtomicLongFieldUpdater.newUpdater(SemaphoreImpl.class, "enqIdx");
    volatile int _availablePermits;
    static final AtomicIntegerFieldUpdater _availablePermits$FU = AtomicIntegerFieldUpdater.newUpdater(SemaphoreImpl.class, "_availablePermits");
    private final int permits;

    @Override
    public int getAvailablePermits() {
        int n = this._availablePermits;
        int n2 = 0;
        boolean bl = false;
        return Math.max(n, n2);
    }

    @Override
    public boolean tryAcquire() {
        int p;
        SemaphoreImpl $this$loop$iv = this;
        boolean $i$f$loop = false;
        do {
            p = $this$loop$iv._availablePermits;
            boolean bl = false;
            if (p > 0) continue;
            return false;
        } while (!_availablePermits$FU.compareAndSet(this, p, p - 1));
        return true;
    }

    @Override
    @Nullable
    public Object acquire(@NotNull Continuation<? super Unit> $completion) {
        int p = _availablePermits$FU.getAndDecrement(this);
        if (p > 0) {
            return Unit.INSTANCE;
        }
        Object object = this.acquireSlowPath($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    final /* synthetic */ Object acquireSlowPath(@NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$suspendAtomicCancellableCoroutineReusable = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl<? super Unit> cancellable$iv = CancellableContinuationKt.getOrCreateCancellableContinuation(IntrinsicsKt.intercepted(uCont$iv));
        CancellableContinuation cont = cancellable$iv;
        boolean bl2 = false;
        while (!this.addAcquireToQueue(cont)) {
            int p = _availablePermits$FU.getAndDecrement(this);
            if (p <= 0) continue;
            Continuation continuation = cont;
            Unit unit = Unit.INSTANCE;
            boolean bl3 = false;
            Result.Companion companion = Result.Companion;
            Continuation continuation2 = continuation;
            boolean bl4 = false;
            Object object = Result.constructor-impl(unit);
            continuation2.resumeWith(object);
            break;
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Override
    public void release() {
        do {
            int cur;
            int upd$iv;
            int cur$iv;
            SemaphoreImpl $this$getAndUpdate$iv = this;
            boolean $i$f$getAndUpdate = false;
            do {
                cur = cur$iv = $this$getAndUpdate$iv._availablePermits;
                boolean bl = false;
                boolean bl2 = cur < this.permits;
                boolean bl3 = false;
                boolean bl4 = false;
                if (bl2) continue;
                boolean bl5 = false;
                String string = "The number of released permits cannot be greater than " + this.permits;
                throw (Throwable)new IllegalStateException(string.toString());
            } while (!_availablePermits$FU.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = cur + 1));
            int p = cur$iv;
            if (p < 0) continue;
            return;
        } while (!this.tryResumeNextFromQueue());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addAcquireToQueue(CancellableContinuation<? super Unit> cont) {
        SemaphoreSegment $this$asHandler$iv;
        CancelHandlerBase this_$iv;
        Object s$iv;
        boolean bl;
        SemaphoreSegment curTail = (SemaphoreSegment)this.tail;
        long enqIdx = enqIdx$FU.getAndIncrement(this);
        SemaphoreImpl semaphoreImpl = this;
        long id$iv22 = enqIdx / (long)SemaphoreKt.access$getSEGMENT_SIZE$p();
        boolean $i$f$findSegmentAndMoveForward = false;
        block0: do {
            void $this$moveForward$iv$iv;
            void $this$findSegmentAndMoveForward$iv;
            Segment $this$findSegmentInternal$iv$iv;
            block14: {
                Object object;
                $this$findSegmentInternal$iv$iv = curTail;
                boolean $i$f$findSegmentInternal = false;
                Segment cur$iv$iv = $this$findSegmentInternal$iv$iv;
                while (cur$iv$iv.getId() < id$iv22 || cur$iv$iv.getRemoved()) {
                    void p2;
                    ConcurrentLinkedListNode this_$iv$iv$iv = cur$iv$iv;
                    boolean $i$f$nextOrIfClosed = false;
                    Object object2 = ConcurrentLinkedListNode.access$getNextOrClosed$p(this_$iv$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object it$iv$iv$iv = object2;
                    boolean bl4 = false;
                    if (it$iv$iv$iv == ConcurrentLinkedListKt.access$getCLOSED$p()) {
                        boolean bl5 = false;
                        object = SegmentOrClosed.constructor-impl(ConcurrentLinkedListKt.access$getCLOSED$p());
                        break block14;
                    }
                    Segment next$iv$iv = (Segment)((ConcurrentLinkedListNode)it$iv$iv$iv);
                    if (next$iv$iv != null) {
                        cur$iv$iv = next$iv$iv;
                        continue;
                    }
                    SemaphoreSegment semaphoreSegment = (SemaphoreSegment)cur$iv$iv;
                    long p1 = cur$iv$iv.getId() + 1L;
                    boolean bl6 = false;
                    Segment newTail$iv$iv = SemaphoreKt.access$createSegment(p1, (SemaphoreSegment)p2);
                    if (!cur$iv$iv.trySetNext((ConcurrentLinkedListNode)newTail$iv$iv)) continue;
                    if (cur$iv$iv.getRemoved()) {
                        cur$iv$iv.remove();
                    }
                    cur$iv$iv = newTail$iv$iv;
                }
                object = s$iv = SegmentOrClosed.constructor-impl(cur$iv$iv);
            }
            if (SegmentOrClosed.isClosed-impl(s$iv)) break;
            $this$findSegmentInternal$iv$iv = $this$findSegmentAndMoveForward$iv;
            Object to$iv$iv = SegmentOrClosed.getSegment-impl(s$iv);
            boolean $i$f$moveForward = false;
            void $this$loop$iv$iv$iv = $this$moveForward$iv$iv;
            boolean $i$f$loop = false;
            while (true) {
                Segment cur$iv$iv = (Segment)$this$loop$iv$iv$iv.tail;
                boolean bl7 = false;
                if (cur$iv$iv.getId() >= ((Segment)to$iv$iv).getId()) {
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).tryIncPointers$kotlinx_coroutines_core()) {
                    bl = false;
                    continue block0;
                }
                if (tail$FU.compareAndSet($this$moveForward$iv$iv, cur$iv$iv, to$iv$iv)) {
                    if (cur$iv$iv.decPointers$kotlinx_coroutines_core()) {
                        cur$iv$iv.remove();
                    }
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).decPointers$kotlinx_coroutines_core()) continue;
                ((ConcurrentLinkedListNode)to$iv$iv).remove();
            }
        } while (!bl);
        SemaphoreSegment segment = (SemaphoreSegment)SegmentOrClosed.getSegment-impl(s$iv);
        int i = (int)(enqIdx % (long)SemaphoreKt.access$getSEGMENT_SIZE$p());
        SemaphoreSegment id$iv22 = segment;
        Unit expected$iv = null;
        boolean $i$f$cas = false;
        if (((SemaphoreSegment)((Object)this_$iv)).acquirers.compareAndSet(i, expected$iv, cont)) {
            this_$iv = new CancelSemaphoreAcquisitionHandler(segment, i);
            CancellableContinuation<? super Unit> cancellableContinuation = cont;
            boolean $i$f$getAsHandler = false;
            Function1 function1 = (Function1)((Object)$this$asHandler$iv);
            cancellableContinuation.invokeOnCancellation(function1);
            return true;
        }
        $this$asHandler$iv = segment;
        Symbol $i$f$getAsHandler = SemaphoreKt.access$getPERMIT$p();
        Object value$iv2 = SemaphoreKt.access$getTAKEN$p();
        boolean $i$f$cas22 = false;
        if (((SemaphoreSegment)((Object)this_$iv)).acquirers.compareAndSet(i, expected$iv, value$iv2)) {
            Continuation continuation = cont;
            expected$iv = Unit.INSTANCE;
            boolean value$iv2 = false;
            Result.Companion $i$f$cas22 = Result.Companion;
            Continuation to$iv$iv = continuation;
            boolean bl8 = false;
            Object object = Result.constructor-impl(expected$iv);
            to$iv$iv.resumeWith(object);
            return true;
        }
        boolean bl9 = false;
        if (DebugKt.getASSERTIONS_ENABLED()) {
            void this_$iv2;
            boolean bl10 = false;
            value$iv2 = segment;
            int index$iv = i;
            boolean $i$f$get = false;
            if (!(this_$iv2.acquirers.get(index$iv) == SemaphoreKt.access$getBROKEN$p())) {
                throw (Throwable)((Object)new AssertionError());
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryResumeNextFromQueue() {
        void this_$iv222;
        SemaphoreSegment $this$moveForward$iv$iv;
        Object s$iv;
        boolean bl;
        SemaphoreSegment curHead = (SemaphoreSegment)this.head;
        long deqIdx = deqIdx$FU.getAndIncrement(this);
        long id = deqIdx / (long)SemaphoreKt.access$getSEGMENT_SIZE$p();
        SemaphoreImpl $this$findSegmentAndMoveForward$iv = this;
        boolean $i$f$findSegmentAndMoveForward = false;
        block0: do {
            Object $this$findSegmentInternal$iv$iv;
            block14: {
                Object object;
                $this$findSegmentInternal$iv$iv = curHead;
                boolean $i$f$findSegmentInternal = false;
                Segment cur$iv$iv = $this$findSegmentInternal$iv$iv;
                while (cur$iv$iv.getId() < id || cur$iv$iv.getRemoved()) {
                    void p2;
                    ConcurrentLinkedListNode this_$iv$iv$iv = cur$iv$iv;
                    boolean $i$f$nextOrIfClosed = false;
                    Object object2 = ConcurrentLinkedListNode.access$getNextOrClosed$p(this_$iv$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object it$iv$iv$iv = object2;
                    boolean bl4 = false;
                    if (it$iv$iv$iv == ConcurrentLinkedListKt.access$getCLOSED$p()) {
                        boolean bl5 = false;
                        object = SegmentOrClosed.constructor-impl(ConcurrentLinkedListKt.access$getCLOSED$p());
                        break block14;
                    }
                    Segment next$iv$iv = (Segment)((ConcurrentLinkedListNode)it$iv$iv$iv);
                    if (next$iv$iv != null) {
                        cur$iv$iv = next$iv$iv;
                        continue;
                    }
                    SemaphoreSegment semaphoreSegment = (SemaphoreSegment)cur$iv$iv;
                    long p1 = cur$iv$iv.getId() + 1L;
                    boolean bl6 = false;
                    Segment newTail$iv$iv = SemaphoreKt.access$createSegment(p1, (SemaphoreSegment)p2);
                    if (!cur$iv$iv.trySetNext((ConcurrentLinkedListNode)newTail$iv$iv)) continue;
                    if (cur$iv$iv.getRemoved()) {
                        cur$iv$iv.remove();
                    }
                    cur$iv$iv = newTail$iv$iv;
                }
                object = s$iv = SegmentOrClosed.constructor-impl(cur$iv$iv);
            }
            if (SegmentOrClosed.isClosed-impl(s$iv)) break;
            $this$findSegmentInternal$iv$iv = $this$findSegmentAndMoveForward$iv;
            Object to$iv$iv = SegmentOrClosed.getSegment-impl(s$iv);
            boolean $i$f$moveForward = false;
            void $this$loop$iv$iv$iv = $this$moveForward$iv$iv;
            boolean $i$f$loop = false;
            while (true) {
                Segment cur$iv$iv = (Segment)$this$loop$iv$iv$iv.head;
                boolean bl7 = false;
                if (cur$iv$iv.getId() >= ((Segment)to$iv$iv).getId()) {
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).tryIncPointers$kotlinx_coroutines_core()) {
                    bl = false;
                    continue block0;
                }
                if (head$FU.compareAndSet($this$moveForward$iv$iv, cur$iv$iv, to$iv$iv)) {
                    if (cur$iv$iv.decPointers$kotlinx_coroutines_core()) {
                        cur$iv$iv.remove();
                    }
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).decPointers$kotlinx_coroutines_core()) continue;
                ((ConcurrentLinkedListNode)to$iv$iv).remove();
            }
        } while (!bl);
        SemaphoreSegment segment = (SemaphoreSegment)SegmentOrClosed.getSegment-impl(s$iv);
        segment.cleanPrev();
        if (segment.getId() > id) {
            return false;
        }
        int i = (int)(deqIdx % (long)SemaphoreKt.access$getSEGMENT_SIZE$p());
        $this$moveForward$iv$iv = segment;
        Symbol value$iv222 = SemaphoreKt.access$getPERMIT$p();
        int $i$f$getAndSet = 0;
        Symbol cellState = this_$iv222.acquirers.getAndSet(i, value$iv222);
        if (cellState == null) {
            void expected$iv;
            int this_$iv222 = SemaphoreKt.access$getMAX_SPIN_CYCLES$p();
            boolean value$iv222 = false;
            $i$f$getAndSet = 0;
            $i$f$getAndSet = 0;
            int $this$loop$iv$iv$iv = this_$iv222;
            while ($i$f$getAndSet < $this$loop$iv$iv$iv) {
                void this_$iv;
                int it = $i$f$getAndSet++;
                boolean bl8 = false;
                SemaphoreSegment bl7 = segment;
                int index$iv = i;
                boolean $i$f$get = false;
                if (this_$iv.acquirers.get(index$iv) != SemaphoreKt.access$getTAKEN$p()) continue;
                return true;
            }
            SemaphoreSegment this_$iv222 = segment;
            Symbol value$iv222 = SemaphoreKt.access$getPERMIT$p();
            Symbol value$iv = SemaphoreKt.access$getBROKEN$p();
            boolean $i$f$cas = false;
            return !this_$iv222.acquirers.compareAndSet(i, expected$iv, value$iv);
        }
        if (cellState == SemaphoreKt.access$getCANCELLED$p()) {
            return false;
        }
        return SemaphoreKt.access$tryResume((CancellableContinuation)((Object)cellState));
    }

    public SemaphoreImpl(int permits, int acquiredPermits) {
        this.permits = permits;
        this.deqIdx = 0L;
        this.enqIdx = 0L;
        int n = this.permits > 0 ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Semaphore should have at least 1 permit, but had " + this.permits;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = acquiredPermits;
        n = 0 <= n && this.permits >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "The number of acquired permits should be in 0.." + this.permits;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        SemaphoreSegment s = new SemaphoreSegment(0L, null, 2);
        this.head = s;
        this.tail = s;
        this._availablePermits = this.permits - acquiredPermits;
    }
}

