/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.client;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import ladylib.LadyLib;
import ladylib.client.particle.ISpecialParticle;
import ladysnake.gaspunk.CommonProxy;
import ladysnake.gaspunk.GasPunk;
import ladysnake.gaspunk.api.IGasParticleType;
import ladysnake.gaspunk.api.customization.GrenadeSkins;
import ladysnake.gaspunk.client.particle.ParticleGasSmoke;
import ladysnake.gaspunk.client.render.entity.LayerBelt;
import ladysnake.gaspunk.init.ModItems;
import ladysnake.gaspunk.item.ItemGasTube;
import ladysnake.gaspunk.util.SpecialRewardChecker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private int particleCount = 0;
    private Property selectedSkin;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
    }

    @Override
    public void postInit() {
        super.postInit();
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> tintIndex == 0 ? ItemGasTube.getContainedGas(stack).getBottleColor() : Color.WHITE.getRGB(), new Item[]{ModItems.GAS_TUBE, ModItems.GRENADE});
        if (Loader.isModLoaded((String)"baubles")) {
            Minecraft.func_71410_x().func_175598_ae().getSkinMap().forEach((s, render) -> render.func_177094_a((LayerRenderer)new LayerBelt()));
        }
    }

    @Override
    public void makeSmoke(World world, double x, double y, double z, int color, int amount, int radX, int radY, IGasParticleType texture) {
        if (!world.field_72995_K) {
            return;
        }
        float b = (float)(color & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        if (a == 0.0f) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            this.particleCount += world.field_73012_v.nextInt(3);
            if (this.particleCount % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) != 0) continue;
            double posX = x + world.field_73012_v.nextGaussian() * (double)radX % (double)radX;
            double posY = y + world.field_73012_v.nextGaussian() * (double)radY % (double)radY;
            double posZ = z + world.field_73012_v.nextGaussian() * (double)radX % (double)radX;
            ParticleGasSmoke particle = new ParticleGasSmoke(world, posX, posY, posZ, r, g, b, a, (float)(55.0 + 20.0 * world.field_73012_v.nextGaussian()));
            particle.setTexture(texture.getParticleTexture());
            LadyLib.getParticleManager().addParticle((ISpecialParticle)particle);
        }
    }

    @Override
    public void onSpecialRewardsRetrieved() {
        UUID profileID = Minecraft.func_71410_x().func_110432_I().func_148256_e().getId();
        if (SpecialRewardChecker.isSpecialPerson(profileID)) {
            ImmutableList<GrenadeSkins> awardedSkins = SpecialRewardChecker.getRewards(profileID);
            String[] skinNames = (String[])awardedSkins.stream().map(GrenadeSkins::getDisplayName).toArray(String[]::new);
            String defaultSkin = awardedSkins.stream().filter(g -> g != GrenadeSkins.NONE).findAny().orElse(GrenadeSkins.NONE).getDisplayName();
            this.selectedSkin = this.config.get("general", "specialGrenadeSkin", defaultSkin, "The kind of diffuser you will craft (grenade skins are determined by the diffuser used)", skinNames);
        }
    }

    @Override
    public GrenadeSkins getSelectedSkin() {
        return ClientProxy.getGrenadeSkinProperty().map(Property::getString).map(GrenadeSkins::fromDisplayName).orElse(GrenadeSkins.NONE);
    }

    public static Optional<Property> getGrenadeSkinProperty() {
        if (GasPunk.proxy instanceof ClientProxy) {
            return Optional.ofNullable(((ClientProxy)GasPunk.proxy).selectedSkin);
        }
        return Optional.empty();
    }
}

