/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.gas;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import ladylib.client.shader.ShaderRegistryEvent;
import ladylib.client.shader.ShaderUtil;
import ladysnake.gaspunk.GasPunk;
import ladysnake.gaspunk.GasPunkConfig;
import ladysnake.gaspunk.api.AbstractGas;
import ladysnake.gaspunk.api.IBreathingHandler;
import ladysnake.gaspunk.api.IGas;
import ladysnake.gaspunk.api.IGasAgent;
import ladysnake.gaspunk.api.IGasParticleType;
import ladysnake.gaspunk.api.IGasType;
import ladysnake.gaspunk.gas.core.GasDeserializer;
import ladysnake.gaspunk.init.ModGases;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@JsonAdapter(value=GasDeserializer.class)
@Mod.EventBusSubscriber(modid="gaspunk")
public class Gas
extends AbstractGas {
    public static final ResourceLocation GAS_TEX_PATH = new ResourceLocation("gaspunk", "textures/gui/vapor_overlay.png");
    public static final ResourceLocation NOISE_TEX_PATH = new ResourceLocation("gaspunk", "textures/gui/noise.png");
    public static final ResourceLocation OVERLAY_SHADER = new ResourceLocation("gaspunk", "gas_overlay");
    protected final IGasType type;
    protected final IGasParticleType particleType;
    protected int color;
    protected int bottleColor;
    protected ImmutableList<AbstractGas.AgentEffect> agents;
    protected String[] tooltipLines;

    public static void classInit() {
    }

    @SubscribeEvent
    public static void onShaderRegistry(ShaderRegistryEvent event) {
        event.registerShader(OVERLAY_SHADER);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        ModGases.REGISTRY.getValuesCollection().stream().map(IGas::getParticleType).map(IGasParticleType::getParticleTexture).distinct().forEach(arg_0 -> ((TextureMap)event.getMap()).func_174942_a(arg_0));
    }

    public Gas(IGasType type, int color, IGasAgent agent, float potency) {
        this(type, color, new AbstractGas.AgentEffect(agent, potency));
    }

    public Gas(IGasType type, int color, AbstractGas.AgentEffect ... agents) {
        this(type, type.getParticleType(), color, color, (ImmutableList<AbstractGas.AgentEffect>)ImmutableList.copyOf((Object[])agents), new String[0]);
    }

    public Gas(IGasType type, IGasParticleType particleType, int color, int bottleColor, ImmutableList<AbstractGas.AgentEffect> agents, String[] tooltipLines) {
        this.type = type;
        this.particleType = particleType;
        this.color = color;
        this.bottleColor = bottleColor;
        this.agents = agents;
        this.tooltipLines = tooltipLines;
    }

    @Override
    public IGasType getType() {
        return this.type;
    }

    @Override
    public IGasParticleType getParticleType() {
        return this.particleType;
    }

    @Override
    public void applyEffect(EntityLivingBase entity, IBreathingHandler handler, float concentration, boolean firstTick, boolean forced) {
        this.agents.forEach(agent -> agent.getAgent().applyEffect(entity, handler, concentration, firstTick, agent.getPotency()));
    }

    @Override
    public void onExitCloud(EntityLivingBase entity, IBreathingHandler handler) {
        this.agents.forEach(agent -> agent.getAgent().onExitCloud(entity, handler));
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getBottleColor() {
        return this.bottleColor;
    }

    @Override
    public boolean isToxic() {
        return this.agents.stream().map(AbstractGas.AgentEffect::getAgent).anyMatch(IGasAgent::isToxic);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        for (AbstractGas.AgentEffect effect : this.agents) {
            tooltip.add(effect.getAgent().getLocalizedName());
        }
        for (String line : this.tooltipLines) {
            tooltip.add(I18n.func_135052_a((String)line, (Object[])new Object[0]));
        }
        if (flagIn.func_194127_a()) {
            tooltip.add(TextFormatting.DARK_GRAY + "" + this.getRegistryName());
        }
    }

    @Override
    public ImmutableList<AbstractGas.AgentEffect> getAgents() {
        return this.agents;
    }

    @Override
    public String[] getTooltipLines() {
        return this.tooltipLines;
    }

    protected ResourceLocation getOverlayTexture() {
        return GasPunkConfig.client.useShaders ? NOISE_TEX_PATH : GAS_TEX_PATH;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(float concentration, float partialTicks, ScaledResolution resolution) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        int color = this.getColor();
        float b = (float)(color & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)(concentration * a));
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getOverlayTexture());
        ShaderUtil.useShader((ResourceLocation)OVERLAY_SHADER);
        ShaderUtil.setUniform((String)"gasColor", (float[])new float[]{r, g, b, a});
        ShaderUtil.setUniform((String)"iTime", (int)((int)System.currentTimeMillis()));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(0.0, (double)resolution.func_78328_b(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)resolution.func_78326_a(), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        ShaderUtil.revert();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        try {
            Field f = AbstractGas.class.getDeclaredField("builderSupplier");
            f.setAccessible(true);
            f.set(null, Builder::new);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            GasPunk.LOGGER.error("Error while setting the builderSupplier in the api", (Throwable)e);
        }
    }

    public static final class Builder
    implements AbstractGas.Builder {
        private IGasType type;
        private IGasParticleType particleType;
        private int color;
        private Integer bottleColor;
        private ImmutableList.Builder<AbstractGas.AgentEffect> agents = ImmutableList.builder();
        private List<String> tooltipLines = new ArrayList<String>();

        @Override
        public Builder setType(IGasType type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder setParticleType(IGasParticleType type) {
            this.particleType = type;
            return this;
        }

        @Override
        public Builder setColor(int color) {
            this.color = color;
            return this;
        }

        @Override
        public Builder setBottleColor(int color) {
            this.bottleColor = color;
            return this;
        }

        @Override
        public Builder addAgent(IGasAgent agent, float potency) {
            this.agents.add((Object)new AbstractGas.AgentEffect(agent, potency));
            return this;
        }

        @Override
        public Builder addTooltipLine(String tooltipLine) {
            this.tooltipLines.add(tooltipLine);
            return this;
        }

        @Override
        public Gas build() {
            if (this.type == null) {
                throw new IllegalStateException("gas type not provided");
            }
            return new Gas(this.type, this.particleType == null ? this.type.getParticleType() : this.particleType, this.color, this.bottleColor == null ? this.color : this.bottleColor, (ImmutableList<AbstractGas.AgentEffect>)this.agents.build(), this.tooltipLines.toArray(new String[0]));
        }
    }
}

