/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.gas.agent;

import ladysnake.gaspunk.GasPunk;
import ladysnake.gaspunk.api.IBreathingHandler;
import ladysnake.gaspunk.gas.agent.GasAgent;
import ladysnake.pathos.api.ISickness;
import ladysnake.pathos.api.SicknessEffect;
import ladysnake.pathos.capability.CapabilitySickness;
import ladysnake.pathos.sickness.Sickness;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class LingeringAgent
extends GasAgent {
    protected boolean ignoreBreath;
    private ResourceLocation sicknessId;
    private ISickness sickness;

    public LingeringAgent(boolean toxic, boolean ignoreBreath, ResourceLocation sickness) {
        super(toxic);
        this.ignoreBreath = ignoreBreath;
        this.sicknessId = sickness;
    }

    public void addEffectToEntity(EntityLivingBase entity, float concentration, float potency) {
        CapabilitySickness.getHandler((Entity)entity).ifPresent(h -> h.addSickness(new SicknessEffect(this.getSickness(), potency * concentration / 20.0f)));
    }

    @Override
    public void applyEffect(EntityLivingBase entity, IBreathingHandler handler, float concentration, boolean firstTick, float potency, boolean forced) {
        if (forced || this.ignoreBreath || handler.getAirSupply() <= 0.0f) {
            this.addEffectToEntity(entity, concentration, potency);
        }
    }

    public ISickness getSickness() {
        if (this.sickness == null) {
            this.sickness = (ISickness)Sickness.REGISTRY.getValue(this.sicknessId);
            if (this.sickness == null) {
                GasPunk.LOGGER.warn("Lingering gas agent {} is linked to invalid sickness id {}", (Object)this.getRegistryName(), (Object)this.sicknessId);
                return Sickness.NONE;
            }
        }
        return this.sickness;
    }
}

