/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladysnake.gaspunk.GasPunk;
import ladysnake.gaspunk.api.IGas;
import ladysnake.gaspunk.init.ModGases;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGasTube
extends Item {
    public static final String NBT_CONTAINED_GAS = "gaspunk:contained_gas";

    public ItemGasTube() {
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("gaspunk", "gas_type"), (stack, worldIn, entityIn) -> ItemGasTube.getContainedGas(stack).getType().getId());
    }

    public static IGas getContainedGas(ItemStack stack) {
        IGas ret = null;
        if (stack.func_77942_o()) {
            ret = (IGas)ModGases.REGISTRY.getValue(new ResourceLocation(Objects.requireNonNull(stack.func_77978_p()).func_74779_i(NBT_CONTAINED_GAS)));
        }
        return ret == null ? ModGases.AIR : ret;
    }

    public ItemStack getItemStackFor(IGas gas) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a(NBT_CONTAINED_GAS, Objects.requireNonNull(gas.getRegistryName(), "Can't use an unregistered gas in grenade").toString());
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return I18n.func_74837_a((String)(this.func_77658_a() + ".name"), (Object[])new Object[]{I18n.func_74837_a((String)ItemGasTube.getContainedGas(stack).getUnlocalizedName(), (Object[])new Object[0])});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemGasTube.getContainedGas(stack).addInformation(stack, worldIn, tooltip, flagIn);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        return new ActionResult(EnumActionResult.SUCCESS, (Object)this.turnTubeIntoItem(playerIn.func_184586_b(handIn), playerIn, new ItemStack(Items.field_151069_bo)));
    }

    protected ItemStack turnTubeIntoItem(ItemStack emptyTubes, EntityPlayer player, ItemStack stack) {
        emptyTubes.func_190918_g(1);
        player.func_71029_a(Objects.requireNonNull(StatList.func_188057_b((Item)this)));
        if (emptyTubes.func_190926_b()) {
            return stack;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
        return emptyTubes;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab == GasPunk.CREATIVE_TAB) {
            for (IGas gas : ModGases.REGISTRY.getValues()) {
                items.add((Object)this.getItemStackFor(gas));
            }
        }
    }
}

