/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.item;

import javax.annotation.Nonnull;
import ladylib.misc.ItemUtil;
import ladysnake.gaspunk.GasPunkConfig;
import ladysnake.gaspunk.api.IGas;
import ladysnake.gaspunk.api.customization.IHasSkin;
import ladysnake.gaspunk.entity.EntityGasCloud;
import ladysnake.gaspunk.entity.EntityGrenade;
import ladysnake.gaspunk.init.ModGases;
import ladysnake.gaspunk.init.ModItems;
import ladysnake.gaspunk.item.ItemGasTube;
import ladysnake.gaspunk.item.SkinItem;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ItemGrenade
extends ItemGasTube
implements IHasSkin {
    public ItemGrenade() {
        this.func_185043_a(new ResourceLocation("gaspunk", "unpinned"), (stack, worldIn, entityIn) -> entityIn != null && entityIn.func_184607_cu() == stack || stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("isEntityGrenade") ? 1.0f : 0.0f);
        this.func_185043_a(SkinItem.CUSTOM_SKIN_PROPERTY, SkinItem.CUSTOM_SKIN_GETTER);
        this.func_77625_d(1);
    }

    public int getItemStackLimit(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt.func_74767_n("gaspunk:belt_equipped") ? 4 : 1;
        }
        return super.getItemStackLimit(stack);
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLivingBase, int timeLeft) {
        if (!worldIn.field_72995_K) {
            worldIn.func_184148_a(null, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, SoundEvents.field_187827_fP, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            ItemStack stack1 = entityLivingBase instanceof EntityPlayer && ((EntityPlayer)entityLivingBase).func_184812_l_() ? stack.func_77946_l() : stack.func_77979_a(1);
            EntityGrenade grenade = new EntityGrenade(worldIn, entityLivingBase, stack1);
            grenade.setCountdown(timeLeft);
            grenade.shoot((Entity)entityLivingBase, entityLivingBase.field_70125_A, entityLivingBase.field_70177_z, 0.0f, 1.5f, 1.0f);
            worldIn.func_72838_d((Entity)grenade);
        }
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!worldIn.field_72995_K) {
            EntityGasCloud cloud = this.explode((WorldServer)worldIn, entityLiving.func_174791_d(), stack);
            cloud.setEmitter((Entity)entityLiving);
        }
        ItemGrenade grenadeItem = (ItemGrenade)stack.func_77973_b();
        ItemStack emptyGrenade = new ItemStack(ModItems.EMPTY_GRENADE);
        ((SkinItem)ModItems.EMPTY_GRENADE).setSkin(emptyGrenade, grenadeItem.getSkin(stack));
        return ItemUtil.turnItemIntoAnother((ItemStack)stack, (EntityLivingBase)entityLiving, (ItemStack)emptyGrenade, (boolean)false);
    }

    public EntityGasCloud explode(WorldServer worldIn, Vec3d pos, ItemStack stack) {
        worldIn.func_175739_a(EnumParticleTypes.SMOKE_LARGE, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 20, 0.5, 0.5, 0.5, 0.2, new int[0]);
        EntityGasCloud cloud = new EntityGasCloud((World)worldIn, ItemGrenade.getContainedGas(stack));
        cloud.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        int lifespan = GasPunkConfig.gasLifespan;
        cloud.setMaxLifespan(lifespan);
        worldIn.func_72838_d((Entity)cloud);
        return cloud;
    }

    public int func_77626_a(ItemStack stack) {
        return 60;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    @Override
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (IGas gas : ModGases.REGISTRY.getValues()) {
                items.add((Object)this.getItemStackFor(gas));
            }
        }
    }
}

