/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.pathos.capability;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladysnake.pathos.api.ISickness;
import ladysnake.pathos.api.ISicknessHandler;
import ladysnake.pathos.api.SicknessEffect;
import ladysnake.pathos.api.event.SicknessEvent;
import ladysnake.pathos.capability.PlayerSicknessHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="pathos")
public class CapabilitySickness {
    @CapabilityInject(value=ISicknessHandler.class)
    public static Capability<ISicknessHandler> CAPABILITY_SICKNESS;

    public static void register() {
        CapabilityManager.INSTANCE.register(ISicknessHandler.class, (Capability.IStorage)new Storage(), DefaultSicknessHandler::new);
    }

    public static Optional<ISicknessHandler> getHandler(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            return Optional.ofNullable(entity.getCapability(CAPABILITY_SICKNESS, null));
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase) {
            event.addCapability(new ResourceLocation("pathos", "sickness_cap"), (ICapabilityProvider)new Provider((EntityLivingBase)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        CapabilitySickness.getHandler(event.getEntity()).ifPresent(ISicknessHandler::tick);
    }

    public static class Storage
    implements Capability.IStorage<ISicknessHandler> {
        @Nullable
        public NBTBase writeNBT(Capability<ISicknessHandler> capability, ISicknessHandler instance, EnumFacing side) {
            NBTTagList nbtList = new NBTTagList();
            for (SicknessEffect effect : instance.getActiveSicknesses()) {
                nbtList.func_74742_a((NBTBase)effect.serializeNBT());
            }
            return nbtList;
        }

        public void readNBT(Capability<ISicknessHandler> capability, ISicknessHandler instance, EnumFacing side, NBTBase nbt) {
            if (nbt instanceof NBTTagList) {
                for (NBTBase effect : (NBTTagList)nbt) {
                    if (!(effect instanceof NBTTagCompound)) continue;
                    instance.addSickness(new SicknessEffect((NBTTagCompound)effect));
                }
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagList> {
        final ISicknessHandler instance;

        Provider(EntityLivingBase object) {
            this.instance = object instanceof EntityPlayerMP ? new PlayerSicknessHandler((EntityPlayerMP)object) : new DefaultSicknessHandler(object);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY_SICKNESS;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CAPABILITY_SICKNESS ? CAPABILITY_SICKNESS.cast((Object)this.instance) : null);
        }

        public NBTTagList serializeNBT() {
            return (NBTTagList)CAPABILITY_SICKNESS.getStorage().writeNBT(CAPABILITY_SICKNESS, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagList nbt) {
            CAPABILITY_SICKNESS.getStorage().readNBT(CAPABILITY_SICKNESS, (Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class DefaultSicknessHandler
    implements ISicknessHandler {
        private EntityLivingBase carrier;
        private Map<ISickness, SicknessEffect> sicknesses = new HashMap<ISickness, SicknessEffect>();

        DefaultSicknessHandler() {
        }

        public DefaultSicknessHandler(EntityLivingBase carrier) {
            this.carrier = carrier;
        }

        @Override
        public boolean isSicknessActive(ISickness sickness) {
            return this.sicknesses.containsKey(sickness);
        }

        @Override
        public void addSickness(SicknessEffect effect, BiFunction<SicknessEffect, SicknessEffect, SicknessEffect> mergeFunction) {
            SicknessEvent.SicknessAddEvent event = new SicknessEvent.SicknessAddEvent(this, this.carrier, effect, mergeFunction);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                this.sicknesses.merge(effect.getSickness(), effect, event.getMergeFunction());
            }
        }

        @Override
        public void tick() {
            Iterator<Map.Entry<ISickness, SicknessEffect>> iterator = this.sicknesses.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ISickness, SicknessEffect> entry = iterator.next();
                SicknessEffect sickness = entry.getValue();
                if (!MinecraftForge.EVENT_BUS.post((Event)new SicknessEvent.SicknessTickEvent(this, this.carrier, sickness))) {
                    this.updateEffect(sickness);
                }
                if (sickness.getSeverity() != 0.0f || MinecraftForge.EVENT_BUS.post((Event)new SicknessEvent.SicknessCureEvent(this, this.carrier, sickness))) continue;
                sickness.onCured(this.carrier);
                iterator.remove();
            }
        }

        protected void updateEffect(SicknessEffect effect) {
            effect.performEffect(this.carrier);
        }

        @Override
        public Collection<SicknessEffect> getActiveSicknesses() {
            return this.sicknesses.values();
        }

        @Override
        public SicknessEffect getActiveEffect(ISickness sickness) {
            return this.sicknesses.get(sickness);
        }
    }
}

