/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.blocks;

import com.legacy.goodnightsleep.GNSConfig;
import com.legacy.goodnightsleep.blocks.GNSBlocks;
import com.legacy.goodnightsleep.tile_entity.TileEntityLuxuriousBed;
import com.legacy.goodnightsleep.tile_entity.TileEntityStrangeBed;
import com.legacy.goodnightsleep.tile_entity.TileEntityWretchedBed;
import com.legacy.goodnightsleep.world.GNSDimensions;
import com.legacy.goodnightsleep.world.GNSTeleportationUtil;
import com.legacy.goodnightsleep.world.dream.GoodDreamDimension;
import com.legacy.goodnightsleep.world.nightmare.NightmareDimension;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;

public class GNSBedBlock
extends BedBlock {
    public GNSBedBlock(Block.Properties properties) {
        super(DyeColor.WHITE, properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            if (player.field_71093_bK == DimensionType.field_223227_a_) {
                player.setSpawnPoint(pos, false, false, DimensionType.field_223227_a_);
                player.func_213369_d(pos);
            }
            if (this == GNSBlocks.luxurious_bed) {
                this.travelToDream(player, true);
            } else if (this == GNSBlocks.wretched_bed) {
                this.travelToDream(player, false);
            } else if (this == GNSBlocks.strange_bed) {
                this.travelToDream(player, worldIn.field_73012_v.nextBoolean());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    private void travelToDream(PlayerEntity player, boolean dream) {
        ServerWorld serverWorld;
        DimensionType transferDimension;
        DimensionType dimensionType = transferDimension = player.field_71093_bK == GNSDimensions.dimensionType(dream) ? DimensionType.field_223227_a_ : GNSDimensions.dimensionType(dream);
        if (transferDimension == GNSDimensions.dimensionType(true)) {
            serverWorld = player.func_184102_h().func_71218_a(GNSDimensions.dimensionType(true));
            if (((GoodDreamDimension)serverWorld.func_201675_m()).dreamPlayerList.size() <= 0 && !GNSConfig.disableTimePassing) {
                player.field_70170_p.func_72877_b(0L);
            }
        } else if (transferDimension == GNSDimensions.dimensionType(false)) {
            serverWorld = player.func_184102_h().func_71218_a(GNSDimensions.dimensionType(false));
            if (((NightmareDimension)serverWorld.func_201675_m()).nightmarePlayerList.size() <= 0 && !GNSConfig.disableTimePassing) {
                player.field_70170_p.func_72877_b(0L);
            }
        }
        try {
            BlockPos pos = player.field_71093_bK != DimensionType.field_223227_a_ ? player.getBedLocation(DimensionType.field_223227_a_) : player.field_70170_p.func_175694_M();
            GNSTeleportationUtil.changeDimension(transferDimension, (Entity)player, pos);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (this == GNSBlocks.luxurious_bed) {
            return new TileEntityLuxuriousBed();
        }
        if (this == GNSBlocks.wretched_bed) {
            return new TileEntityWretchedBed();
        }
        return new TileEntityStrangeBed();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }
}

