/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.blocks.natural;

import com.legacy.goodnightsleep.blocks.GNSBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class GNSFarmlandBlock
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.field_208133_ah;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public GNSFarmlandBlock(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());
        return !iblockstate.func_185904_a().func_76220_a() || iblockstate.func_177230_c() instanceof FenceGateBlock;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return !this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) ? GNSBlocks.dream_dirt.func_176223_P() : super.func_196258_a(context);
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return worldIn.func_201572_C();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            GNSFarmlandBlock.turnToDirt(state, (World)worldIn, pos);
        } else {
            int i = (Integer)state.func_177229_b((IProperty)MOISTURE);
            if (!GNSFarmlandBlock.hasWater((IWorldReader)worldIn, pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
                if (i > 0) {
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
                } else if (!this.hasCrops((IBlockReader)worldIn, pos)) {
                    GNSFarmlandBlock.turnToDirt(state, (World)worldIn, pos);
                }
            } else if (i < 7) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
            }
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && ForgeHooks.onFarmlandTrample((World)worldIn, (BlockPos)pos, (BlockState)GNSBlocks.dream_dirt.func_176223_P(), (float)fallDistance, (Entity)entityIn)) {
            GNSFarmlandBlock.turnToDirt(worldIn.func_180495_p(pos), worldIn, pos);
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    public static void turnToDirt(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, GNSFarmlandBlock.func_199601_a((BlockState)state, (BlockState)GNSBlocks.dream_dirt.func_176223_P(), (World)worldIn, (BlockPos)pos));
    }

    private boolean hasCrops(IBlockReader p_176529_0_, BlockPos worldIn) {
        BlockState state = p_176529_0_.func_180495_p(worldIn.func_177984_a());
        return state.func_177230_c() instanceof IPlantable && this.canSustainPlant(state, p_176529_0_, worldIn, Direction.UP, (IPlantable)state.func_177230_c());
    }

    private static boolean hasWater(IWorldReader p_176530_0_, BlockPos worldIn) {
        for (BlockPos blockpos$mutableblockpos : BlockPos.func_218278_a((BlockPos)worldIn.func_177982_a(-4, 0, -4), (BlockPos)worldIn.func_177982_a(4, 1, 4))) {
            if (!p_176530_0_.func_204610_c(blockpos$mutableblockpos).func_206884_a(FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)p_176530_0_, (BlockPos)worldIn);
    }

    public IItemProvider getItemDropped(BlockState state, World worldIn, BlockPos pos, int fortune) {
        return GNSBlocks.dream_dirt;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{MOISTURE});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

