/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.entity;

import com.legacy.goodnightsleep.client.audio.GNSSounds;
import com.legacy.goodnightsleep.entity.GNSEntityTypes;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class HerobrineEntity
extends MonsterEntity {
    public HerobrineEntity(EntityType<? extends HerobrineEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70158_ak = true;
    }

    public HerobrineEntity(World worldIn) {
        this(GNSEntityTypes.HEROBRINE, worldIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 127.0f, 99999.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return GNSSounds.ENTITY_HEROBRINE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GNSSounds.ENTITY_HEROBRINE_DEATH;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!(source instanceof IndirectEntityDamageSource) && source != DamageSource.field_191552_t) {
            boolean flag = super.func_70097_a(source, amount);
            if (source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
                this.teleportRandomly();
            }
            return flag;
        }
        for (int i = 0; i < 64; ++i) {
            if (!this.teleportRandomly()) continue;
            return true;
        }
        return false;
    }

    protected boolean teleportRandomly() {
        double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    private boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.func_226277_ct_() - p_70816_1_.func_226277_ct_(), this.func_174813_aQ().field_72338_b + (double)(this.func_213302_cg() / 2.0f) - p_70816_1_.func_226278_cu_() + (double)p_70816_1_.func_70047_e(), this.func_226281_cx_() - p_70816_1_.func_226281_cx_());
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutableblockpos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76230_c()) {
            blockpos$mutableblockpos.func_189536_c(Direction.DOWN);
        }
        if (!this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76230_c()) {
            return false;
        }
        EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
        if (flag) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187544_ad, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    private boolean shouldAttackPlayer(PlayerEntity player) {
        return player.func_70685_l((Entity)this);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.75f;
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final HerobrineEntity enderman;
        private PlayerEntity player;
        private int aggroTime;
        private int teleportTime;
        private final EntityPredicate field_220791_m;
        private final EntityPredicate field_220792_n = new EntityPredicate().func_221014_c();

        public FindPlayerGoal(HerobrineEntity p_i45842_1_) {
            super((MobEntity)p_i45842_1_, PlayerEntity.class, false);
            this.enderman = p_i45842_1_;
            this.field_220791_m = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(p_220790_1_ -> p_i45842_1_.shouldAttackPlayer((PlayerEntity)p_220790_1_));
        }

        public boolean func_75250_a() {
            this.player = this.enderman.field_70170_p.func_217370_a(this.field_220791_m, (LivingEntity)this.enderman);
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.enderman.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.enderman.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && this.field_220792_n.func_221015_a((LivingEntity)this.enderman, this.field_75309_a) ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.enderman.func_184218_aH()) {
                    if (this.enderman.shouldAttackPlayer((PlayerEntity)this.field_75309_a)) {
                        if (this.field_75309_a.func_70068_e((Entity)this.enderman) < 16.0) {
                            this.enderman.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (this.field_75309_a.func_70068_e((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportToEntity((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

